/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.metadata;

import com.vmware.vise.metadata.Units;
import com.vmware.vise.search.QueryContextType;
import com.vmware.vise.search.QueryExprInfo;
import com.vmware.vise.search.impl.NamespaceUtils;
import com.vmware.vise.search.impl.TypeRefUtils;
import com.vmware.vise.search.metadata.ChildNodeIndex;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.Restriction;
import com.vmware.vise.search.model.ModelUtils;
import com.vmware.vise.search.xquery.XQueryUtils;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.XMLUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class PropertyDescriptorImpl
implements PropertyDescriptor {
    private static boolean OPTIONAL = true;
    private static boolean REQUIRED = false;
    private static final String CARDINALITY_MANY = "many";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final String _name;
    private final String[] _aliases;
    private final String _title;
    private final String _provider;
    private final String _type;
    private final String _path;
    private final Units _unit;
    private final Units _displayForm;
    private final boolean _isMultiCardinality;
    private final boolean _isComputed;
    private final boolean _isUnsupportedPropertySortable;
    private final Set<String> _dependencyResourceModels;
    private final Map<String, String> _tags;
    private final List<QueryExprInfo> _queryExpressions;
    private final List<Restriction> _possibleValues;
    private final String _status;
    private final String _inapplicableOperators;
    private final String _providerResourceModel;
    private final String _providerResourceModelCanonicalName;
    private final String _simpleName;

    public PropertyDescriptorImpl(Node node, ClassLoader classLoader) {
        Validate.notNull((Object)node);
        ChildNodeIndex childNodeIndex = new ChildNodeIndex(node);
        this._status = XMLUtil.getAttribute((Element)((Element)node), (String)"status");
        this._path = childNodeIndex.getStringValueFor("path", OPTIONAL);
        this._name = childNodeIndex.getStringValueFor("name", this._path);
        this._simpleName = ModelUtils.getSimplePropertyName(this._name);
        this._aliases = this.getAliases(childNodeIndex);
        this._inapplicableOperators = childNodeIndex.getStringValueFor("inapplicableOperators", OPTIONAL);
        this._title = childNodeIndex.getStringValueFor("title", OPTIONAL);
        this._type = childNodeIndex.getStringValueFor("type", OPTIONAL);
        this._unit = this.getUnit(childNodeIndex);
        this._displayForm = this.getDisplayForm(childNodeIndex);
        this._provider = childNodeIndex.getStringValueFor("provider", REQUIRED);
        this._providerResourceModel = ModelUtils.getResourceModel(this._name);
        this._isMultiCardinality = this.getIsMultiCardinality(childNodeIndex);
        this._isComputed = childNodeIndex.getBooleanValueFor("computed", OPTIONAL);
        this._isUnsupportedPropertySortable = childNodeIndex.getBooleanValueFor("unsupportedPropertySortable", OPTIONAL);
        this._dependencyResourceModels = this.extractDependencyModels(childNodeIndex, "dependencyModels");
        this._tags = MetadataUtil.extractTags(childNodeIndex);
        this._queryExpressions = this.getQueryExpressions(childNodeIndex, this._provider, this._name);
        this._possibleValues = this.loadValueSpace(childNodeIndex, classLoader);
        this._providerResourceModelCanonicalName = childNodeIndex.getStringValueFor("providerResourceModelCanonicalName", OPTIONAL);
    }

    private PropertyDescriptorImpl(String string, String[] stringArray, String string2, String string3, String string4, String string5, String string6, Units units, Units units2, boolean bl, boolean bl2, boolean bl3, Set<String> set, Map<String, String> map, List<QueryExprInfo> list, List<Restriction> list2, String string7, String string8) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string2});
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        this._name = string;
        this._simpleName = ModelUtils.getSimplePropertyName(this._name);
        this._aliases = stringArray;
        this._provider = string2;
        this._providerResourceModel = ModelUtils.getResourceModel(this._name);
        this._title = string3;
        this._inapplicableOperators = string4;
        this._type = string5;
        this._path = string6;
        this._unit = units;
        this._displayForm = units2;
        this._isMultiCardinality = bl;
        this._isComputed = bl2;
        this._isUnsupportedPropertySortable = bl3;
        this._dependencyResourceModels = set;
        this._tags = map;
        this._queryExpressions = list;
        this._possibleValues = list2;
        this._status = string7;
        this._providerResourceModelCanonicalName = string8;
    }

    static PropertyDescriptor createPropertyDescriptor(String string, String string2, String string3, List<QueryExprInfo> list, String string4, String string5, String string6) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        ValidationUtil.paramsNotNull((Object[])new Object[]{string2});
        if (list == null) {
            list = PropertyDescriptorImpl.createDefaultQueryExpressionsFromProviderAndName(string, string2);
        }
        Map<String, String> map = Collections.emptyMap();
        List<Restriction> list2 = Collections.emptyList();
        PropertyDescriptor propertyDescriptor = new PropertyDescriptorImpl(string2, EMPTY_STRING_ARRAY, string, "<" + string2 + ">", string4, string3, null, null, null, false, false, false, Collections.emptySet(), map, list, list2, string5, string6);
        propertyDescriptor = PropertyDescriptorUtils.transformPropertyDescriptorByNameMetadata(propertyDescriptor, string, string2);
        return propertyDescriptor;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String[] getAliases() {
        return this._aliases;
    }

    @Override
    public String getProvider() {
        return this._provider;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public Units getUnit() {
        return this._unit;
    }

    @Override
    public Units getDisplayForm() {
        return this._displayForm;
    }

    @Override
    public boolean isMultiCardinality() {
        return this._isMultiCardinality;
    }

    @Override
    public Set<String> getDependencyResourceModels() {
        return this._dependencyResourceModels;
    }

    @Override
    public boolean isComputed() {
        return this._isComputed;
    }

    @Override
    public boolean isUnsupportedPropertySortable() {
        return this._isUnsupportedPropertySortable;
    }

    @Override
    public Map<String, String> getTags() {
        return this._tags;
    }

    @Override
    public List<QueryExprInfo> getQueryExpressions() {
        return this._queryExpressions;
    }

    @Override
    public String getStatus() {
        return this._status;
    }

    @Override
    public List<Restriction> getValueSpace() {
        return this._possibleValues;
    }

    @Override
    public String getInapplicableOperators() {
        return this._inapplicableOperators;
    }

    @Override
    public String getProviderResourceModel() {
        return this._providerResourceModel;
    }

    @Override
    public String getProviderResourceModelCanonicalName() {
        return this._providerResourceModelCanonicalName;
    }

    @Override
    public String getSimpleName() {
        return this._simpleName;
    }

    private String[] getAliases(ChildNodeIndex childNodeIndex) {
        assert (childNodeIndex != null);
        Collection<Node> collection = childNodeIndex.getNodes("alias");
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (Node node : collection) {
            String string;
            stringArray[n] = string = XMLUtil.getTagValue((Element)((Element)node));
            ++n;
        }
        return stringArray;
    }

    private Set<String> extractDependencyModels(ChildNodeIndex childNodeIndex, String string) {
        Set<String> set;
        String string2 = childNodeIndex.getStringValueFor(string, OPTIONAL);
        if (string2 != null) {
            String[] stringArray = StringUtils.split((String)string2, (String)"\n ,");
            set = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(stringArray)));
        } else {
            set = Collections.emptySet();
        }
        return set;
    }

    private boolean getIsMultiCardinality(ChildNodeIndex childNodeIndex) {
        assert (childNodeIndex != null);
        String string = childNodeIndex.getStringValueFor("cardinality", OPTIONAL);
        return CARDINALITY_MANY.equals(string);
    }

    private Units getUnit(ChildNodeIndex childNodeIndex) {
        String string = childNodeIndex.getStringValueFor("unit", OPTIONAL);
        if (string == null) {
            return null;
        }
        return Units.valueOf((String)string.toUpperCase(Locale.ENGLISH));
    }

    private Units getDisplayForm(ChildNodeIndex childNodeIndex) {
        String string = childNodeIndex.getStringValueFor("displayForm", OPTIONAL);
        if (string == null) {
            return null;
        }
        return Units.valueOf((String)string.toUpperCase(Locale.ENGLISH));
    }

    private List<QueryExprInfo> getQueryExpressions(ChildNodeIndex childNodeIndex, String string, String string2) {
        List<QueryExprInfo> list = MetadataUtil.extractQueryExpressions(childNodeIndex);
        if (!list.isEmpty()) {
            return list;
        }
        return PropertyDescriptorImpl.createDefaultQueryExpressionsFromProviderAndName(string, string2);
    }

    private static List<QueryExprInfo> createDefaultQueryExpressionsFromProviderAndName(String string, String string2) {
        String string3 = ModelUtils.getSimplePropertyName(string2);
        String string4 = ModelUtils.getResourceModel(string2);
        String string5 = PropertyDescriptorUtils.stripOffMetaInfoFromPropName(string3);
        String string6 = NamespaceUtils.getNamespace(string);
        String string7 = MetadataUtil.getQueryExprForPropertyPath(string5, string6);
        ArrayList<QueryExprInfo> arrayList = new ArrayList<QueryExprInfo>();
        QueryExprInfo queryExprInfo = new QueryExprInfo();
        queryExprInfo.expression = XQueryUtils.addQualifiedTargetIdFor(string4, "target", string7);
        queryExprInfo.queryType = QueryContextType.CONTEXT_BOUNDED;
        QueryExprInfo queryExprInfo2 = new QueryExprInfo();
        queryExprInfo2.expression = string7;
        queryExprInfo2.queryType = QueryContextType.CONTEXT_CURRENT;
        QueryExprInfo queryExprInfo3 = new QueryExprInfo();
        queryExprInfo3.expression = string7;
        queryExprInfo3.queryType = QueryContextType.CONTEXT_NONE;
        arrayList.add(queryExprInfo);
        arrayList.add(queryExprInfo2);
        arrayList.add(queryExprInfo3);
        return arrayList;
    }

    private List<Restriction> loadValueSpace(ChildNodeIndex childNodeIndex, ClassLoader classLoader) {
        Collection<Node> collection = childNodeIndex.getNodes("restriction");
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Restriction> arrayList = new ArrayList<Restriction>();
        for (Node node : collection) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (1 != node2.getNodeType()) continue;
                Restriction.RestrictionType restrictionType = Restriction.RestrictionType.valueOf(node2.getNodeName().toUpperCase(Locale.ENGLISH));
                String string = this.getValue(node2);
                String string2 = this.getLabel(node2, classLoader);
                Restriction restriction = new Restriction(restrictionType, string, string2);
                arrayList.add(restriction);
            }
        }
        return arrayList;
    }

    private String getValue(Node node) {
        assert (node != null);
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("value");
        String string = node2.getTextContent();
        return string;
    }

    private String getLabel(Node node, ClassLoader classLoader) {
        assert (node != null);
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("label");
        String string = node2 != null ? node2.getTextContent() : null;
        return string;
    }

    private static QueryExprInfo createQueryExprInfo(QueryContextType queryContextType, String string) {
        QueryExprInfo queryExprInfo = new QueryExprInfo();
        queryExprInfo.queryType = queryContextType;
        queryExprInfo.expression = string;
        return queryExprInfo;
    }

    static class PropertyDescriptorUtils {
        PropertyDescriptorUtils() {
        }

        static PropertyDescriptor transformPropertyDescriptorByNameMetadata(PropertyDescriptor propertyDescriptor, String string, String string2) {
            ValidationUtil.paramsNotNull((Object[])new Object[]{propertyDescriptor});
            ValidationUtil.stringsNotNullOrEmpty((String[])new String[]{string2});
            if (string == null) {
                string = propertyDescriptor.getProvider();
            }
            if (string2.endsWith("._length")) {
                return PropertyDescriptorLengthTransformer.transform(propertyDescriptor, string, string2);
            }
            if (string2.endsWith("@reference")) {
                return PropertyDescriptorReferenceTransformer.transform(propertyDescriptor, string, string2);
            }
            if (!string2.equals(propertyDescriptor.getName())) {
                return PropertyDescriptorUtils.createPropDescriptorWithNameChange(propertyDescriptor, string, string2);
            }
            return propertyDescriptor;
        }

        private static PropertyDescriptorImpl createPropDescriptorWithNameChange(PropertyDescriptor propertyDescriptor, String string, String string2) {
            PropertyDescriptorImpl propertyDescriptorImpl = new PropertyDescriptorImpl(string2, EMPTY_STRING_ARRAY, string, "<" + string2 + ">", propertyDescriptor.getInapplicableOperators(), propertyDescriptor.getType(), null, propertyDescriptor.getUnit(), propertyDescriptor.getDisplayForm(), propertyDescriptor.isMultiCardinality(), propertyDescriptor.isComputed(), propertyDescriptor.isUnsupportedPropertySortable(), propertyDescriptor.getDependencyResourceModels(), propertyDescriptor.getTags(), propertyDescriptor.getQueryExpressions(), propertyDescriptor.getValueSpace(), propertyDescriptor.getStatus(), propertyDescriptor.getProviderResourceModelCanonicalName());
            return propertyDescriptorImpl;
        }

        static String stripOffMetaInfoFromPropName(String string) {
            if (string.endsWith("._length")) {
                string = string.substring(0, string.lastIndexOf("."));
            }
            if (string.endsWith("@reference")) {
                string = string.substring(0, string.lastIndexOf("@"));
            }
            if (string.contains("@type")) {
                string = PropertyDescriptorUtils.getPropertyPathFromPredicatedProperty(string);
            }
            return string;
        }

        private static String getPropertyPathFromPredicatedProperty(String string) {
            ValidationUtil.paramsNotNull((Object[])new Object[]{string});
            String[] stringArray = string.split("\\[.*?\\]");
            String string2 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + stringArray[i];
            }
            return string2;
        }
    }

    private static class PropertyDescriptorReferenceTransformer {
        private PropertyDescriptorReferenceTransformer() {
        }

        static PropertyDescriptorImpl transform(PropertyDescriptor propertyDescriptor, String string, String string2) {
            if (!string2.endsWith("@reference")) {
                throw new IllegalArgumentException("Property name doesn't have suffix: @reference");
            }
            List<QueryExprInfo> list = propertyDescriptor.getQueryExpressions();
            List<QueryExprInfo> list2 = PropertyDescriptorReferenceTransformer.createReferenceWrappedQueryExpressions(list, string2);
            Map map = Collections.emptyMap();
            List list3 = Collections.emptyList();
            PropertyDescriptorImpl propertyDescriptorImpl = new PropertyDescriptorImpl(string2, EMPTY_STRING_ARRAY, string, "<" + string2 + ">", propertyDescriptor.getInapplicableOperators(), TypeRefUtils.INT_TYPEREF.getName(), null, null, null, false, true, propertyDescriptor.isUnsupportedPropertySortable(), propertyDescriptor.getDependencyResourceModels(), map, list2, list3, propertyDescriptor.getStatus(), propertyDescriptor.getProviderResourceModelCanonicalName());
            return propertyDescriptorImpl;
        }

        private static List<QueryExprInfo> createReferenceWrappedQueryExpressions(List<QueryExprInfo> list, String string) {
            ArrayList<QueryExprInfo> arrayList = new ArrayList<QueryExprInfo>();
            if (list.size() == 1 && list.get((int)0).queryType == QueryContextType.CONTEXT_NONE) {
                QueryExprInfo queryExprInfo = list.get(0);
                String string2 = StringUtil.stripExcessWhitespace((String)queryExprInfo.expression);
                string2 = XQueryUtils.toQualifiedXPath("target", string2);
                QueryExprInfo queryExprInfo2 = PropertyDescriptorImpl.createQueryExprInfo(QueryContextType.CONTEXT_BOUNDED, "local:toReference(" + string2 + ", \"" + string + "\")");
                arrayList.add(queryExprInfo2);
                string2 = StringUtil.stripExcessWhitespace((String)queryExprInfo.expression);
                QueryExprInfo queryExprInfo3 = PropertyDescriptorImpl.createQueryExprInfo(QueryContextType.CONTEXT_CURRENT, "local:toReference(" + string2 + ", \"" + string + "\")");
                arrayList.add(queryExprInfo3);
            } else {
                for (QueryExprInfo queryExprInfo : list) {
                    String string3 = StringUtil.stripExcessWhitespace((String)queryExprInfo.expression);
                    QueryExprInfo queryExprInfo4 = PropertyDescriptorImpl.createQueryExprInfo(queryExprInfo.queryType, "local:toReference(" + string3 + ", \"" + string + "\")");
                    arrayList.add(queryExprInfo4);
                }
            }
            return arrayList;
        }
    }

    private static class PropertyDescriptorLengthTransformer {
        private PropertyDescriptorLengthTransformer() {
        }

        static PropertyDescriptorImpl transform(PropertyDescriptor propertyDescriptor, String string, String string2) {
            if (!string2.endsWith("._length")) {
                throw new IllegalArgumentException("Property name doesn't have suffix: ._length");
            }
            List<QueryExprInfo> list = propertyDescriptor.getQueryExpressions();
            List<QueryExprInfo> list2 = PropertyDescriptorLengthTransformer.createLengthWrappedQueryExpressions(list);
            Map map = Collections.emptyMap();
            List list3 = Collections.emptyList();
            PropertyDescriptorImpl propertyDescriptorImpl = new PropertyDescriptorImpl(string2, EMPTY_STRING_ARRAY, string, "<" + string2 + ">", propertyDescriptor.getInapplicableOperators(), TypeRefUtils.INT_TYPEREF.getName(), null, null, null, false, true, propertyDescriptor.isUnsupportedPropertySortable(), propertyDescriptor.getDependencyResourceModels(), map, list2, list3, propertyDescriptor.getStatus(), propertyDescriptor.getProviderResourceModelCanonicalName());
            return propertyDescriptorImpl;
        }

        private static List<QueryExprInfo> createLengthWrappedQueryExpressions(List<QueryExprInfo> list) {
            ArrayList<QueryExprInfo> arrayList = new ArrayList<QueryExprInfo>();
            if (list.size() == 1 && list.get((int)0).queryType == QueryContextType.CONTEXT_NONE) {
                QueryExprInfo queryExprInfo = list.get(0);
                String string = StringUtil.stripExcessWhitespace((String)queryExprInfo.expression);
                string = XQueryUtils.toQualifiedXPath("target", string);
                QueryExprInfo queryExprInfo2 = PropertyDescriptorImpl.createQueryExprInfo(QueryContextType.CONTEXT_BOUNDED, "count(" + string + ")");
                arrayList.add(queryExprInfo2);
                string = StringUtil.stripExcessWhitespace((String)queryExprInfo.expression);
                QueryExprInfo queryExprInfo3 = PropertyDescriptorImpl.createQueryExprInfo(QueryContextType.CONTEXT_CURRENT, "count(" + string + ")");
                arrayList.add(queryExprInfo3);
            } else {
                for (QueryExprInfo queryExprInfo : list) {
                    String string = StringUtil.stripExcessWhitespace((String)queryExprInfo.expression);
                    QueryExprInfo queryExprInfo4 = PropertyDescriptorImpl.createQueryExprInfo(queryExprInfo.queryType, "count(" + string + ")");
                    arrayList.add(queryExprInfo4);
                }
            }
            return arrayList;
        }
    }
}

