/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.metadata;

import com.vmware.vise.search.QueryExprInfo;
import com.vmware.vise.search.metadata.ChildNodeIndex;
import com.vmware.vise.search.metadata.CodeFlavor;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.TypeDescriptor;
import com.vmware.vise.search.model.ModelUtils;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.XMLUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class TypeDescriptorImpl
implements TypeDescriptor {
    private static boolean OPTIONAL = true;
    private static boolean REQUIRED = false;
    private final String _title;
    private final String _type;
    private final boolean _globalResource;
    private final String _alias;
    private final Map<String, String> _tags;
    private final List<QueryExprInfo> _queryExpressions;
    private final String _status;
    private final String _supertype;

    public TypeDescriptorImpl(Node node, ClassLoader classLoader) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{node});
        ChildNodeIndex childNodeIndex = new ChildNodeIndex(node);
        this._status = XMLUtil.getAttribute((Element)((Element)node), (String)"status");
        this._title = childNodeIndex.getStringValueFor("title", OPTIONAL);
        this._type = childNodeIndex.getStringValueFor("type", REQUIRED);
        this._alias = childNodeIndex.getStringValueFor("alias", this._type);
        this._tags = MetadataUtil.extractTags(childNodeIndex);
        this._queryExpressions = this.getQueryExpressions(childNodeIndex, this._type);
        this._globalResource = childNodeIndex.getBooleanValueFor("globalResource", OPTIONAL);
        this._supertype = null;
    }

    TypeDescriptorImpl(String string, CodeFlavor codeFlavor) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        this._type = string;
        this._title = string;
        this._alias = string;
        this._tags = Collections.emptyMap();
        String string2 = this.getDefaultQueryExpression(string, codeFlavor);
        this._queryExpressions = MetadataUtil.getDefaultQueryInfo(string2);
        this._globalResource = false;
        this._status = null;
        this._supertype = null;
    }

    TypeDescriptorImpl(TypeDescriptor typeDescriptor, String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{typeDescriptor, string});
        this._type = typeDescriptor.getType();
        this._title = typeDescriptor.getTitle();
        this._alias = typeDescriptor.getAlias();
        this._tags = typeDescriptor.getTags();
        this._queryExpressions = typeDescriptor.getQueryExpressions();
        this._globalResource = typeDescriptor.isGlobalResource();
        this._status = typeDescriptor.getStatus();
        this._supertype = string;
    }

    private List<QueryExprInfo> getQueryExpressions(ChildNodeIndex childNodeIndex, String string) {
        List<QueryExprInfo> list = MetadataUtil.extractQueryExpressions(childNodeIndex);
        if (!list.isEmpty()) {
            return list;
        }
        String string2 = this.getDefaultQueryExpression(string, null);
        return MetadataUtil.getDefaultQueryInfo(string2);
    }

    private String getDefaultQueryExpression(String string, CodeFlavor codeFlavor) {
        String string2 = codeFlavor == CodeFlavor.LEGACY || !ModelUtils.isVmodl2Name(string) ? "//" + string : "//*[@qs:resourceType='" + string + "']";
        return string2;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public boolean isGlobalResource() {
        return this._globalResource;
    }

    @Override
    public Map<String, String> getTags() {
        return this._tags;
    }

    @Override
    public List<QueryExprInfo> getQueryExpressions() {
        return this._queryExpressions;
    }

    @Override
    public String getStatus() {
        return this._status;
    }

    @Override
    public String getSupertype() {
        return this._supertype;
    }
}

