/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.transport;

import com.vmware.vise.search.auth.internal.HttpSessionLoginSpecRegistryLocator;
import com.vmware.vise.search.transport.QueryService;
import com.vmware.vise.search.transport.impl.AggregatorQueryServiceImpl;
import com.vmware.vise.search.transport.impl.LinkedQueryServiceGroup;
import com.vmware.vise.search.transport.impl.LinkedQueryServiceImpl;
import com.vmware.vise.util.Version;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vmomi.vc.VcAwareSharedHttpConfigPool;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(QueryServiceFactory.class);
    private static final Version VERSION_QS_REMOVED_FEDERATION = new Version("6.0");
    private final ExecutorService _queryTasksPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 2L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), (ThreadFactory)new WorkerThreadFactory("aggregator-query-service"), new ThreadPoolExecutor.CallerRunsPolicy());

    public QueryService newQueryService(LinkedVcGroup linkedVcGroup, VcAwareSharedHttpConfigPool vcAwareSharedHttpConfigPool, PrivateKey privateKey) {
        Validate.notNull((Object)linkedVcGroup, (String)"linkedGroup");
        if (log.isInfoEnabled()) {
            log.info("Creating QueryService facade for LinkedVcGroup: " + this.getVcGroupDiagnosticInfo(linkedVcGroup));
        }
        HttpSessionLoginSpecRegistryLocator httpSessionLoginSpecRegistryLocator = new HttpSessionLoginSpecRegistryLocator();
        QueryService queryService = QueryServiceFactory.querySvcSupportsFederation(linkedVcGroup) ? new LinkedQueryServiceImpl(LinkedQueryServiceGroup.createForLinkedGroup(linkedVcGroup), vcAwareSharedHttpConfigPool, privateKey, httpSessionLoginSpecRegistryLocator) : new AggregatorQueryServiceImpl(linkedVcGroup, vcAwareSharedHttpConfigPool, this._queryTasksPool, privateKey, httpSessionLoginSpecRegistryLocator);
        return queryService;
    }

    private static boolean querySvcSupportsFederation(LinkedVcGroup linkedVcGroup) {
        VcService vcService = linkedVcGroup.getStartUpVcService();
        boolean bl = QueryServiceFactory.isVcServiceSupportsFederation(vcService);
        if (!bl) {
            return false;
        }
        Collection collection = linkedVcGroup.getVcServices();
        for (VcService vcService2 : collection) {
            bl = QueryServiceFactory.isVcServiceSupportsFederation(vcService2);
            if (bl) continue;
            throw new IllegalArgumentException("Cannot create a query service for a linked vc group of a startup vc service which supports query federation together with vc service which doesn't.");
        }
        return true;
    }

    private static boolean isVcServiceSupportsFederation(VcService vcService) {
        Version version = new Version(vcService.getServiceVersion());
        boolean bl = version.compareTo(VERSION_QS_REMOVED_FEDERATION) < 0;
        return bl;
    }

    private String getVcGroupDiagnosticInfo(LinkedVcGroup linkedVcGroup) {
        StringBuilder stringBuilder = new StringBuilder();
        VcService vcService = linkedVcGroup.getStartUpVcService();
        stringBuilder.append("startup VC => ");
        this.addVcServiceDiagnosticInfo(stringBuilder, vcService);
        stringBuilder.append(", VC services => {");
        for (VcService vcService2 : linkedVcGroup.getVcServices()) {
            this.addVcServiceDiagnosticInfo(stringBuilder, vcService2);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private void addVcServiceDiagnosticInfo(StringBuilder stringBuilder, VcService vcService) {
        stringBuilder.append("[url = ").append(vcService.getServiceUrl()).append(", guid = ").append(vcService.getServiceGuid()).append(", version = ").append(vcService.getServiceVersion()).append("]");
    }
}

