/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.transport.impl;

import com.vmware.vim.query.client.Client;
import com.vmware.vim.query.client.QueryDispatcher;
import com.vmware.vim.query.client.exception.ClientException;
import com.vmware.vim.query.client.exception.ServiceUnavailableException;
import com.vmware.vim.query.client.exception.UnauthenticatedException;
import com.vmware.vim.query.client.exception.ValidationException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vise.search.transport.BadRequestException;
import com.vmware.vise.search.transport.HostConnectException;
import com.vmware.vise.search.transport.QueryServiceException;
import com.vmware.vise.search.transport.impl.QueryRequest;
import com.vmware.vise.search.transport.impl.QueryServiceUtil;
import com.vmware.vise.search.transport.impl.SslCertificateChangedException;
import com.vmware.vise.search.util.Config;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.profiling.ExecutionProfiler;
import com.vmware.vise.util.session.SessionUtil;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Map;
import org.apache.http.conn.HttpHostConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class QueryClientUtil {
    private static final int FEDERATION_TIMEOUT_IN_SECONDS = 900;
    private static final Logger _logger = LoggerFactory.getLogger(QueryClientUtil.class);

    QueryClientUtil() {
    }

    static InputStream executeQuery(Client client, QueryRequest queryRequest) throws UnauthenticatedException, SslCertificateChangedException, QueryServiceException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{client, queryRequest});
        String string = queryRequest.xquery;
        Map<String, Object> map = QueryServiceUtil.transformQueryOptions(queryRequest.options, 900);
        String string2 = QueryServiceUtil.getUri(queryRequest.vcService);
        QueryDispatcher queryDispatcher = client.getQueryDispatcher();
        InputStream inputStream = null;
        long l = 0L;
        long l2 = -1L;
        try {
            if (_logger.isDebugEnabled()) {
                String string3 = QueryClientUtil.formatLogMessage(string2, "Dispatching query:\n %1$s\n query options:\n %2$s.", string, map);
                _logger.debug(string3);
            }
            l = System.currentTimeMillis();
            QueryDispatcher.QueryResponse queryResponse = queryDispatcher.query(string, map);
            inputStream = queryResponse.getResponseStream();
        }
        catch (UnauthenticatedException unauthenticatedException) {
            throw unauthenticatedException;
        }
        catch (ValidationException validationException) {
            String string4 = QueryClientUtil.formatLogMessage(string2, "Validation Error: Invalid XQuery:\n" + string + "\n", new Object[0]);
            _logger.error(string4, (Throwable)validationException);
            throw new BadRequestException(string, string2.toString(), validationException);
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            String string5 = QueryClientUtil.formatLogMessage(string2, "QueryService is not available.", new Object[0]);
            _logger.error(string5, (Throwable)serviceUnavailableException);
            throw new HostConnectException(string2.toString(), serviceUnavailableException);
        }
        catch (ClientException clientException) {
            Throwable throwable = clientException.getCause();
            if (throwable instanceof HttpHostConnectException || throwable instanceof SocketException) {
                String string6 = QueryClientUtil.formatLogMessage(string2, "Service is unreachable (socket errors or connection refused).", new Object[0]);
                _logger.error(string6, throwable);
                throw new HostConnectException(string2.toString(), throwable);
            }
            if (throwable instanceof SocketTimeoutException) {
                l2 = System.currentTimeMillis() - l;
                _logger.error(QueryClientUtil.formatLogMessage(string2, "Socket timed out." + (l2 > 0L ? " [milliseconds: " + l2 + "]" : ""), new Object[0]), throwable);
                throw new HostConnectException(string2.toString(), throwable);
            }
            if (throwable instanceof SslException) {
                _logger.info("", (Throwable)clientException);
                throw new SslCertificateChangedException();
            }
            _logger.error(QueryClientUtil.formatLogMessage(string2, "Error in dispatching query.", new Object[0]), (Throwable)clientException);
            throw new QueryServiceException(string, string2.toString(), null, clientException);
        }
        finally {
            if (l2 < 0L) {
                l2 = System.currentTimeMillis() - l;
            }
            if (l2 > Config.QUERY_TIME_THRESHOLD_IN_MILLIS) {
                if (_logger.isWarnEnabled()) {
                    _logger.warn("The query execution took too long: " + l2 + " milliseconds.");
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug("The query is:\n" + string + "\nThe query options are:\n" + map);
                }
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug(QueryClientUtil.formatLogMessage(string2, "Successfully dispatched query.", new Object[0]));
            }
            ExecutionProfiler executionProfiler = SessionUtil.getExecutionProfiler();
            if (queryRequest.label != null) {
                executionProfiler.putExecutionTime(queryRequest.label, Long.valueOf(l2));
            }
        }
        return inputStream;
    }

    static String formatLogMessage(String string, String string2, Object ... objectArray) {
        String string3 = String.format(string2, objectArray);
        String string4 = String.format("[Server: %1$s] %2$s", string, string3);
        return string4;
    }
}

