/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.transport.impl;

import com.vmware.cis.authorization.client.AuthorizationServiceClient;
import com.vmware.cis.ol.client.ObjectServiceLocator;
import com.vmware.vim.binding.dataservice.ServiceInformation;
import com.vmware.vim.binding.dataservice.accesscontrol.AuthorizationService;
import com.vmware.vim.binding.dataservice.accesscontrol.internal.AuthorizationServiceInternal;
import com.vmware.vim.binding.dataservice.tagging.TagManager;
import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.binding.vmodl.fault.SystemError;
import com.vmware.vim.query.client.AuthenticationStrategy;
import com.vmware.vim.query.client.Client;
import com.vmware.vim.query.client.ClientFactory;
import com.vmware.vim.query.client.QueryAuthenticationManager;
import com.vmware.vim.query.client.QueryDispatcher;
import com.vmware.vim.query.client.exception.ClientException;
import com.vmware.vim.query.client.exception.NotImplementedException;
import com.vmware.vim.query.client.exception.ServiceUnavailableException;
import com.vmware.vim.query.client.impl.ClientFactoryImpl;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.client.exception.TransportProtocolException;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vise.search.LoginMethod;
import com.vmware.vise.search.LoginSpec;
import com.vmware.vise.search.auth.AuthData;
import com.vmware.vise.search.auth.internal.AuthDataRegistryInternal;
import com.vmware.vise.search.auth.internal.AuthDataRegistryLocator;
import com.vmware.vise.search.transport.AuthenticationException;
import com.vmware.vise.search.transport.HostConnectException;
import com.vmware.vise.search.transport.impl.QueryClientUtil;
import com.vmware.vise.search.transport.impl.QueryServiceUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vmomi.vc.VcAwareSharedHttpConfigPool;
import java.net.SocketException;
import java.net.URI;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.commons.lang.Validate;
import org.apache.http.conn.HttpHostConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryServiceClientPool {
    private static final Logger _logger = LoggerFactory.getLogger(QueryServiceClientPool.class);
    private final ConcurrentMap<VcService, Future<Client>> _clientByVcService = new ConcurrentHashMap<VcService, Future<Client>>();
    private static final ClientFactory _clientFactory = new ClientFactoryImpl();
    private final PrivateKey _clientPrivateKey;
    private final AuthDataRegistryLocator _loginSpecRegistryLocator;
    private final VcAwareSharedHttpConfigPool _httpConfigPool;

    QueryServiceClientPool(VcAwareSharedHttpConfigPool vcAwareSharedHttpConfigPool, PrivateKey privateKey, AuthDataRegistryLocator authDataRegistryLocator) {
        Validate.notNull((Object)vcAwareSharedHttpConfigPool, (String)"sharedHttpConfigPool");
        Validate.notNull((Object)authDataRegistryLocator, (String)"loginSpecRegistryLocator");
        this._clientPrivateKey = privateKey;
        this._loginSpecRegistryLocator = authDataRegistryLocator;
        this._httpConfigPool = vcAwareSharedHttpConfigPool;
    }

    Client getClient(final VcService vcService) throws Exception {
        Callable<Client> callable;
        FutureTask<Client> futureTask;
        Validate.notNull((Object)vcService, (String)"vcService");
        FutureTask<Client> futureTask2 = (FutureTask<Client>)this._clientByVcService.get(vcService);
        boolean bl = false;
        if (futureTask2 == null && (futureTask2 = (Future)this._clientByVcService.putIfAbsent(vcService, futureTask = new FutureTask<Client>(callable = new Callable<Client>(){

            @Override
            public Client call() throws Exception {
                Client client = QueryServiceClientPool.this.createClient(vcService);
                return client;
            }
        }))) == null) {
            bl = true;
            futureTask.run();
            futureTask2 = futureTask;
        }
        callable = null;
        try {
            callable = (Client)futureTask2.get();
        }
        catch (Exception exception) {
            boolean bl2;
            if (bl && !(bl2 = this._clientByVcService.remove(vcService, futureTask2))) {
                _logger.warn("Could not remove Client created by this thread. This should NEVER happen. It should have been impossible for another thread to remove or replace the Client.");
            }
            throw exception;
        }
        return new FutureAwareClient((Client)callable, (Future<Client>)futureTask2);
    }

    void closeClient(VcService vcService, Client client) {
        Future<Client> future;
        Validate.notNull((Object)vcService, (String)"vcService must not be null");
        Validate.notNull((Object)client, (String)"client cannot be null");
        try {
            future = ((FutureAwareClient)client).getFuture();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unsupported client type", classCastException);
        }
        boolean bl = this._clientByVcService.remove(vcService, future);
        if (bl) {
            this.quietlyCloseClient(vcService, client);
        } else {
            _logger.warn("Could not remove the Client. Probably another thread removed it and there may even already be another Client for the VC service. This thread will not try to close the Client.");
        }
    }

    void shutdown() {
        HashMap<VcService, Future<Client>> hashMap = new HashMap<VcService, Future<Client>>(this._clientByVcService);
        for (VcService vcService : hashMap.keySet()) {
            boolean bl;
            Future future = (Future)hashMap.get(vcService);
            if (future == null || !(bl = this._clientByVcService.remove(vcService, future))) continue;
            this.quietlyCloseClient(vcService, future);
        }
    }

    private void quietlyCloseClient(VcService vcService, Future<Client> future) {
        try {
            Client client = future.get();
            this.quietlyCloseClient(vcService, client);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable != null) {
                _logger.error("Error while executing get client. Unable to close the client.\n", throwable);
            }
        }
        catch (Exception exception) {
            _logger.error("", (Throwable)exception);
        }
    }

    private void quietlyCloseClient(VcService vcService, Client client) {
        ServiceEndpointEx serviceEndpointEx = QueryServiceUtil.getInventoryServiceEndpoint(vcService);
        try {
            this.closeClient(client, (ServiceDirectory.ServiceEndpoint)serviceEndpointEx);
        }
        catch (Exception exception) {
            _logger.error("", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeClient(Client client, ServiceDirectory.ServiceEndpoint serviceEndpoint) {
        String string = SessionUtil.getSessionInfo();
        try {
            _logger.info("Will log out of Query Client {} (session {}, identity {})", new Object[]{serviceEndpoint.getUrl(), string, Integer.toHexString(System.identityHashCode(client))});
            client.getAuthenticationManager().logout();
            _logger.info("Logout request succeeded: " + serviceEndpoint.getUrl());
        }
        catch (ClientException clientException) {
            _logger.warn("Error in logout." + serviceEndpoint.getUrl(), (Throwable)clientException);
        }
        finally {
            try {
                _logger.debug("Will close client...");
                client.close();
                _logger.debug("Client close succeeded.");
            }
            catch (Exception exception) {
                _logger.warn("Error while trying to close client: " + exception.getMessage(), (Throwable)exception);
            }
        }
        this._httpConfigPool.releaseHttpConfig(serviceEndpoint, false);
    }

    private Client createClient(VcService vcService) throws Exception {
        PrivateKey privateKey;
        assert (vcService != null);
        ServiceEndpointEx serviceEndpointEx = QueryServiceUtil.getInventoryServiceEndpoint(vcService);
        String string = QueryServiceUtil.getSearchUrl((ServiceDirectory.ServiceEndpoint)serviceEndpointEx, vcService);
        AuthDataRegistryInternal authDataRegistryInternal = this._loginSpecRegistryLocator.lookupAuthDataRegistry();
        AuthData authData = authDataRegistryInternal.get(string);
        LoginSpec loginSpec = new LoginSpec();
        loginSpec.webServicesUrl = string;
        if (authData != null) {
            loginSpec.loginMethod = LoginMethod.SAML_TOKEN;
            loginSpec.ssoToken = authData.getToken();
            loginSpec.clientPrivateKey = authData.getPrivateKey();
        } else {
            loginSpec.loginMethod = vcService.supportsLoginByToken() ? LoginMethod.SAML_TOKEN : LoginMethod.TICKETING;
            loginSpec.ssoToken = AuthSessionUtil.getSsoToken();
            privateKey = AuthSessionUtil.getSsoTokenPrivateKey();
            loginSpec.clientPrivateKey = privateKey != null ? privateKey : this._clientPrivateKey;
        }
        privateKey = this.createClientWithRetry((ServiceDirectory.ServiceEndpoint)serviceEndpointEx, loginSpec);
        return privateKey;
    }

    private Client createClientWithRetry(ServiceDirectory.ServiceEndpoint serviceEndpoint, LoginSpec loginSpec) throws AuthenticationException, HostConnectException {
        try {
            Client client = this.createClientForEndpoint(serviceEndpoint, loginSpec);
            return client;
        }
        catch (CertificateValidationException certificateValidationException) {
            URI uRI = URI.create(loginSpec.webServicesUrl);
            String string = QueryClientUtil.formatLogMessage(uRI.toString(), "Query service threw a CertificateValidationException, seems like its thumbprint has changed. New thumbprint: %1$s.", certificateValidationException.getThumbprint());
            _logger.error(string);
            try {
                ServiceDirectory.ServiceEndpoint serviceEndpoint2 = VcServiceUtil.fetchServiceEndpoint((String)serviceEndpoint.instanceUuid);
                this._httpConfigPool.updateThumbprint(serviceEndpoint2);
                Client client = this.createClientForEndpoint(serviceEndpoint2, loginSpec);
                return client;
            }
            catch (Exception exception) {
                throw new AuthenticationException(certificateValidationException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Client createClientForEndpoint(ServiceDirectory.ServiceEndpoint serviceEndpoint, LoginSpec loginSpec) throws AuthenticationException, HostConnectException, CertificateValidationException {
        assert (serviceEndpoint != null);
        assert (loginSpec != null);
        if (loginSpec.loginMethod != LoginMethod.SAML_TOKEN) {
            throw new IllegalArgumentException("Invalid login method, only login by token is supported.");
        }
        SamlToken samlToken = loginSpec.ssoToken;
        if (samlToken == null) {
            samlToken = AuthSessionUtil.getSsoToken();
        }
        if (samlToken == null) {
            String string = "No SAML token found. Cannot login to Inventory Service " + loginSpec.webServicesUrl;
            _logger.error(string);
            throw new AuthenticationException(loginSpec.webServicesUrl, null);
        }
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(QueryClientUtil.class.getClassLoader());
        try {
            URI uRI = URI.create(loginSpec.webServicesUrl);
            String string = uRI.toString();
            HttpConfiguration httpConfiguration = this._httpConfigPool.getHttpConfig(serviceEndpoint);
            HttpClientConfiguration httpClientConfiguration = HttpClientConfiguration.Factory.newInstance();
            httpClientConfiguration.setHttpConfiguration(httpConfiguration);
            ClientFactoryConfiguration clientFactoryConfiguration = new ClientFactoryConfiguration(httpClientConfiguration);
            String string2 = SessionUtil.getSessionInfo();
            _logger.info("Creating a Query Client... " + loginSpec.webServicesUrl + " (" + string2 + ")");
            Client client = _clientFactory.createClient(uRI, (ClientFactory.Configuration)clientFactoryConfiguration);
            try {
                QueryServiceClientPool.loginBySamlToken(samlToken, loginSpec, client);
                _logger.info(QueryClientUtil.formatLogMessage(string, "Login request succeeded.", new Object[0]));
            }
            catch (ClientException clientException) {
                client.close();
                this._httpConfigPool.releaseHttpConfig(serviceEndpoint, false);
                QueryServiceClientPool.translateClientException(clientException, string, samlToken);
            }
            catch (RuntimeException runtimeException) {
                client.close();
                this._httpConfigPool.releaseHttpConfig(serviceEndpoint, false);
                Throwable throwable = runtimeException.getCause();
                if (throwable instanceof HostConnectException) {
                    throw (HostConnectException)throwable;
                }
                if (runtimeException instanceof SystemError) {
                    throw new AuthenticationException(uRI.toString(), runtimeException);
                }
                throw runtimeException;
            }
            _logger.info("Done creating the Query Client (" + string2 + ", identity " + Integer.toHexString(System.identityHashCode(client)) + ")");
            Client client2 = client;
            return client2;
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    private static void translateClientException(ClientException clientException, String string, SamlToken samlToken) throws HostConnectException, CertificateValidationException, AuthenticationException {
        assert (clientException != null);
        Throwable throwable = clientException.getCause();
        if (throwable instanceof ExecutionException && throwable.getCause() != null) {
            throwable = ((ExecutionException)throwable).getCause();
        }
        if (throwable instanceof ConnectionException || throwable instanceof HttpHostConnectException || throwable instanceof SocketException || throwable instanceof TransportProtocolException || QueryServiceClientPool.isServiceUnavailable(throwable)) {
            throw new HostConnectException(string, throwable);
        }
        String string2 = "(" + SessionUtil.getSessionInfo() + ")";
        if (throwable instanceof SslException || throwable instanceof CertificateValidationException) {
            if (throwable instanceof SslException && throwable.getCause() instanceof CertificateValidationException) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof CertificateValidationException) {
                CertificateValidationException certificateValidationException = (CertificateValidationException)throwable;
                throw certificateValidationException;
            }
            _logger.error(QueryClientUtil.formatLogMessage(string, "Invalid certificate. " + string2, new Object[0]), throwable);
            throw new HostConnectException(string, throwable);
        }
        if (throwable instanceof SecurityError) {
            _logger.info("[Server: {}] SecurityError in login request {}. Login token: subject = {} ; renewable = {} ; expiration time = {}", new Object[]{string, string2, samlToken.getSubject(), samlToken.isRenewable(), samlToken.getExpirationTime()});
        } else {
            _logger.warn(QueryClientUtil.formatLogMessage(string, "Error in login request. " + string2, new Object[0]), (Throwable)clientException);
        }
        throw new AuthenticationException(string, throwable);
    }

    private static boolean isServiceUnavailable(Throwable throwable) {
        return throwable instanceof UnexpectedStatusCodeException && ((UnexpectedStatusCodeException)throwable).getStatusCode() == 503;
    }

    private static void loginBySamlToken(SamlToken samlToken, LoginSpec loginSpec, Client client) throws ClientException {
        PrivateKey privateKey = loginSpec.clientPrivateKey;
        if (_logger.isInfoEnabled()) {
            URI uRI = URI.create(loginSpec.webServicesUrl);
            _logger.info(QueryClientUtil.formatLogMessage(uRI.toString(), "Logging in using SAML token. Token expiration time: " + samlToken.getExpirationTime(), new Object[0]));
        }
        try {
            client.getAuthenticationManager().loginBySamlToken(samlToken, privateKey);
        }
        catch (TransportProtocolException transportProtocolException) {
            _logger.warn("Unable to login to: " + loginSpec.webServicesUrl + ", retrying.");
            client.getAuthenticationManager().loginBySamlToken(samlToken, privateKey);
        }
    }

    private static class ClientFactoryConfiguration
    implements ClientFactory.Configuration {
        private final HttpClientConfiguration _httpClientConfig;

        public ClientFactoryConfiguration(HttpClientConfiguration httpClientConfiguration) {
            ValidationUtil.paramsNotNull((Object[])new Object[]{httpClientConfiguration});
            this._httpClientConfig = httpClientConfiguration;
        }

        public HttpClientConfiguration getClientConfig() {
            return this._httpClientConfig;
        }

        public Class<?> getVersion() {
            return null;
        }

        public AuthenticationStrategy getAuthenticationStrategy() {
            return null;
        }
    }

    private static class FutureAwareClient
    implements Client {
        private final Client _client;
        private final Future<Client> _future;

        FutureAwareClient(Client client, Future<Client> future) {
            if (client == null) {
                throw new IllegalArgumentException("The client should not be null");
            }
            if (future == null) {
                throw new IllegalArgumentException("The future should not be null");
            }
            this._client = client;
            this._future = future;
        }

        public QueryAuthenticationManager getAuthenticationManager() {
            return this._client.getAuthenticationManager();
        }

        public QueryDispatcher getQueryDispatcher() {
            return this._client.getQueryDispatcher();
        }

        public com.vmware.vim.vmomi.client.Client getVmomiClient() {
            return this._client.getVmomiClient();
        }

        public TagManager getTagManager() {
            return this._client.getTagManager();
        }

        public ServiceInformation getServiceInformation() throws ServiceUnavailableException, NotImplementedException {
            return this._client.getServiceInformation();
        }

        public void close() {
            this._client.close();
        }

        public Future<Client> getFuture() {
            return this._future;
        }

        public ObjectServiceLocator getObjectServiceLocator() {
            return this._client.getObjectServiceLocator();
        }

        public AuthorizationService getAuthorizationService() {
            return this._client.getAuthorizationService();
        }

        public AuthorizationServiceInternal getAuthorizationServiceInternal() {
            return this._client.getAuthorizationServiceInternal();
        }

        public AuthorizationServiceClient newAuthorizationServiceClient(boolean bl) {
            return this._client.newAuthorizationServiceClient(bl);
        }

        public AuthorizationServiceClient newAuthorizationServiceClient(Set<String> set, Set<String> set2) {
            return this._client.newAuthorizationServiceClient(set, set2);
        }
    }
}

