/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery.render;

import com.vmware.vise.search.CompositeConstraint;
import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.PropertySpec;
import com.vmware.vise.search.QuerySpec;
import com.vmware.vise.search.RelationSpec;
import com.vmware.vise.search.RelationalConstraint;
import com.vmware.vise.search.ResponseSpec;
import com.vmware.vise.search.impl.SpecUtil;
import com.vmware.vise.search.impl.TypeRefUtils;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.RelationDescriptor;
import com.vmware.vise.search.model.ModelUtils;
import com.vmware.vise.search.util.Renderer;
import com.vmware.vise.search.xquery.VarRefExpression;
import com.vmware.vise.search.xquery.render.JoinModelsReturnClauseGenerator;
import com.vmware.vise.search.xquery.render.RendererFactory;
import com.vmware.vise.search.xquery.render.ReturnClauseGenerator;
import com.vmware.vise.search.xquery.render.SingleModelReturnClauseGenerator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnyModelReturnClauseGenerator
implements ReturnClauseGenerator {
    private static final Logger log = LoggerFactory.getLogger(AnyModelReturnClauseGenerator.class);
    private static final String MATCHED_RESOURCE_IDS_CLAUSE = String.format("let $%1$s := fn:distinct-values(($%2$sSet/%3$s))\n", "matchedResourceIds", "target", "@qs:resource");
    private static final String FILTER_VMODL1_ONLY = String.format("let $%1$sSet := $%1$sSet[not(%2$s)]\n", "target", "@qs:model");
    private final MetadataDirectory _metadataDirectory;
    private final RendererFactory _rendererFactory;
    private final QuerySpec _querySpec;

    public AnyModelReturnClauseGenerator(MetadataDirectory metadataDirectory, RendererFactory rendererFactory, QuerySpec querySpec) {
        Validate.notNull((Object)metadataDirectory, (String)"metadataDir");
        this._metadataDirectory = metadataDirectory;
        this._rendererFactory = rendererFactory;
        this._querySpec = querySpec;
    }

    @Override
    public String generate(ResponseSpec responseSpec) {
        String string;
        boolean bl;
        QueryInfo queryInfo = new QueryInfo();
        this.collectConstraintInfo(this._querySpec.constraint, queryInfo);
        this.collectResponseInfo(responseSpec, queryInfo);
        boolean bl2 = ModelUtils.hasVmodl2Name(queryInfo.targetTypes);
        boolean bl3 = ModelUtils.hasVmodl2Name(queryInfo.referencedModels);
        boolean bl4 = queryInfo.unresolvedTargetTypes > 0;
        boolean bl5 = queryInfo.returnPropertyCount == 0;
        boolean bl6 = responseSpec.maxResultsCount == 0;
        boolean bl7 = bl = !bl2 && queryInfo.unresolvedTargetTypes == 0;
        if (bl2 || bl3) {
            string = bl ? this.generateForVmodl1TypeWithVmodl2Return(responseSpec) : this.generateForVmodl2(responseSpec);
        } else if (bl5 && !bl6) {
            string = this.generateForVmodl2(responseSpec);
        } else if (bl4) {
            log.warn("This query contains untyped PropertySpec-s or target resource types could no be auto-resolved. The generated XQuery is sub-optimal. Typify the query to avoid this warning.\n{}\n{}", (Object)SpecUtil.toString(this._querySpec), (Object)SpecUtil.toString(responseSpec));
            string = this.generateForVmodl2(responseSpec);
        } else {
            string = this.generateForPureVmodl1(responseSpec);
        }
        return string;
    }

    private String generateForPureVmodl1(ResponseSpec responseSpec) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendVmodl1NoJoinItems(responseSpec, stringBuilder);
        this.appendTargetSetCount(stringBuilder);
        return stringBuilder.toString();
    }

    private String generateForVmodl1TypeWithVmodl2Return(ResponseSpec responseSpec) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(FILTER_VMODL1_ONLY);
        stringBuilder.append(MATCHED_RESOURCE_IDS_CLAUSE);
        this.appendJoinDocumentItems(responseSpec, stringBuilder);
        this.appendTargetSetCount(stringBuilder);
        return stringBuilder.toString();
    }

    private String generateForVmodl2(ResponseSpec responseSpec) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(MATCHED_RESOURCE_IDS_CLAUSE);
        this.appendJoinDocumentItems(responseSpec, stringBuilder);
        this.appendResourceIdCount(stringBuilder);
        return stringBuilder.toString();
    }

    private void appendJoinDocumentItems(ResponseSpec responseSpec, StringBuilder stringBuilder) {
        JoinModelsReturnClauseGenerator joinModelsReturnClauseGenerator = new JoinModelsReturnClauseGenerator(this._metadataDirectory, this._rendererFactory, null);
        stringBuilder.append(joinModelsReturnClauseGenerator.generate(responseSpec)).append("\n");
    }

    private void appendVmodl1NoJoinItems(ResponseSpec responseSpec, StringBuilder stringBuilder) {
        SingleModelReturnClauseGenerator singleModelReturnClauseGenerator = new SingleModelReturnClauseGenerator(this._metadataDirectory, this._rendererFactory, null);
        stringBuilder.append("\n").append(singleModelReturnClauseGenerator.generate(responseSpec)).append("\n");
    }

    private void appendTargetSetCount(StringBuilder stringBuilder) {
        Renderer renderer = this._rendererFactory.newItemCountClauseRenderer(new VarRefExpression("targetSet"));
        stringBuilder.append(renderer.render());
    }

    private void appendResourceIdCount(StringBuilder stringBuilder) {
        Renderer renderer = this._rendererFactory.newItemCountClauseRenderer(new VarRefExpression("matchedResourceIds"));
        stringBuilder.append(renderer.render());
    }

    private void collectConstraintInfo(Constraint constraint, QueryInfo queryInfo) {
        if (constraint == null) {
            return;
        }
        boolean bl = this.isSpecificTargetType(constraint.getSearchTarget());
        if (constraint instanceof CompositeConstraint) {
            Constraint[] constraintArray = ((CompositeConstraint)constraint).getNestedConstraints();
            if (constraintArray == null) {
                return;
            }
            for (Constraint constraint2 : constraintArray) {
                this.collectConstraintInfo(constraint2, queryInfo);
            }
        } else if (!bl) {
            String string = this.guessConstraintTargetType(constraint);
            if (this.isSpecificTargetType(string)) {
                queryInfo.targetTypes.add(string);
            } else {
                ++queryInfo.unresolvedTargetTypes;
            }
        } else {
            queryInfo.targetTypes.add(constraint.getSearchTarget());
        }
    }

    private String guessConstraintTargetType(Constraint constraint) {
        if (constraint instanceof RelationalConstraint) {
            RelationSpec relationSpec = ((RelationalConstraint)constraint).getRelationSpec();
            RelationDescriptor relationDescriptor = MetadataUtil.getRelationFromSpec(this._metadataDirectory, relationSpec);
            String string = relationDescriptor == null ? null : relationDescriptor.getSourceType();
            return string;
        }
        return null;
    }

    private void collectResponseInfo(ResponseSpec responseSpec, QueryInfo queryInfo) {
        if (responseSpec.propertiesToRetrieve != null) {
            for (PropertySpec propertySpec : responseSpec.propertiesToRetrieve) {
                this.harvestReferencedModels(propertySpec, queryInfo.referencedModels);
                queryInfo.returnPropertyCount += ArrayUtils.getLength((Object)propertySpec.properties);
            }
        }
        if (responseSpec.orderingCriteria != null && responseSpec.orderingCriteria.applicableProperties != null) {
            for (PropertySpec propertySpec : responseSpec.orderingCriteria.applicableProperties) {
                this.harvestReferencedModels(propertySpec, queryInfo.referencedModels);
            }
        }
    }

    public void harvestReferencedModels(PropertySpec propertySpec, Set<String> set) {
        if (!ArrayUtils.isEmpty((Object[])propertySpec.properties) && StringUtils.isEmpty((String)propertySpec.relationship)) {
            this.harvestReferencedModels(propertySpec.providerType, propertySpec.properties, set);
        }
    }

    private void harvestReferencedModels(String string, String[] stringArray, Set<String> set) {
        assert (stringArray != null);
        for (String string2 : stringArray) {
            String string3 = ModelUtils.getResourceModel(string2);
            if (string3 != null) {
                set.add(string3);
            }
            PropertyDescriptor propertyDescriptor = this._metadataDirectory.getPropertyDescriptor(string2, string);
            set.addAll(propertyDescriptor.getDependencyResourceModels());
        }
    }

    private boolean isSpecificTargetType(String string) {
        return !StringUtils.isEmpty((String)string) && !TypeRefUtils.ROOT_TYPEREF.getName().equalsIgnoreCase(string);
    }

    private static final class QueryInfo {
        public Set<String> referencedModels = new HashSet<String>();
        public int returnPropertyCount = 0;
        public Set<String> targetTypes = new HashSet<String>();
        public int unresolvedTargetTypes = 0;

        private QueryInfo() {
        }
    }
}

