/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery.render;

import com.vmware.vise.search.QuerySpec;
import com.vmware.vise.search.impl.TypeRefDirectory;
import com.vmware.vise.search.metadata.CodeFlavor;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.util.Renderer;
import com.vmware.vise.search.xquery.PrimaryExpression;
import com.vmware.vise.search.xquery.render.AnyModelReturnClauseGenerator;
import com.vmware.vise.search.xquery.render.CompositePropertyRenderer;
import com.vmware.vise.search.xquery.render.ConstraintRenderer;
import com.vmware.vise.search.xquery.render.LegacyReturnClauseGenerator;
import com.vmware.vise.search.xquery.render.PropertyRenderer;
import com.vmware.vise.search.xquery.render.ReturnClauseGenerator;
import com.vmware.vise.search.xquery.render.XQueryCompositeReturnPropertyRenderer;
import com.vmware.vise.search.xquery.render.XQueryItemCountClauseRenderer;
import com.vmware.vise.search.xquery.render.XQueryObjectIdentityConstraintRenderer;
import com.vmware.vise.search.xquery.render.XQueryOrderingPropertyRenderer;
import com.vmware.vise.search.xquery.render.XQueryPropertyConstraintRenderer;
import com.vmware.vise.search.xquery.render.XQueryReturnPropertyRenderer;

public final class RendererFactory {
    private final TypeRefDirectory _typeRefDirectory;
    private final MetadataDirectory _metadataDirectory;
    private final CodeFlavor _codeFlavor;

    public RendererFactory(TypeRefDirectory typeRefDirectory, MetadataDirectory metadataDirectory, CodeFlavor codeFlavor) {
        this._typeRefDirectory = typeRefDirectory;
        this._metadataDirectory = metadataDirectory;
        this._codeFlavor = codeFlavor;
    }

    public PropertyRenderer newReturnPropertyRenderer() {
        return new XQueryReturnPropertyRenderer(this._typeRefDirectory);
    }

    public CompositePropertyRenderer newCompositeReturnPropertyRenderer(String string, String string2) {
        return new XQueryCompositeReturnPropertyRenderer(string, string2);
    }

    public ConstraintRenderer newPropertyConstraintRenderer() {
        return new XQueryPropertyConstraintRenderer(this._typeRefDirectory, this._metadataDirectory);
    }

    public ConstraintRenderer newObjectIdentityConstraintRenderer() {
        return new XQueryObjectIdentityConstraintRenderer(this._codeFlavor);
    }

    public PropertyRenderer newOrderingPropertyRenderer() {
        return new XQueryOrderingPropertyRenderer(this._typeRefDirectory);
    }

    public Renderer newItemCountClauseRenderer(PrimaryExpression primaryExpression) {
        return new XQueryItemCountClauseRenderer(primaryExpression);
    }

    public ReturnClauseGenerator newReturnClauseGenerator(QuerySpec querySpec) {
        if (this._codeFlavor == CodeFlavor.VMODL2_SUPPORT) {
            return new AnyModelReturnClauseGenerator(this._metadataDirectory, this, querySpec);
        }
        return new LegacyReturnClauseGenerator(this._metadataDirectory, this);
    }
}

