/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery.render;

import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.ObjectIdentityConstraint;
import com.vmware.vise.search.metadata.CodeFlavor;
import com.vmware.vise.search.xquery.ComparisonExpression;
import com.vmware.vise.search.xquery.LiteralExpression;
import com.vmware.vise.search.xquery.StringLiteralExpression;
import com.vmware.vise.search.xquery.render.ConstraintRenderer;

final class XQueryObjectIdentityConstraintRenderer
implements ConstraintRenderer {
    private final CodeFlavor _codeFlavor;
    private ObjectIdentityConstraint _oiConstr;

    public XQueryObjectIdentityConstraintRenderer(CodeFlavor codeFlavor) {
        this._codeFlavor = codeFlavor;
    }

    @Override
    public String render() {
        ComparisonExpression comparisonExpression;
        if (this._oiConstr == null) {
            throw new IllegalArgumentException("Constraint has to be set.");
        }
        String string = QueryUtil.getReferenceUid((Object)this._oiConstr.getTarget());
        StringLiteralExpression stringLiteralExpression = new StringLiteralExpression(string);
        if (this._codeFlavor == CodeFlavor.LEGACY) {
            ComparisonExpression comparisonExpression2;
            LiteralExpression literalExpression = new LiteralExpression("@qs:id");
            comparisonExpression = comparisonExpression2 = new ComparisonExpression(literalExpression, ComparisonExpression.Operator.EQUALS, stringLiteralExpression);
        } else {
            ComparisonExpression comparisonExpression3;
            LiteralExpression literalExpression = new LiteralExpression("@qs:resource");
            comparisonExpression = comparisonExpression3 = new ComparisonExpression(literalExpression, ComparisonExpression.Operator.EQUALS, stringLiteralExpression);
        }
        return comparisonExpression.evaluate();
    }

    @Override
    public Constraint getConstraint() {
        return this._oiConstr;
    }

    @Override
    public void setConstraint(Constraint constraint) {
        if (!(constraint instanceof ObjectIdentityConstraint)) {
            throw new IllegalArgumentException("Parameter 'constraint' has to be of type: 'ObjectIdentityConstraint'");
        }
        this._oiConstr = (ObjectIdentityConstraint)constraint;
        XQueryObjectIdentityConstraintRenderer.verifyConstraint(this._oiConstr);
    }

    private static void verifyConstraint(ObjectIdentityConstraint objectIdentityConstraint) {
        if (objectIdentityConstraint == null) {
            throw new IllegalArgumentException("ObjectIdentityConstraint has to be set.");
        }
        Object object = objectIdentityConstraint.getTarget();
        if (object == null) {
            throw new IllegalArgumentException("Invalid Target.");
        }
    }
}

