/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery.render;

import com.vmware.vise.search.QueryContextType;
import com.vmware.vise.search.TypeRef;
import com.vmware.vise.search.impl.TypeRefDirectory;
import com.vmware.vise.search.impl.TypeRefUtils;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.search.xquery.FunctionExpression;
import com.vmware.vise.search.xquery.LiteralExpression;
import com.vmware.vise.search.xquery.StringLiteralExpression;
import com.vmware.vise.search.xquery.VarRefExpression;
import com.vmware.vise.search.xquery.XQueryUtils;
import com.vmware.vise.search.xquery.render.PropertyRenderer;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.XMLUtil;

final class XQueryReturnPropertyRenderer
implements PropertyRenderer {
    private static final String DEFAULT_PROPERTY_RENDER_FUNCTION = "local:returnnode";
    private static final String BOOLEAN_PROPERTY_RENDER_FUNCTION = "local:returnboolean";
    private final TypeRefDirectory _typeRefDirectory;
    private PropertyRenderer.PropertyRendererContext _propertyRendererContext;

    XQueryReturnPropertyRenderer(TypeRefDirectory typeRefDirectory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{typeRefDirectory});
        this._typeRefDirectory = typeRefDirectory;
    }

    @Override
    public String render() {
        PropertyDescriptor propertyDescriptor = this._propertyRendererContext.propertyDescriptor;
        String string = this._propertyRendererContext.targetId;
        String string2 = XMLUtil.escapeXmlTag((String)this._propertyRendererContext.propertySpec);
        String string3 = this.getReturnPropExpression(propertyDescriptor, string);
        VarRefExpression varRefExpression = new VarRefExpression(string);
        LiteralExpression literalExpression = new LiteralExpression(string3);
        StringLiteralExpression stringLiteralExpression = new StringLiteralExpression(string2);
        FunctionExpression functionExpression = new FunctionExpression(DEFAULT_PROPERTY_RENDER_FUNCTION, varRefExpression, literalExpression, stringLiteralExpression);
        String string4 = propertyDescriptor.getType();
        TypeRef typeRef = this._typeRefDirectory.getTypeRef(string4);
        if (propertyDescriptor.isComputed() && TypeRefUtils.isBooleanType(typeRef)) {
            functionExpression = new FunctionExpression(BOOLEAN_PROPERTY_RENDER_FUNCTION, literalExpression, stringLiteralExpression);
        }
        return functionExpression.evaluate();
    }

    @Override
    public PropertyRenderer.PropertyRendererContext getRendererContext() {
        return this._propertyRendererContext;
    }

    @Override
    public void setRendererContext(PropertyRenderer.PropertyRendererContext propertyRendererContext) {
        this._propertyRendererContext = propertyRendererContext;
        XQueryReturnPropertyRenderer.verifyContext(this._propertyRendererContext);
    }

    private static void verifyContext(PropertyRenderer.PropertyRendererContext propertyRendererContext) {
        if (propertyRendererContext == null) {
            throw new IllegalArgumentException("Context has to be set.");
        }
        if (propertyRendererContext.propertyDescriptor == null) {
            throw new IllegalArgumentException("Context.propertyDescriptor has to be set.");
        }
        if (Strings.isNullOrEmpty(propertyRendererContext.targetId)) {
            throw new IllegalArgumentException("Context.targetId has to be set.");
        }
    }

    private String getReturnPropExpression(PropertyDescriptor propertyDescriptor, String string) {
        String string2 = MetadataUtil.getQueryExpression(propertyDescriptor, QueryContextType.CONTEXT_BOUNDED);
        string2 = XQueryUtils.toQualifiedXPath(string, string2);
        return string2;
    }
}

