/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.xquery.xhive.fts;

import com.vmware.vise.search.util.LexicalAnalyzer;
import com.vmware.vise.search.util.State;
import com.vmware.vise.search.util.StateChangeListener;
import com.vmware.vise.search.util.StateMachine;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.search.util.Token;
import com.vmware.vise.search.util.TokenType;
import com.vmware.vise.search.xquery.xhive.fts.QuotedStateImpl;
import com.vmware.vise.search.xquery.xhive.fts.RegularStateImpl;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class XhiveFtsTextLexicalAnalyzerImpl
implements LexicalAnalyzer,
StateMachine,
StateChangeListener {
    private static final Map<TokenType, State> _states = new HashMap<TokenType, State>();
    private State _activeState;
    private List<Token> _tokens;

    public XhiveFtsTextLexicalAnalyzerImpl() {
        _states.put(TokenType.Quoted, new QuotedStateImpl(this));
        _states.put(TokenType.Regular, new RegularStateImpl(this));
    }

    public Token[] getTokens() {
        return this._tokens.toArray(new Token[this._tokens.size()]);
    }

    @Override
    public Map<TokenType, State> getStates() {
        return _states;
    }

    @Override
    public void transitionTo(State state) {
        if (this._activeState != null) {
            this._activeState.exit();
            this._activeState.removeExitStateListener(this);
        }
        this._activeState = state;
        this._activeState.addExitStateListener(this);
        this._activeState.enter();
    }

    @Override
    public Token[] analyze(String string) {
        this.initialize();
        this.run(string);
        return this.getTokens();
    }

    @Override
    public void enterPerformed(EventObject eventObject) {
    }

    @Override
    public void exitPerformed(EventObject eventObject) {
        Token token = this._activeState.getToken();
        if (token != null && !Strings.isNullOrEmpty(token.getText())) {
            this._tokens.add(token);
        }
    }

    private void run(String string) {
        if (Strings.isNullOrEmpty(string)) {
            return;
        }
        for (int i = 0; i < string.length(); ++i) {
            this._activeState.readSymbol(string, i);
        }
        this._activeState.exit();
        this._activeState.removeExitStateListener(this);
    }

    private void initialize() {
        RegularStateImpl regularStateImpl = new RegularStateImpl(this);
        this.transitionTo(regularStateImpl);
        this._tokens = new ArrayList<Token>();
    }
}

