/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.event.EventDetailDescription;
import com.vmware.opsmgmt.client.event.ExportEvent;
import com.vmware.opsmgmt.client.event.impl.BaseEventProcessor;
import com.vmware.opsmgmt.client.event.impl.EventDescriptionCollector;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventDescription;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.ExtendedEvent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.vim.commons.MixedUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ExportEventProcessor
extends BaseEventProcessor {
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("[\n\r]");
    private static final String EXPORT_EVENTS_PROPERTY_NAME = "entityExportEvents";
    private final DataService _dataService;

    public ExportEventProcessor(DataService dataService, DataServiceExtensionRegistry dataServiceExtensionRegistry) {
        super(dataServiceExtensionRegistry);
        this._dataService = dataService;
    }

    @Override
    protected TypeInfo getTypeInfo() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = BaseEventProcessor.EVENT_TYPE;
        typeInfo.properties = new String[]{EXPORT_EVENTS_PROPERTY_NAME};
        return typeInfo;
    }

    @Override
    protected List<ResultItem> processEventsResult(Map<ManagedObjectReference, List<Event>> map, List<MethodFault> list, QuerySpec querySpec) {
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        for (Map.Entry<ManagedObjectReference, List<Event>> entry : map.entrySet()) {
            String string;
            PropertyValue propertyValue;
            ExportEvent[] exportEventArray = new ExportEvent[]{};
            try {
                propertyValue = entry.getValue();
                string = entry.getKey().getServerGuid();
                exportEventArray = this.transformToExportEvents((List<Event>)propertyValue, string);
            }
            catch (Exception exception) {
                list.add(MixedUtil.getMethodFault((Throwable)exception));
            }
            propertyValue = new PropertyValue();
            propertyValue.propertyName = EXPORT_EVENTS_PROPERTY_NAME;
            propertyValue.value = exportEventArray;
            string = new ResultItem();
            ((ResultItem)string).properties = new PropertyValue[]{propertyValue};
            ((ResultItem)string).resourceObject = entry.getKey();
            arrayList.add((ResultItem)string);
        }
        return arrayList;
    }

    private ExportEvent[] transformToExportEvents(List<Event> list, String string) throws Exception {
        if (list.size() == 0) {
            return new ExportEvent[0];
        }
        EventDescriptionCollector eventDescriptionCollector = EventDescriptionCollector.getEventDetailDescriptionCollector(string, this._dataService);
        ExportEvent[] exportEventArray = new ExportEvent[list.size()];
        int n = 0;
        for (Event event : list) {
            ExportEvent exportEvent = new ExportEvent();
            exportEvent.createdTime = event.createdTime;
            exportEvent.eventTypeId = this.getEventTypeId(event, true);
            exportEvent.category = this.getCategory(event, eventDescriptionCollector);
            exportEvent.fullFormattedMessage = event.fullFormattedMessage;
            if (exportEvent.fullFormattedMessage != null) {
                exportEvent.fullFormattedMessage = NEW_LINE_PATTERN.matcher(exportEvent.fullFormattedMessage).replaceAll("");
            }
            exportEventArray[n++] = exportEvent;
        }
        return exportEventArray;
    }

    private String getEventTypeId(Event event, boolean bl) {
        String string = null;
        string = event instanceof ExtendedEvent ? ((ExtendedEvent)event).eventTypeId : (event instanceof EventEx ? ((EventEx)event).eventTypeId : (bl ? event.getClass().getSimpleName() : event.getClass().getName()));
        return string;
    }

    private String getCategory(Event event, EventDescriptionCollector eventDescriptionCollector) {
        EventDescription.EventDetail eventDetail;
        String string = this.getEventTypeId(event, false);
        EventDetailDescription[] eventDetailDescriptionArray = eventDescriptionCollector.collectDetails(new String[]{string});
        String string2 = null;
        if (eventDetailDescriptionArray != null && eventDetailDescriptionArray.length == 1 && eventDetailDescriptionArray[0] != null && (eventDetail = eventDetailDescriptionArray[0].eventDetail) != null) {
            string2 = eventDetail.category;
        }
        return string2;
    }
}

