/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.event.impl.BaseEventProcessor;
import com.vmware.opsmgmt.client.event.util.Util;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.TypeInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MigrationHistoryProcessor
extends BaseEventProcessor {
    public MigrationHistoryProcessor(DataServiceExtensionRegistry dataServiceExtensionRegistry) {
        super(dataServiceExtensionRegistry);
    }

    @Override
    protected TypeInfo getTypeInfo() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = BaseEventProcessor.EVENT_TYPE;
        typeInfo.properties = new String[]{Util.MIGRATION_HISTORY};
        return typeInfo;
    }

    @Override
    protected List<ResultItem> processEventsResult(Map<ManagedObjectReference, List<Event>> map, List<MethodFault> list, QuerySpec querySpec) {
        EventEx eventEx;
        PropertyValue propertyValue;
        List<Event> list222;
        Collection<List<Event>> collection = map.values();
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        for (List<Event> list222 : collection) {
            for (Event event : list222) {
                if (!(event instanceof EventEx)) continue;
                propertyValue = null;
                eventEx = (EventEx)event;
                KeyAnyValue[] keyAnyValueArray = eventEx.arguments;
                for (int i = 0; i < keyAnyValueArray.length; ++i) {
                    KeyAnyValue keyAnyValue = keyAnyValueArray[i];
                    if (0 != keyAnyValue.getKey().compareTo(Util.OLD_MO_REF)) continue;
                    String string = (String)keyAnyValue.getValue();
                    propertyValue = this.makeVirtualMachineMO(string);
                    arrayList.add((ManagedObjectReference)propertyValue);
                    this.requestHistory((ManagedObjectReference)propertyValue, arrayList);
                }
            }
        }
        list222 = new ArrayList<Event>();
        for (ManagedObjectReference managedObjectReference : arrayList) {
            propertyValue = new PropertyValue();
            propertyValue.propertyName = Util.MIGRATION_HISTORY;
            propertyValue.value = managedObjectReference;
            eventEx = new ResultItem();
            eventEx.properties = new PropertyValue[]{propertyValue};
            try {
                eventEx.resourceObject = new URI("TODO:" + managedObjectReference.getValue() + managedObjectReference.getServerGuid());
            }
            catch (Exception exception) {
                continue;
            }
            list222.add((Event)eventEx);
        }
        return list222;
    }

    private ArrayList<ManagedObjectReference> requestHistory(ManagedObjectReference managedObjectReference, ArrayList<ManagedObjectReference> arrayList) {
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.AND;
        compositeConstraint.targetType = "vsphere:Event";
        PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)"vsphere:Event", (String)"info.entity", (Comparator)Comparator.EQUALS, (Object)managedObjectReference);
        PropertyConstraint propertyConstraint2 = QueryUtil.createPropertyConstraint((String)"vsphere:Event", (String)"info.recursion", (Comparator)Comparator.EQUALS, (Object)"recursion.self");
        PropertyConstraint propertyConstraint3 = QueryUtil.createPropertyConstraint((String)"vsphere:Event", (String)"info.serverGuid", (Comparator)Comparator.EQUALS, (Object)managedObjectReference.getServerGuid());
        compositeConstraint.nestedConstraints = new Constraint[]{propertyConstraint, propertyConstraint2, propertyConstraint3};
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)compositeConstraint, (String[])new String[]{Util.MIGRATION_HISTORY});
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[]{Util.MIGRATION_HISTORY};
        propertySpec.relation = "";
        propertySpec.type = "vsphere:Event";
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.parameter = null;
        parameterSpec.propertyName = Util.MIGRATION_HISTORY;
        propertySpec.parameters = new ParameterSpec[]{parameterSpec};
        querySpec.resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = -1;
        resultSpec.offset = 0;
        querySpec.resultSpec = resultSpec;
        ResultSet resultSet = this.getData(querySpec);
        for (ResultItem resultItem : resultSet.items) {
            for (PropertyValue propertyValue : resultItem.properties) {
                if (!(propertyValue.value instanceof ManagedObjectReference)) continue;
                arrayList.add((ManagedObjectReference)propertyValue.value);
            }
        }
        return arrayList;
    }

    private ManagedObjectReference makeVirtualMachineMO(String string) {
        ManagedObjectReference managedObjectReference = null;
        try {
            String[] stringArray = string.split(":");
            if (stringArray.length == 3) {
                String string2 = stringArray[0];
                string2 = string2.substring(string2.lastIndexOf(46) + 1);
                managedObjectReference = new ManagedObjectReference(string2, stringArray[2], stringArray[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return managedObjectReference;
    }
}

