/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl.i18n;

import com.vmware.opsmgmt.client.event.impl.EntityEventArgumentWrapper;
import com.vmware.opsmgmt.client.event.impl.i18n.MessageParserUtil;
import com.vmware.opsmgmt.client.event.util.Util;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.event.ChangesInfoEventArgument;
import com.vmware.vim.binding.vim.event.EntityEventArgument;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.ExtendedEvent;
import com.vmware.vim.binding.vim.event.HostEventArgument;
import com.vmware.vim.binding.vim.event.VmEventArgument;
import com.vmware.vim.binding.vim.vm.Message;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.core.model.ArrayDataObject;
import com.vmware.vise.core.model.DataObject;
import com.vmware.vise.core.model.StringDataObject;
import com.vmware.vise.messaging.amf.DataObjectProxy;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageParser {
    private static final Log _logger = LogFactory.getLog(MessageParser.class);
    private static final String FT_PRIMARY_NAME_SUFFIX = "\\p";
    private static final String FT_PRIMARY_NAME_KEY_SUFFIX = "ft.primary.suffix";
    private static final String FT_SECONDARY_NAME_SUFFIX = "\\s";
    private static final String FT_SECONDARY_NAME_KEY_SUFFIX = "ft.secondary.suffix";
    private static final String TYPE_DELIMITER = "|";
    private static final String ENUM_DELIMITER = "@";
    private static final String TASK_DESCRIPTION_PROPERTY_NAME = "descriptionId";
    private static final String VM_MESSAGE_FIELD = "message";
    private static final String VM_MESSAGE_INFO_FIELD = "messageInfo";
    private static final String DVS_PORT_KEY_FIELD = "portKey";
    private static final String DVS_CHANGES_INFO_FIELD = "configChanges";
    private List<EntityEventArgumentWrapper> _eventArgumentWrappers = new ArrayList<EntityEventArgumentWrapper>();
    private final DataObjectProxy _dataObjectProxy;
    private final Event _serverEvent;
    private String _fullFormattedMessage = "";
    private String _linkableFormattedMessage = "";

    public MessageParser(DataObjectProxy dataObjectProxy, Event event) {
        this._dataObjectProxy = dataObjectProxy;
        this._serverEvent = event;
    }

    public String getFullFormattedMessage() {
        return this._fullFormattedMessage;
    }

    public String getLinkableFormattedMessage() {
        return this._linkableFormattedMessage;
    }

    public List<EntityEventArgumentWrapper> getArguments() {
        return this._eventArgumentWrappers;
    }

    public String fixupFTName(String string) {
        String string2 = string;
        string2 = this.getVmName(string2, FT_PRIMARY_NAME_SUFFIX, FT_PRIMARY_NAME_KEY_SUFFIX);
        string2 = this.getVmName(string2, FT_SECONDARY_NAME_SUFFIX, FT_SECONDARY_NAME_KEY_SUFFIX);
        return string2;
    }

    public void parse(String string) {
        String[] stringArray;
        int n = string.indexOf(TYPE_DELIMITER);
        if (n > -1) {
            string = string.substring(n + 1);
        }
        this._fullFormattedMessage = string;
        this._linkableFormattedMessage = string;
        for (String string2 : stringArray = MessageParserUtil.collectSubstitutionVariables(string)) {
            String string3 = string2.substring(1, string2.length() - 1);
            if (string3.trim().length() <= 0) continue;
            String string4 = "";
            int n2 = string3.indexOf(ENUM_DELIMITER);
            if (n2 > 0) {
                string4 = string3.substring(n2 + 1);
                string3 = string3.substring(0, n2 - 1);
            }
            EntityEventArgumentWrapper entityEventArgumentWrapper = new EntityEventArgumentWrapper();
            String string5 = this.formatReplacementString(string3, string4, entityEventArgumentWrapper);
            this._fullFormattedMessage = this.replace(this._fullFormattedMessage, string2, string5);
            if (!entityEventArgumentWrapper.isInventoryObject()) {
                this._linkableFormattedMessage = this.replace(this._linkableFormattedMessage, string2, string5);
                continue;
            }
            this._eventArgumentWrappers.add(entityEventArgumentWrapper);
        }
    }

    private String formatReplacementString(String string, String string2, EntityEventArgumentWrapper entityEventArgumentWrapper) {
        String string3;
        Object object;
        String[] stringArray = this.getObjectNameForEventEx(string);
        boolean bl = stringArray != null;
        String string4 = "";
        Object[] objectArray = null;
        Object object2 = null;
        if (!bl && (objectArray = this.resolveValues(this._serverEvent, string.split("\\."))) != null) {
            stringArray = objectArray[objectArray.length - 1];
        }
        if (stringArray == null) {
            return string4;
        }
        if (string2.indexOf("enum.") > -1) {
            object = String.format("%s.%s.label", string2.substring(string2.indexOf(".") + 1), this.toStringValue(stringArray));
            string4 = LocalizationUtil.getLocalizedMessage((String)object, null);
            string4 = this.stringNotFound(string4, (String)object);
        } else if (stringArray instanceof EntityEventArgument || stringArray instanceof HostEventArgument) {
            object2 = stringArray;
        } else {
            object = this.entityEventArgumentArray(stringArray);
            if (object != null) {
                if (((EntityEventArgument[])object).length > 1) {
                    string4 = string4 + " ...";
                }
                object2 = ((EntityEventArgument)object).length > 0 ? object[0] : object;
            } else {
                string4 = this.toStringValue(stringArray);
            }
        }
        if (object2 == null) {
            object2 = objectArray == null || objectArray.length < 2 ? string4 : objectArray[objectArray.length - 2];
        }
        if (object2 instanceof EntityEventArgument) {
            object = object2;
            entityEventArgumentWrapper.setArgumnents((EntityEventArgument)object);
            if (bl) {
                string4 = object.name;
            }
        } else if (object2 instanceof TaskInfo && TASK_DESCRIPTION_PROPERTY_NAME.equals(string3 = (object = string.split("\\."))[((String[])object).length - 1])) {
            String string5 = String.format("%s.label", this.toStringValue(stringArray));
            string4 = LocalizationUtil.getLocalizedMessage((String)string5, null);
            string4 = this.stringNotFound(string4, string5);
        }
        return string4;
    }

    private Object getObjectNameForEventEx(String string) {
        Object object = null;
        if (this._serverEvent instanceof EventEx) {
            EventEx eventEx = (EventEx)this._serverEvent;
            if (eventEx.arguments != null) {
                for (KeyAnyValue keyAnyValue : eventEx.arguments) {
                    if (!keyAnyValue.getKey().equals(string)) continue;
                    object = keyAnyValue.getValue();
                    break;
                }
            }
        }
        return object;
    }

    private EntityEventArgument[] entityEventArgumentArray(Object object) {
        Class<?> clazz;
        Object object2 = this._dataObjectProxy.instanceComplete(object);
        if (object2 != null && object2.getClass().isArray() && EntityEventArgument.class.isAssignableFrom(clazz = object2.getClass().getComponentType())) {
            return (EntityEventArgument[])object2;
        }
        return null;
    }

    private String replace(String string, String string2, String string3) {
        string3 = this.fixupFTVmName(this._serverEvent.vm, string3);
        string3 = MixedUtil.unescapeVimEntityNameSpecialChars((String)string3);
        string = string.replace(string2, string3);
        return string;
    }

    private Object[] resolveValues(Object object, String[] stringArray) {
        DataObject dataObject;
        ExtendedEvent.Pair[] pairArray;
        Object object2;
        if (object == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return new Object[]{object};
        }
        Object[] objectArray = new Object[stringArray.length];
        Object object3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            object2 = stringArray[i];
            try {
                Object object4;
                ArrayDataObject arrayDataObject;
                pairArray = this.extractLocalizedMessageInfo(object, stringArray);
                if (pairArray != null) {
                    return new Object[]{pairArray};
                }
                String string = this.extractLocalizedChangesInfo(object, stringArray);
                if (string != null) {
                    return new Object[]{string};
                }
                object3 = this._dataObjectProxy.getValue(object3 != null ? object3 : object, (String)object2);
                boolean bl = false;
                if (object3 instanceof ArrayDataObject && !(arrayDataObject = (ArrayDataObject)object3).getIsUnset() && (object4 = arrayDataObject.getValue()) instanceof String[]) {
                    objectArray[i] = StringUtils.join((Object[])((String[])object4), (String)", ");
                    bl = true;
                }
                if (bl) continue;
                objectArray[i] = object3;
                continue;
            }
            catch (Exception exception) {
                if (!_logger.isWarnEnabled()) continue;
                _logger.warn((Object)("Failed to resolve path: " + (String)object2 + ", from paths: " + Arrays.toString(stringArray)));
            }
        }
        if (objectArray[0] instanceof ArrayDataObject) {
            ArrayDataObject arrayDataObject = (ArrayDataObject)objectArray[0];
            if (arrayDataObject.getIsUnset()) {
                objectArray[0] = this.unspecifiedStringValue();
            } else {
                object2 = arrayDataObject.getValue();
                if (object2 instanceof ExtendedEvent.Pair[]) {
                    pairArray = (ExtendedEvent.Pair[])arrayDataObject.getValue();
                    for (int i = 0; i < pairArray.length; ++i) {
                        ExtendedEvent.Pair pair = pairArray[i];
                        if (pair.key.compareToIgnoreCase(stringArray[1]) != 0) continue;
                        return new Object[]{pair.value};
                    }
                }
            }
        } else if (objectArray[0] instanceof DataObject && (dataObject = (DataObject)objectArray[0]).getIsUnset()) {
            objectArray[0] = this.unspecifiedStringValue();
        }
        return objectArray;
    }

    private StringDataObject unspecifiedStringValue() {
        StringDataObject stringDataObject = new StringDataObject();
        stringDataObject.setValue(Util.getLocalizedString("eventAttribute.notSpecified"));
        return stringDataObject;
    }

    private String extractLocalizedMessageInfo(Object object, String[] stringArray) {
        block5: {
            if (stringArray.length == 1 && stringArray[0].equals(VM_MESSAGE_FIELD)) {
                Object object2 = this._dataObjectProxy.getValue(object, VM_MESSAGE_INFO_FIELD);
                if (object2 == null) {
                    return null;
                }
                if (!(object2 instanceof ArrayDataObject)) {
                    return null;
                }
                try {
                    ArrayDataObject arrayDataObject = (ArrayDataObject)object2;
                    Object[] objectArray = (Object[])arrayDataObject.getValue();
                    Message message = (Message)objectArray[0];
                    return message.text;
                }
                catch (Exception exception) {
                    if (!_logger.isWarnEnabled()) break block5;
                    _logger.warn((Object)("Unexpected failure in extractLocalizedMessageInfo: " + exception.getMessage()));
                }
            }
        }
        return null;
    }

    private String extractLocalizedChangesInfo(Object object, String[] stringArray) {
        if (stringArray.length != 1 || !stringArray[0].equals(DVS_CHANGES_INFO_FIELD)) {
            return null;
        }
        Object object2 = this._dataObjectProxy.getValue(object, DVS_PORT_KEY_FIELD);
        if (object2 == null || !(object2 instanceof ArrayDataObject)) {
            return null;
        }
        Object object3 = this._dataObjectProxy.getValue(object, DVS_CHANGES_INFO_FIELD);
        if (object3 == null || !(object3 instanceof ArrayDataObject)) {
            return null;
        }
        String[] stringArray2 = (String[])((ArrayDataObject)object2).getValue();
        ChangesInfoEventArgument[] changesInfoEventArgumentArray = (ChangesInfoEventArgument[])((ArrayDataObject)object3).getValue();
        if (stringArray2 == null || changesInfoEventArgumentArray == null || stringArray2.length != changesInfoEventArgumentArray.length) {
            return Util.getLocalizedString("eventAttribute.notSpecified");
        }
        String string = Util.getLocalizedString("dvsPortGroupChangeFormat");
        Object[] objectArray = new String[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            String string2 = stringArray2[i];
            ChangesInfoEventArgument changesInfoEventArgument = changesInfoEventArgumentArray[i];
            String string3 = this.getDefaultString(changesInfoEventArgument.added);
            String string4 = this.getDefaultString(changesInfoEventArgument.modified);
            String string5 = this.getDefaultString(changesInfoEventArgument.deleted);
            objectArray[i] = String.format(string, string2, string3, string4, string5);
        }
        return StringUtils.join((Object[])objectArray, (String)"\n");
    }

    private String getDefaultString(String string) {
        return !StringUtil.isNullOrEmpty((String)string) ? string : Util.getLocalizedString("eventAttribute.notSpecified");
    }

    private String stringNotFound(String string, String string2) {
        if (!StringUtil.isNullOrEmpty((String)string)) {
            return string;
        }
        String string3 = null;
        string3 = String.format("%s %s %s", "XXX", string2, "XXX");
        return string3;
    }

    private String toStringValue(Object object) {
        String string = String.valueOf(object);
        Object object2 = this._dataObjectProxy.instanceComplete(object);
        if (object2 != null) {
            string = String.valueOf(object2);
        } else if (object instanceof VirtualMachine.FaultToleranceState) {
            string = ((VirtualMachine.FaultToleranceState)object).name();
        }
        return string;
    }

    private String fixupFTVmName(VmEventArgument vmEventArgument, String string) {
        if (StringUtil.isNullOrEmpty((String)string) || vmEventArgument == null || !string.equals(vmEventArgument.name)) {
            return string;
        }
        String string2 = this.fixupFTName(string);
        vmEventArgument.setName(string2);
        return string2;
    }

    private String getVmName(String string, String string2, String string3) {
        String string4;
        int n = string.indexOf(string2);
        if (n >= 0 && (string4 = LocalizationUtil.getLocalizedMessage((String)string3, null)) != null) {
            string = string.replace(string2, string4);
        }
        return string;
    }
}

