/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.security;

import com.vmware.vise.security.Utils;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.logging.LogUtil;
import com.vmware.vise.util.session.SessionUtil;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionListener
implements HttpSessionListener {
    private static final Log _logger = LogFactory.getLog(SessionListener.class);
    static final String USER_SESSION_LISTENERS = "USER_SESSION_LISTENERS";

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        block5: {
            HttpSession httpSession = httpSessionEvent.getSession();
            try {
                String string;
                if (_logger.isTraceEnabled()) {
                    string = ExceptionUtil.getCurrentStackTrace();
                    _logger.trace((Object)("sessionCreated invoked by:\n" + string));
                }
                if (_logger.isInfoEnabled()) {
                    string = SessionUtil.getHashedSessionId((HttpSession)httpSession);
                    String string2 = null;
                    if (httpSession.getServletContext() != null) {
                        string2 = httpSession.getServletContext().getContextPath();
                    }
                    _logger.info((Object)("Session " + string + " created with context path: " + string2));
                }
                httpSession.setAttribute("#VMWARE_CLEANUP_CLIENT_SESSION_LISTENER#", (Object)Boolean.TRUE);
            }
            catch (Exception exception) {
                if (!_logger.isErrorEnabled()) break block5;
                _logger.error((Object)"Error when handling session created event", (Throwable)exception);
            }
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        SessionListener.handleSessionDestroyed(httpSessionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void handleSessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        try {
            Object object;
            String string;
            SessionUtil.setHttpSession((HttpSession)httpSession);
            String string2 = SessionUtil.getHashedSessionId((HttpSession)httpSession);
            String string3 = Thread.currentThread().getName();
            if (_logger.isTraceEnabled() || string3.startsWith("http-bio-") || string3.startsWith("data-service-")) {
                string = ExceptionUtil.getCurrentStackTrace();
                object = "sessionDestroyed invoked for sessionId " + string2 + " by:\n" + string;
                if (_logger.isTraceEnabled()) {
                    _logger.trace(object);
                } else {
                    _logger.info(object);
                }
            } else {
                _logger.info((Object)("sessionDestroyed invoked for sessionId " + string2));
            }
            LogUtil.putSessionInfoIntoLogContext((HttpSession)httpSession);
            string = SessionUtil.getHashedClientId((HttpSession)httpSession);
            if (StringUtil.isNullOrEmpty((String)string)) {
                if (_logger.isWarnEnabled()) {
                    _logger.warn((Object)("No clientId found for session " + string2 + " with context-path {" + SessionListener.getContextPath(httpSession)));
                }
                return;
            }
            object = Utils.getAuthenticationProvider(httpSession);
            if (object != null) {
                object.logout(httpSession);
            }
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)("Session " + string2 + " with context-path {" + SessionListener.getContextPath(httpSession) + "} associated with client " + string + " is destroyed."));
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Error in handling session destroyed event.", (Throwable)exception);
        }
        finally {
            SessionUtil.setHttpSession(null);
            try {
                if (SessionUtil.isLoggedOut((HttpSession)httpSession)) {
                    SessionUtil.removeAll((HttpSession)httpSession);
                }
            }
            catch (Exception exception) {
                _logger.error((Object)"Error while removing data for session", (Throwable)exception);
            }
            LogUtil.removeSessionInfoFromLogContext();
        }
    }

    public static void invalidate(@Nullable HttpSession httpSession) {
        String string = SessionUtil.getClientId((HttpSession)httpSession);
        if (string == null) {
            return;
        }
        String string2 = SessionUtil.getHashedSessionId((HttpSession)httpSession);
        SessionListener.invalidate(string, httpSession, string2);
    }

    static void invalidate(@Nullable String string, @Nullable HttpSession httpSession, @Nullable String string2) {
        if (string == null) {
            return;
        }
        if (SessionUtil.isLoggedOut((String)string)) {
            String string3 = SessionUtil.getHashedClientId((String)string);
            SessionUtil.removeAll((String)string, (HttpSession)httpSession, (String)string2);
            _logger.info((Object)("Flex client " + string3 + " is invalidated."));
        }
    }

    private static String getContextPath(HttpSession httpSession) {
        if (httpSession == null || httpSession.getServletContext() == null) {
            return null;
        }
        return httpSession.getServletContext().getContextPath();
    }
}

