/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.security;

import com.vmware.vise.util.session.SessionUtil;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class SessionManagementFilter
extends OncePerRequestFilter {
    private static final Log _logger = LogFactory.getLog(SessionManagementFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        try {
            SessionUtil.setHttpRequest((HttpServletRequest)httpServletRequest);
            String string = httpServletRequest.getRequestURI().toLowerCase();
            boolean bl = string.endsWith(".html");
            if (bl) {
                HttpSession httpSession = httpServletRequest.getSession(false);
                if (httpSession == null) {
                    httpSession = httpServletRequest.getSession(true);
                } else if (SessionUtil.isLogoutInitiated((HttpSession)httpSession)) {
                    _logger.error((Object)("An attempt was made to access a logged-out session (" + SessionUtil.getSessionInfo() + "), returning HTTP status code " + 401 + " to this request: " + string));
                    httpServletResponse.setStatus(401);
                    return;
                }
                String string2 = httpServletRequest.getParameter("webClientSessionId");
                if (string2 != null) {
                    String string3 = SessionUtil.getClientId((HttpSession)httpSession);
                    if (!string2.equals(string3)) {
                        try {
                            SessionUtil.associateSessionWithClientId((HttpSession)httpSession, (String)string2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            _logger.warn((Object)"The clientId is invalid. This is probably because a different session associated with the clientId has expired or logged out.");
                            httpServletResponse.setStatus(401);
                            SessionUtil.setHttpRequest(null);
                            return;
                        }
                    } else if (SessionUtil.isAssociatedWithInvalidClientId((HttpSession)httpSession)) {
                        _logger.error((Object)("An attempt was made to access a session associated with an invalid clientId. (" + SessionUtil.getSessionInfo() + "), returning HTTP status code " + 401 + " to this request: " + string));
                        httpServletResponse.setStatus(401);
                        return;
                    }
                }
            }
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
    }
}

