/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.security;

import com.vmware.vise.security.DefaultAuthenticationProviderInternal;
import com.vmware.vise.util.session.SessionUtil;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Utils {
    private static final String AUTH_PROVIDER_KEY = DefaultAuthenticationProviderInternal.class.getName() + "_KEY";
    private static final Log _logger = LogFactory.getLog(Utils.class);

    Utils() {
    }

    static DefaultAuthenticationProviderInternal getAuthenticationProvider(HttpSession httpSession) {
        return (DefaultAuthenticationProviderInternal)SessionUtil.getData((String)AUTH_PROVIDER_KEY, (HttpSession)httpSession);
    }

    static void setAuthenticationProvider(DefaultAuthenticationProviderInternal defaultAuthenticationProviderInternal, HttpSession httpSession) {
        if (defaultAuthenticationProviderInternal == null) {
            String string = SessionUtil.getHashedSessionId((HttpSession)httpSession);
            _logger.error((Object)("authProvider is null for session: " + string));
            throw new IllegalArgumentException("authProvider");
        }
        if (_logger.isDebugEnabled()) {
            String string = SessionUtil.getHashedSessionId((HttpSession)httpSession);
            _logger.debug((Object)("Utils - Setting authentication provider for session: " + string));
        }
        SessionUtil.setData((String)AUTH_PROVIDER_KEY, (Object)defaultAuthenticationProviderInternal, (HttpSession)httpSession);
    }

    static DefaultAuthenticationProviderInternal removeAuthenticationProvider(HttpSession httpSession) {
        return (DefaultAuthenticationProviderInternal)SessionUtil.removeData((String)AUTH_PROVIDER_KEY, (HttpSession)httpSession);
    }
}

