/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.impl;

import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceEndPointType;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointTypeImpl;
import com.vmware.vim.sso.client.ConfirmationType;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vsphere.client.provisioning.util.ProvisioningServiceUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransferPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(TransferPropertyProvider.class);
    private final SsoService _ssoService;
    private final ComponentManagerService _cmService;

    public TransferPropertyProvider(SsoService ssoService, ComponentManagerService cmService) {
        Validate.notNull((Object)ssoService, (String)"SSO service null");
        Validate.notNull((Object)cmService, (String)"CM service null");
        this._ssoService = ssoService;
        this._cmService = cmService;
    }

    @type(value="*")
    public URI getVApiRestEndpoint(Object dummyContextItem) throws Exception {
        String endpointType = "com.vmware.vapi.endpoint";
        String endpointProtocol = "vapi.rest.https";
        SearchCriteriaImpl criteria = new SearchCriteriaImpl();
        criteria.setSelectionMethod(SearchCriteria.SelectionMethod.ALL.toString());
        criteria.setEndPointType((ServiceEndPointType)new ServiceEndPointTypeImpl());
        criteria.getEndPointType().setTypeId("com.vmware.vapi.endpoint");
        criteria.getEndPointType().setEndPointProtocol("vapi.rest.https");
        ServiceInfo[] result = this._cmService.search((SearchCriteria)criteria);
        ServiceEndPoint vapiEndpoint = this.getServiceEndpoint(result, "com.vmware.vapi.endpoint", "vapi.rest.https");
        if (vapiEndpoint == null) {
            _logger.error((Object)("Unable to obtain vApi endpoint of type 'com.vmware.vapi.endpoint' and protocol 'vapi.rest.https' from Component Manager. Search returned:\n" + ObjectUtil.prettyPrint((Object)result)));
            String message = ProvisioningServiceUtil.getLocalizedString("error.cmVapiRestEndpoint");
            throw new Error(message);
        }
        return vapiEndpoint.getUrl();
    }

    @type(value="*")
    public String getVApiRestAuthToken(Object dummyContextItem) {
        SamlToken ssoToken = AuthSessionUtil.getSsoToken();
        if (ssoToken == null) {
            _logger.error((Object)"No SSO token in session");
            return "";
        }
        if (!ssoToken.isDelegable()) {
            _logger.error((Object)"Session SSO token is not delegable");
            return "";
        }
        SamlToken bearerToken = this.getBearerToken(ssoToken);
        if (bearerToken == null) {
            return "";
        }
        String encodedToken = "";
        String tokenXml = bearerToken.toXml();
        byte[] tokenBytes = tokenXml.getBytes();
        ByteArrayOutputStream bufferStream = null;
        GZIPOutputStream compressorStream = null;
        try {
            bufferStream = new ByteArrayOutputStream(tokenBytes.length);
            compressorStream = new GZIPOutputStream(bufferStream);
            compressorStream.write(tokenBytes);
            compressorStream.close();
            byte[] gzipedToken = bufferStream.toByteArray();
            encodedToken = new String(Base64.encodeBase64((byte[])gzipedToken));
        }
        catch (IOException error) {
            this.tryClose(bufferStream);
            this.tryClose(compressorStream);
            _logger.error((Object)"Error packaging SAML token.", (Throwable)error);
        }
        return encodedToken;
    }

    private SamlToken getBearerToken(SamlToken sourceToken) {
        assert (sourceToken != null) : "sourceToken null";
        ConfirmationType type2 = sourceToken.getConfirmationType();
        if (ConfirmationType.BEARER.equals((Object)type2)) {
            _logger.debug((Object)"Token is a already bearer token. Returning original.");
            return sourceToken;
        }
        SamlToken result = null;
        try {
            long lifetime = (sourceToken.getExpirationTime().getTime() - sourceToken.getStartTime().getTime()) / 1000L;
            TokenSpec.Builder builder = new TokenSpec.Builder(lifetime);
            TokenSpec tokenSpec = builder.confirmation(TokenSpec.Confirmation.NONE).renewable(sourceToken.isRenewable()).delegationSpec(new TokenSpec.DelegationSpec(true)).createTokenSpec();
            SamlToken cloneToken = this._ssoService.acquireTokenByToken(sourceToken, tokenSpec);
            ConfirmationType clonedTokenType = cloneToken.getConfirmationType();
            if (ConfirmationType.BEARER.equals((Object)clonedTokenType)) {
                result = cloneToken;
            } else {
                _logger.error((Object)("Attempts to acquire bearer token from token " + sourceToken.toString() + " of type " + type2 + " failed. The new token type is " + clonedTokenType));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Exception acquiring bearer token from existing token.", (Throwable)ex);
        }
        return result;
    }

    private ServiceEndPoint getServiceEndpoint(ServiceInfo[] endpoints, String typeId, String protocol) {
        assert (typeId != null) : "typeId null";
        assert (protocol != null) : "protocol null";
        if (ArrayUtils.isEmpty((Object[])endpoints)) {
            return null;
        }
        for (ServiceInfo service : endpoints) {
            for (ServiceEndPoint endpoint : service.getServiceEndPoints()) {
                if (!typeId.equals(endpoint.getEndPointType().getTypeId()) || !protocol.equals(endpoint.getEndPointType().getEndPointProtocol())) continue;
                return endpoint;
            }
        }
        return null;
    }

    private void tryClose(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Throwable error) {
                _logger.error((Object)"Exception closing stream", error);
            }
        }
    }
}

