/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.util;

import com.vmware.vcenter.ovf.OvfWarning;
import com.vmware.vcenter.ovf.Property;
import com.vmware.vcenter.ovf.PropertyParams;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.json.JsonUtil;
import com.vmware.vsphere.client.provisioning.ovf.OvfQueryResult;
import com.vmware.vsphere.client.provisioning.workflow.Workflow;
import com.vmware.vsphere.client.util.collection.CollectionUtil;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ProvisioningServiceUtil {
    private static final String WORKFLOW_PATH_PROPERTY = "workflowPath";
    private static final String PROVISIONING_SERVICE_BUNDLE = "provisioningservice";
    private static final String TYPE_PREFIX = "${";
    private static final String TYPE_SUFFIX = "}";
    private static final String TYPE_SEPARATOR = ":";
    private static final String PROPERTIES_WARNING = "PropertyParams.properties";
    private static final String PROPERTIES_KEY = "non-configurable-properties";
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final Log _logger = LogFactory.getLog(ProvisioningServiceUtil.class);

    public static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)PROVISIONING_SERVICE_BUNDLE, (String)key, (ClassLoader)ProvisioningServiceUtil.class.getClassLoader());
    }

    public static String getLocalizedString(String key, String ... params) {
        return ResourceUtil.getString((String)PROVISIONING_SERVICE_BUNDLE, (String)key, (String[])params, (ClassLoader)ProvisioningServiceUtil.class.getClassLoader());
    }

    public static List<String> getWorkflowPath(List<Object> context, DataService dataService) throws Exception {
        Validate.notNull(context, (String)"null context");
        Validate.notNull((Object)dataService, (String)"null data service");
        Workflow workflow = (Workflow)CollectionUtil.getObjectByType(context, Workflow.class);
        if (workflow == null) {
            throw new IllegalArgumentException("Unable to find workflow in context.");
        }
        ParameterSpec parameter = new ParameterSpec();
        parameter.propertyName = WORKFLOW_PATH_PROPERTY;
        parameter.parameter = context;
        URI workflowUri = DefaultUriSchemeUtil.createUri((String)workflow.getClass().getName(), (String)workflow.id.toString());
        QuerySpec query = QueryUtil.buildQuerySpec((Object)workflowUri, (String[])new String[]{WORKFLOW_PATH_PROPERTY});
        query.resourceSpec.propertySpecs[0].parameters = new ParameterSpec[]{parameter};
        ResultSet resultSet = QueryUtil.getData((DataService)dataService, (QuerySpec)query);
        List result = Collections.emptyList();
        if (resultSet.items != null && resultSet.items.length > 0) {
            List newPath;
            result = newPath = (List)ResultUtil.getPropertyValue((ResultItem)resultSet.items[0], (String)WORKFLOW_PATH_PROPERTY).value;
        }
        return result;
    }

    public static void sortOVFProperties(PropertyParams propertyParams) {
        if (propertyParams == null || propertyParams.getProperties() == null) {
            return;
        }
        List ovfProperties = propertyParams.getProperties();
        TreeMap<String, 1> sortedMapOfCategories = new TreeMap<String, 1>();
        for (final Property property : ovfProperties) {
            String propertyCategory = property.getCategory();
            final String propertyLabel = property.getLabel();
            if (!sortedMapOfCategories.containsKey(propertyCategory)) {
                sortedMapOfCategories.put(propertyCategory, new TreeMap<String, Property>(){
                    {
                        this.put(propertyLabel, property);
                    }
                });
                continue;
            }
            if (((Map)sortedMapOfCategories.get(propertyCategory)).containsKey(propertyLabel)) continue;
            ((Map)sortedMapOfCategories.get(propertyCategory)).put(propertyLabel, property);
        }
        ArrayList<Property> sortedListOfOVFProperties = new ArrayList<Property>();
        for (Map properies : sortedMapOfCategories.values()) {
            for (Property property : properies.values()) {
                sortedListOfOVFProperties.add(property);
            }
        }
        propertyParams.setProperties(sortedListOfOVFProperties);
    }

    public static void addNonConfigurableProperties(OvfQueryResult ovfData, List<Object> context) {
        if (ovfData == null || ovfData.warnings == null || ovfData.warnings.isEmpty()) {
            return;
        }
        PropertyParams propertyParams = (PropertyParams)CollectionUtil.getObjectByType(context, PropertyParams.class);
        if (propertyParams == null || propertyParams.getProperties() == null) {
            return;
        }
        List allProperties = propertyParams.getProperties();
        for (OvfWarning warning : ovfData.warnings) {
            if (!PROPERTIES_WARNING.equals(warning.getName())) continue;
            ProvisioningServiceUtil.parseNonConfigurableProperties(warning, allProperties);
            return;
        }
    }

    public static void parseNonConfigurableProperties(OvfWarning ovfWarning, List<Property> allProperties) {
        Object[] propertiesValues;
        Map map;
        try {
            map = JsonUtil.mapFromJson((String)ovfWarning.getValue());
        }
        catch (IOException e) {
            _logger.error((Object)("Error while parsing ovf warning: " + ovfWarning.getValue()));
            return;
        }
        for (Object propertyValues : propertiesValues = (Object[])map.get(PROPERTIES_KEY)) {
            Map propertyValuesMap = (Map)propertyValues;
            String id = (String)propertyValuesMap.get(ID);
            String type2 = (String)propertyValuesMap.get(TYPE);
            if (type2 == null || !type2.contains(TYPE_SEPARATOR) || !type2.startsWith(TYPE_PREFIX) || !type2.endsWith(TYPE_SUFFIX)) continue;
            type2 = type2.substring(2, type2.indexOf(TYPE_SEPARATOR));
            Property newProperty = new Property();
            newProperty.setType(type2);
            newProperty.setLabel(type2);
            newProperty.setId(id);
            newProperty.setCategory("");
            newProperty.setDescription("");
            allProperties.add(newProperty);
        }
    }
}

