/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.authorization.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.vmware.cis.authorization.VcAuthorizationManager;
import com.vmware.cis.authorization.client.DocHierarchyPlugin;
import com.vmware.cis.authorization.impl.AuthInfo;
import com.vmware.cis.authorization.impl.AuthInfoDetailsProvider;
import com.vmware.cis.authorization.impl.AuthorizationManagerImpl;
import com.vmware.cis.authorization.impl.Caches;
import com.vmware.cis.authorization.impl.PrincipalImpl;
import com.vmware.cis.authorization.impl.SessionAuthDataImpl;
import com.vmware.cis.authorization.impl.StoreCache;
import com.vmware.cis.authorization.impl.SysViewPrivilegeDetailsProvider;
import com.vmware.cis.authorization.impl.UserPrivilegeData;
import com.vmware.cis.core.AuthInfoProvider;
import com.vmware.cis.core.Permission;
import com.vmware.cis.core.PrivilegeChecker;
import com.vmware.cis.core.PrivilegeData;
import com.vmware.cis.core.RoleData;
import com.vmware.cis.core.exception.AuthorizationException;
import com.vmware.cis.core.util.AccessControlList;
import com.vmware.cis.core.util.GenerationalCache;
import com.vmware.cis.core.util.Helper;
import com.vmware.cis.core.util.ImmutableUtils;
import com.vmware.cis.core.util.TransformerHelper;
import com.vmware.vim.binding.dataservice.accesscontrol.AccessControl;
import com.vmware.vim.binding.dataservice.accesscontrol.AclMapping;
import com.vmware.vim.binding.dataservice.accesscontrol.Principal;
import com.vmware.vim.binding.dataservice.accesscontrol.Privilege;
import com.vmware.vim.binding.dataservice.accesscontrol.Role;
import com.vmware.vim.binding.dataservice.accesscontrol.internal.AuthInfoData;
import com.vmware.vim.binding.dataservice.accesscontrol.internal.AuthInfoDetail;
import com.vmware.vim.binding.dataservice.accesscontrol.internal.PermissionsDetail;
import com.vmware.vim.binding.dataservice.accesscontrol.internal.SysViewPrivilegeDetail;
import com.vmware.vim.binding.impl.dataservice.accesscontrol.AclMappingImpl;
import com.vmware.vim.binding.impl.dataservice.accesscontrol.PrivilegeImpl;
import com.vmware.vim.binding.impl.dataservice.accesscontrol.RoleImpl;
import com.vmware.vim.binding.impl.dataservice.accesscontrol.internal.AuthInfoDataImpl;
import com.vmware.vim.binding.impl.dataservice.accesscontrol.internal.AuthInfoDetailImpl;
import com.vmware.vim.binding.impl.dataservice.accesscontrol.internal.PermissionsDetailImpl;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.vmomi.server.session.Session;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AclPrivilegeValidator
implements PrivilegeChecker,
AuthInfoProvider {
    private static final Log _log = LogFactory.getLog(AclPrivilegeValidator.class);
    private final VcAuthorizationManager _authManager;
    private final AuthInfoDetailsProvider _memCache;
    private final SysViewPrivilegeDetailsProvider _sysViewPrivilegeCache;
    private final Caches _caches;
    private static final String COLON = "%3A";

    public AclPrivilegeValidator(VcAuthorizationManager authManager, Caches caches, AuthInfoDetailsProvider memCache) {
        this._authManager = authManager;
        this._caches = caches;
        this._memCache = memCache;
        this._sysViewPrivilegeCache = null;
    }

    public AclPrivilegeValidator(VcAuthorizationManager authManager, Caches caches, AuthInfoDetailsProvider memCache, SysViewPrivilegeDetailsProvider sysViewPrivilegeCache) {
        this._authManager = authManager;
        this._caches = caches;
        this._memCache = memCache;
        this._sysViewPrivilegeCache = sysViewPrivilegeCache;
    }

    public LinkedHashMap<URI, Collection<AccessControl>> getPermissions(String objId) {
        return this.getPermissions(objId, false);
    }

    public LinkedHashMap<URI, Collection<AccessControl>> getPermissions(String objId, boolean propagationOnly) {
        LinkedHashMap<String, Collection<Permission>> permissions;
        try {
            permissions = this._authManager.getPermission(objId, propagationOnly);
        }
        catch (AuthorizationException e) {
            _log.error((Object)("Error occured get permissions for an the object " + objId), (Throwable)e);
            throw new SecurityError();
        }
        LinkedHashMap<URI, Collection<AccessControl>> result = new LinkedHashMap<URI, Collection<AccessControl>>();
        for (Map.Entry entry : permissions.entrySet()) {
            AccessControlList set = new AccessControlList();
            for (Permission p : (Collection)entry.getValue()) {
                AccessControl permissionImpl = TransformerHelper.getAccessControl((Permission)p);
                set.add((Object)permissionImpl);
            }
            if (set.isEmpty()) continue;
            try {
                result.put(new URI(Helper.decode((String)((String)entry.getKey()))), (Collection<AccessControl>)set);
            }
            catch (URISyntaxException e) {
                _log.warn((Object)"Invalid doc URI ", (Throwable)e);
            }
        }
        return result;
    }

    public AccessControl getAccessControl(String objId, String userName, boolean isGroup) {
        LinkedHashMap<String, Collection<Permission>> permissions;
        try {
            permissions = this._authManager.getPermission(objId);
        }
        catch (AuthorizationException e) {
            _log.error((Object)("Error occured get permissions for an the object " + objId), (Throwable)e);
            throw new SecurityError();
        }
        Collection perms = (Collection)permissions.get(objId);
        if (perms == null) {
            return null;
        }
        for (Permission permission : perms) {
            if (!permission.getPrincipal().getName().equals(userName) || permission.getPrincipal().isGroup() != isGroup) continue;
            return TransformerHelper.getAccessControl((Permission)permission);
        }
        return null;
    }

    public boolean isAllowed(String docId, String userName, Set<String> groups, Collection<String> privileges) {
        return this.isAllowed(docId, userName, groups, privileges, false);
    }

    public boolean isAllowed(String docId, String userName, Set<String> groups, Collection<String> privileges, boolean propagationOnly) {
        Set<String> userPrivileges;
        com.vmware.cis.core.Principal principal = this.getPrincipal(userName, groups);
        try {
            userPrivileges = this._authManager.getUserPrivileges(principal, docId, propagationOnly);
        }
        catch (AuthorizationException e) {
            _log.error((Object)"Error occured checking privileges for the user", (Throwable)e);
            throw new SecurityError();
        }
        userPrivileges.add("System.Anonymous");
        return userPrivileges.containsAll(privileges);
    }

    public boolean isAllowedSystemViewCache(String docId, String userName, Set<String> groups) {
        com.vmware.cis.core.Principal principal = this.getPrincipal(userName, groups);
        String priv = ((AuthorizationManagerImpl)this._authManager).getPrivFromSysViewCache(principal, docId);
        return "System.View".equals(priv);
    }

    public void privilegeCheck(Session session, Collection<String> privileges) {
        com.vmware.cis.core.Principal principal = this.getPrincipal(session);
        try {
            if (!this._authManager.isAllowedOnRoot(principal, privileges)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("User does not have privileges " + privileges + " on root"));
                }
                throw new SecurityError();
            }
        }
        catch (AuthorizationException e) {
            _log.error((Object)"Error occured checking privileges for the user", (Throwable)e);
            throw new SecurityError();
        }
    }

    public void privilegeCheck(String docId, Session session, Collection<String> privileges) {
        this.privilegeCheck(docId, session, privileges, false);
    }

    public void privilegeCheck(String docId, Session session, Collection<String> privileges, boolean propagationOnly) {
        com.vmware.cis.core.Principal principal = this.getPrincipal(session);
        try {
            if (!this._authManager.isAllowed(principal, docId, privileges, propagationOnly)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("User " + principal.getName() + " does not have privileges " + privileges + " on object " + docId));
                }
                throw new SecurityError();
            }
        }
        catch (AuthorizationException e) {
            _log.warn((Object)"Error occured checking privileges for the user", (Throwable)e);
            throw new SecurityError();
        }
    }

    private com.vmware.cis.core.Principal getPrincipal(Session session) {
        SessionAuthDataImpl authData = (SessionAuthDataImpl)session.getAuthData();
        if (authData == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Auth data null in session. Returning false");
            }
            throw new SecurityError();
        }
        com.vmware.cis.core.Principal principal = authData.getPrincipal();
        return principal;
    }

    private com.vmware.cis.core.Principal getPrincipal(String userName, Set<String> groups) {
        return new PrincipalImpl(userName, groups);
    }

    public SysViewPrivilegeDetail getImpliedSystemViewPrivilegeDetail(Set<String> providers, Set<String> products, String fromVersion) {
        throw new RuntimeException("Not Implmented");
    }

    public AuthInfoDetail getAuthInfoDetail(final Set<String> providers, final Set<String> products, String fromVersion) {
        GenerationalCache.Update<String, AuthInfo> updates = this._memCache.getAuthInfos(fromVersion);
        Collection filter = Collections2.filter(updates.getMap().entrySet(), (Predicate)new Predicate<Map.Entry<String, AuthInfo>>(){

            public boolean apply(Map.Entry<String, AuthInfo> entry) {
                AuthInfo authInfo = entry.getValue();
                if (authInfo == null) {
                    return true;
                }
                return AclPrivilegeValidator.this.filterBasedOnProviderAndProducts((Set<String>)providers, (Set<String>)products, authInfo);
            }
        });
        Collection list = ImmutableUtils.tranformCollection((Collection)filter, (ImmutableUtils.TransformFunc)new ImmutableUtils.TransformFunc<Map.Entry<String, AuthInfo>, AuthInfoData>(){

            public AuthInfoData apply(Map.Entry<String, AuthInfo> entry) {
                AuthInfoDataImpl data = new AuthInfoDataImpl();
                data.setId(Helper.decode((String)entry.getKey()));
                AuthInfo info = entry.getValue();
                if (info == null || info.isDeleted()) {
                    data.setIsDeleted(Boolean.valueOf(true));
                    return data;
                }
                data.setAltParent(Helper.decode((String)info.getAltParent()));
                data.setIsDeleted(Boolean.valueOf(info.isDeleted()));
                if (info.getOwner() != null) {
                    data.setOwner((Principal)AclPrivilegeValidator.this.createPrincipal(info));
                }
                data.setParent(Helper.decode((String)info.getParent()));
                data.setProduct(info.getProduct());
                data.setProviderUuid(info.getProviderUuid());
                data.setResolvedId(Helper.decode((String)info.getResolvedId()));
                return data;
            }
        });
        AuthInfoDetailImpl result = new AuthInfoDetailImpl();
        result.setVersion(updates.getVersion());
        result.setIsDelta(updates.isDelta());
        result.setAuthInfoData(list.toArray(new AuthInfoData[0]));
        return result;
    }

    public Collection<Role> getRoles() {
        return ImmutableUtils.tranformCollection(this._caches.getRolesCache().get().values(), (ImmutableUtils.TransformFunc)new ImmutableUtils.TransformFunc<RoleData, Role>(){

            public Role apply(RoleData data) {
                RoleImpl role = new RoleImpl();
                role.setId(data.getId());
                role.setName(data.getName());
                role.setVersion(data.getVersion());
                role.setPrivilegeId(data.getPrivilegeIds().toArray(new String[0]));
                role.setDescription(data.getDesciption());
                role.setTenant(data.getTenant());
                return role;
            }
        });
    }

    public Collection<Privilege> getPrivileges() {
        return ImmutableUtils.tranformCollection(this._caches.getPrivilegesCache().get().values(), (ImmutableUtils.TransformFunc)new ImmutableUtils.TransformFunc<PrivilegeData, Privilege>(){

            public Privilege apply(PrivilegeData data) {
                PrivilegeImpl p = new PrivilegeImpl();
                p.setId(data.getName());
                p.setDescription(data.getDesciption());
                p.setGroup(data.getGroupId());
                p.setIsOnParent(Boolean.valueOf(data.isOnParent()));
                p.setVersion(data.getVersion());
                return p;
            }
        });
    }

    public Map<URI, Collection<AccessControl>> getAllPermissions() {
        return ImmutableUtils.transformMap(this._caches.getPermissionsCache().get(), (ImmutableUtils.TransformEntryFunc)TransformerHelper.PERMISSION_TO_ACL_TRANFORMER);
    }

    private com.vmware.vim.binding.impl.dataservice.accesscontrol.PrincipalImpl createPrincipal(AuthInfo info) {
        return new com.vmware.vim.binding.impl.dataservice.accesscontrol.PrincipalImpl(info.getOwner().getName(), info.getOwner().isGroup());
    }

    public Set<String> getUserPrivileges(String docId, String userName, Set<String> groups) {
        com.vmware.cis.core.Principal principal = this.getPrincipal(userName, groups);
        try {
            return this._authManager.getUserPrivileges(principal, docId);
        }
        catch (AuthorizationException e) {
            _log.error((Object)"Error occured calculating effective user privileges", (Throwable)e);
            throw new SecurityError();
        }
    }

    public PermissionsDetail getPermissionsDelta(Set<String> providers, Set<String> products, String version) {
        return this.getPermissionsDeltaInternal(providers, products, version, false);
    }

    public PermissionsDetail getCacheSyncPermissionsDelta(Set<String> providers, Set<String> products, String version) {
        return this.getPermissionsDeltaInternal(providers, products, version, true);
    }

    private PermissionsDetail getPermissionsDeltaInternal(final Set<String> providers, final Set<String> products, String version, final boolean callByClientCache) {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("Calling getPermissionsDeltaInternal: providers = " + providers + " products = " + products + " callByClientCache = " + callByClientCache));
        }
        final Map authInfos = this._memCache.getAuthInfos(null).getMap();
        StoreCache.Delta<Map<String, Collection<Permission>>> delta = this._caches.getPermissionsCache().getDelta(version);
        Map filteredMap = ImmutableUtils.filteredMap(delta.get(), (Predicate)new Predicate<Map.Entry<String, Collection<Permission>>>(){

            public boolean apply(Map.Entry<String, Collection<Permission>> entry) {
                String objId = entry.getKey();
                if (objId == null) {
                    return false;
                }
                AuthInfo authInfo = (AuthInfo)authInfos.get(objId);
                if (authInfo == null) {
                    if (_log.isTraceEnabled()) {
                        _log.trace((Object)("getPermissionsDeltaInternal:  AuthInfo is null for " + objId));
                    }
                    if (callByClientCache || providers.isEmpty()) {
                        return true;
                    }
                    int index = objId.lastIndexOf(AclPrivilegeValidator.COLON);
                    if (index == -1) {
                        return false;
                    }
                    String providerId = objId.substring(index + AclPrivilegeValidator.COLON.length()).trim();
                    if (_log.isTraceEnabled()) {
                        _log.trace((Object)("getPermissionsDeltaInternal: providerUUID = " + providerId + " for " + objId));
                    }
                    return providers.contains(providerId);
                }
                return AclPrivilegeValidator.this.filterBasedOnProviderAndProducts((Set<String>)providers, (Set<String>)products, authInfo);
            }
        });
        Map transformMap = ImmutableUtils.transformMap((Map)filteredMap, (ImmutableUtils.TransformEntryFunc)TransformerHelper.PERMISSION_TO_ACL_TRANFORMER);
        if (_log.isTraceEnabled()) {
            _log.trace((Object)"getPermissionsDeltaInternal results:");
            for (URI uri : transformMap.keySet()) {
                StringBuilder str = new StringBuilder();
                str.append(" key = " + uri.toString()).append(" value = ");
                Collection acls = (Collection)transformMap.get(uri);
                if (acls == null) {
                    str.append("null");
                } else {
                    for (AccessControl acl : acls) {
                        str.append("( ").append(acl.getPrincipal()).append(",").append(acl.getRoles()).append(",").append(acl.getVersion()).append(",").append(acl.isPropagate()).append(" )");
                    }
                }
                _log.debug((Object)str.toString());
            }
        }
        Collection aclMappings = ImmutableUtils.tranformCollection(transformMap.entrySet(), (ImmutableUtils.TransformFunc)new ImmutableUtils.TransformFunc<Map.Entry<URI, Collection<AccessControl>>, AclMapping>(){

            public AclMapping apply(Map.Entry<URI, Collection<AccessControl>> entry) {
                return new AclMappingImpl(entry.getKey(), entry.getValue() == null ? null : entry.getValue().toArray(new AccessControl[0]));
            }
        });
        if (_log.isTraceEnabled()) {
            _log.trace((Object)("getPermissionsDeltaInternal results: DeltaVersion = " + delta.getVersion() + " isDelta = " + delta.isDelta()));
        }
        return new PermissionsDetailImpl(delta.getVersion(), delta.isDelta(), aclMappings.toArray(new AclMapping[0]));
    }

    public void setHierarchyPlugin(DocHierarchyPlugin plugin) {
        this._authManager.setHierarchyPlugin(plugin);
    }

    private boolean filterBasedOnProviderAndProducts(Set<String> providers, Set<String> products, AuthInfo authInfo) {
        if (authInfo._providerUuid == null || authInfo._product == null) {
            return true;
        }
        if (!providers.isEmpty() && !providers.contains(authInfo._providerUuid)) {
            return false;
        }
        return products.isEmpty() || products.contains(authInfo._product);
    }

    private boolean filterBasedOnProviderAndProducts(Set<String> providers, Set<String> products, UserPrivilegeData data) {
        return true;
    }
}

