/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.authorization.impl;

import java.net.URI;
import java.util.BitSet;
import java.util.List;

public final class Role {
    public static final int MAX_PRIVILEGES = 1024;
    public static final long ROLE_NO_ACCESS = -5L;
    public static final long ROLE_VIEW = -3L;
    public static final long ROLE_READ_ONLY = -2L;
    public static final long ROLE_ADMIN = -1L;
    private final long _roleId;
    private final BitSet _privSet;
    private final String _roleName;
    private final long _version;
    private final List<String> _privilegeIds;
    private final String _description;
    private final URI _tenant;

    public Role(String roleName, long roleId, String description, BitSet privSet, List<String> privilegeIds, URI tenant, long version) {
        this._roleId = roleId;
        this._privSet = privSet;
        this._roleName = roleName;
        this._privilegeIds = privilegeIds;
        this._version = version;
        this._description = description;
        this._tenant = tenant;
    }

    public long getId() {
        return this._roleId;
    }

    public BitSet getPrivSet() {
        return (BitSet)this._privSet.clone();
    }

    public BitSet getPrivSetForUpdate() {
        return this._privSet;
    }

    public String getName() {
        return this._roleName;
    }

    public long getVersion() {
        return this._version;
    }

    public String getDesciption() {
        return this._description;
    }

    public List<String> getPrivilegeIds() {
        return this._privilegeIds;
    }

    public URI getTenant() {
        return this._tenant;
    }
}

