/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.authorization.impl;

import com.vmware.cis.core.Permission;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class UserDataEntry {
    private Set<String> _entryAccess;
    private Set<String> _propAccess;
    private boolean _propagate;

    public UserDataEntry(Permission p, Set<String> privSet, boolean propagate) {
        this._entryAccess = new HashSet<String>(privSet);
        this._propagate = propagate;
        this._propAccess = p.getPropagate() ? new HashSet<String>(this._entryAccess) : new HashSet<String>();
    }

    public void setPropagate(boolean prop) {
        this._propagate = prop;
    }

    public boolean isPropagating() {
        return this._propagate;
    }

    public UserDataEntry(Set<String> entryAccess, Set<String> propAccess, boolean propagate) {
        this._entryAccess = new HashSet<String>(entryAccess);
        this._propAccess = new HashSet<String>(propAccess);
        this._propagate = propagate;
    }

    public Set<String> getEntryAccess() {
        return Collections.unmodifiableSet(this._entryAccess);
    }

    public Set<String> getPropAccess() {
        return Collections.unmodifiableSet(this._propAccess);
    }

    public void setEntryAccess(Set<String> privSet) {
        this._entryAccess = new HashSet<String>(privSet);
    }

    public void or(Permission p, Set<String> privSet) {
        this._entryAccess.addAll(privSet);
        if (p.getPropagate()) {
            this._propAccess.addAll(privSet);
        }
    }

    public String toString() {
        return "UserDataEntry [_entryAccess=" + this._entryAccess + ", _propAccess=" + this._propAccess + ", _propagate=" + this._propagate + "]";
    }
}

