/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.localkeyvalue.client.impl;

import com.vmware.cis.localkeyvalue.client.AuthenticationStrategy;
import com.vmware.cis.localkeyvalue.client.KVClient;
import com.vmware.cis.localkeyvalue.client.KVClientFactory;
import com.vmware.cis.localkeyvalue.client.exception.KvAuthException;
import com.vmware.vim.binding.cis.kvlocal.Manager;
import com.vmware.vim.binding.cis.kvlocal.authentication.SessionManager;
import com.vmware.vim.binding.cis.kvlocal.fault.NotAuthenticatedFault;
import com.vmware.vim.binding.cis.kvlocal.version.internal.version1;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.clientutil.VmomiClientUtil;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.RequestRetryCallback;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KVClientImpl
implements KVClient {
    private static final Log _log;
    private URI _serverUri;
    private String _vmomiContext = "/vmomi/sdk/";
    private Manager _localKvManager;
    private static final String LOCAL_KV_MGR_TYPE = "LocalKVManager";
    private static final String LOCAL_KV_MGR_VALUE = "local-kv-mgr";
    private static final String LOCAL_KV_SESSION_MGR_TYPE = "LocalKVSessionManager";
    private static final String LOCAL_KV_SESSION_MGR_VALUE = "localKvSessionManager";
    private final int KEEP_ALIVE_TIME_MS = 90000;
    private final int DEFAULT_KEEP_ALIVE_TIME_MS = 45000;
    private SessionManager _localKvSessionManager;
    private static final KVClientFactory.Configuration DEFAULT_CONFIGURATION;
    private Client _vmomiDsClient;
    private AuthenticationStrategy _authStrategy;

    public KVClientImpl(URI uri, KVClientFactory.Configuration config) {
        this._serverUri = uri;
        if (config == null) {
            config = DEFAULT_CONFIGURATION;
        }
        this._authStrategy = config.getAuthenticationStrategy();
        HttpClientConfiguration httpClientConfig = config.getClientConfig();
        if (httpClientConfig == null) {
            httpClientConfig = HttpClientConfiguration.Factory.newInstance();
        }
        Class<?> version = config.getVersion();
        this.createVmomiClient(httpClientConfig, httpClientConfig.getHttpConfiguration(), version);
    }

    private void createVmomiClient(HttpClientConfiguration httpClientConfig, HttpConfiguration httpConfig, Class<?> version) {
        URI vmomiUri;
        try {
            String uri = this._serverUri.toString();
            while (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            vmomiUri = new URI(uri + this._vmomiContext);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        if (httpConfig == null) {
            httpConfig = HttpConfiguration.Factory.newInstance();
        }
        if (httpConfig.getThumbprintVerifier() == null) {
            httpConfig.setThumbprintVerifier(ThumbprintVerifier.Factory.createAllowAllThumbprintVerifier());
        }
        if (httpConfig.getKeepAlivePeriod() == 45000L) {
            httpConfig.setKeepAlivePeriod(90000L);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Setting the client keep alive period to :" + httpConfig.getKeepAlivePeriod()));
            }
        }
        httpClientConfig.setHttpConfiguration(httpConfig);
        final KVClientImpl thisClient = this;
        if (this._authStrategy != null) {
            httpClientConfig.setRequestRetryCallback(new RequestRetryCallback(){
                private final ReentrantLock _loginLock = new ReentrantLock();
                private final AtomicBoolean _validSession = new AtomicBoolean(false);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean retry(Exception exception, InvocationContext context, int retrycount) {
                    if (!(exception instanceof NotAuthenticatedFault)) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Cannot handle server exception: " + exception));
                        }
                        return false;
                    }
                    if (retrycount > KVClientImpl.this._authStrategy.getMaxLoginAttempts()) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Unable to login to server after retries:" + retrycount));
                        }
                        return false;
                    }
                    this._validSession.set(false);
                    try {
                        this._loginLock.lock();
                        if (this._validSession.get()) {
                            if (_log.isDebugEnabled()) {
                                _log.debug((Object)"Another thread called login on client by the time lock was obtained, retry with new session");
                            }
                            boolean bl = true;
                            return bl;
                        }
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)"Calling caller-defined login method");
                        }
                        KVClientImpl.this._authStrategy.login(thisClient);
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)"Done calling caller-defined login method");
                        }
                        this._validSession.set(true);
                    }
                    finally {
                        this._loginLock.unlock();
                    }
                    return true;
                }
            });
        }
        if (version == null) {
            version = version1.class;
        }
        this._vmomiDsClient = Client.Factory.createClient((URI)vmomiUri, version, (ClientConfiguration)httpClientConfig);
    }

    @Override
    public Manager getKeyValueManager() {
        if (this._localKvManager == null) {
            ManagedObjectReference reference = new ManagedObjectReference(LOCAL_KV_MGR_TYPE, LOCAL_KV_MGR_VALUE);
            this._localKvManager = VmomiClientUtil.createStub(this._vmomiDsClient, Manager.class, reference, "KV");
        }
        return this._localKvManager;
    }

    @Override
    public void loginBySamlToken(SamlToken samlToken, PrivateKey privateKey) throws KvAuthException {
        if (this._localKvSessionManager == null) {
            ManagedObjectReference reference = new ManagedObjectReference(LOCAL_KV_SESSION_MGR_TYPE, LOCAL_KV_SESSION_MGR_VALUE);
            this._localKvSessionManager = VmomiClientUtil.createStub(this._vmomiDsClient, SessionManager.class, reference, "KV");
        }
        BlockingFuture f = new BlockingFuture();
        RequestContextImpl requestContext = new RequestContextImpl();
        requestContext.setSignInfo((SignInfo)new SignInfoImpl(privateKey, samlToken));
        ((Stub)this._localKvSessionManager)._setRequestContext((RequestContext)requestContext);
        this._localKvSessionManager.loginBySamlToken((Future)f);
        try {
            f.get();
        }
        catch (Exception e) {
            throw new KvAuthException(e);
        }
    }

    @Override
    public void login(String username, String password) throws KvAuthException {
        if (this._localKvSessionManager == null) {
            ManagedObjectReference reference = new ManagedObjectReference(LOCAL_KV_SESSION_MGR_TYPE, LOCAL_KV_SESSION_MGR_VALUE);
            this._localKvSessionManager = VmomiClientUtil.createStub(this._vmomiDsClient, SessionManager.class, reference, "KV");
        }
        BlockingFuture f = new BlockingFuture();
        this._localKvSessionManager.login(username, password, (Future)f);
        try {
            f.get();
        }
        catch (Exception e) {
            throw new KvAuthException(e);
        }
    }

    @Override
    public boolean logout() {
        if (this._localKvSessionManager == null) {
            ManagedObjectReference reference = new ManagedObjectReference(LOCAL_KV_SESSION_MGR_TYPE, LOCAL_KV_SESSION_MGR_VALUE);
            this._localKvSessionManager = VmomiClientUtil.createStub(this._vmomiDsClient, SessionManager.class, reference, "KV");
        }
        BlockingFuture f = new BlockingFuture();
        this._localKvSessionManager.logout((Future)f);
        try {
            return (Boolean)f.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (!this.logout()) {
            _log.debug((Object)"not logging out");
        }
        this._vmomiDsClient.shutdown();
    }

    static {
        block2: {
            _log = LogFactory.getLog(KVClientImpl.class);
            DEFAULT_CONFIGURATION = new DefaultConfiguration();
            try {
                VmodlContext.initContext((String[])new String[]{"com.vmware.vim.binding.cis.kvlocal"});
            }
            catch (IllegalArgumentException e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("InitContext threw IllegalArgumentException:" + e.getMessage()));
                _log.warn((Object)"This will happen if the context com.vmware.vim.binding.cis.kvlocalis already initialized");
            }
        }
    }

    private static class DefaultConfiguration
    implements KVClientFactory.Configuration {
        private DefaultConfiguration() {
        }

        @Override
        public HttpClientConfiguration getClientConfig() {
            return null;
        }

        @Override
        public Class<?> getVersion() {
            return null;
        }

        @Override
        public AuthenticationStrategy getAuthenticationStrategy() {
            return null;
        }
    }
}

