/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.localkeyvalue.client.impl;

import com.vmware.cis.localkeyvalue.client.KVClientManager;
import com.vmware.cis.localkeyvalue.client.exception.KVException;
import com.vmware.vim.binding.cis.kvlocal.DeleteSpec;
import com.vmware.vim.binding.cis.kvlocal.Entry;
import com.vmware.vim.binding.cis.kvlocal.EntryResult;
import com.vmware.vim.binding.cis.kvlocal.Manager;
import com.vmware.vim.binding.cis.kvlocal.MultiDeleteSpec;
import com.vmware.vim.binding.cis.kvlocal.MultiPutSpec;
import com.vmware.vim.binding.cis.kvlocal.PrivilegeFlags;
import com.vmware.vim.binding.cis.kvlocal.PutSpec;
import com.vmware.vim.binding.cis.kvlocal.SearchClause;
import com.vmware.vim.binding.cis.kvlocal.fault.AlreadyExistsFault;
import com.vmware.vim.binding.cis.kvlocal.fault.NotFoundFault;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.vmomi.client.exception.VmomiProtocolException;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import java.util.concurrent.ExecutionException;

public class KVClientManagerImpl
implements KVClientManager {
    private Manager _serverManager;

    public KVClientManagerImpl(Manager serverManager) {
        this._serverManager = serverManager;
    }

    @Override
    public PrivilegeFlags getPrivileges(String provider) throws InvalidArgument, KVException, NotFoundFault, SecurityException {
        BlockingFuture f = new BlockingFuture();
        this._serverManager.getPrivileges(provider, (Future)f);
        try {
            return (PrivilegeFlags)f.get();
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            throw new KVException(e.getCause());
        }
        return null;
    }

    @Override
    public void addProvider(String providerName, PrivilegeFlags flags) throws AlreadyExistsFault, InvalidArgument, KVException, SecurityException {
        BlockingFuture f = new BlockingFuture();
        this._serverManager.addProvider(providerName, flags, (Future)f);
        try {
            f.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof AlreadyExistsFault) {
                throw (AlreadyExistsFault)e.getCause();
            }
            try {
                this.handleServerException(e);
            }
            catch (NotFoundFault nf) {
                throw new IllegalStateException(nf);
            }
        }
        catch (InterruptedException e) {
            throw new KVException(e.getCause());
        }
    }

    @Override
    public void deleteProvider(String providerName) throws InvalidArgument, KVException, NotFoundFault, SecurityException {
        BlockingFuture f = new BlockingFuture();
        this._serverManager.deleteProvider(providerName, (Future)f);
        try {
            f.get();
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            throw new KVException(e.getCause());
        }
    }

    @Override
    public Entry get(String provider, String key) throws InvalidArgument, KVException, NotFoundFault, SecurityException {
        BlockingFuture f = new BlockingFuture();
        this._serverManager.get(provider, key, (Future)f);
        try {
            return (Entry)f.get();
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            throw new KVException(e.getCause());
        }
        return null;
    }

    @Override
    public Entry[] batchGet(String provider, String[] keys) throws InvalidArgument, KVException, NotFoundFault, SecurityException {
        BlockingFuture f = new BlockingFuture();
        this._serverManager.batchGet(provider, keys, (Future)f);
        try {
            return (Entry[])f.get();
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            throw new KVException(e.getCause());
        }
        return null;
    }

    @Override
    public EntryResult put(String provider, PutSpec putSpec) throws InvalidArgument, KVException, NotFoundFault, SecurityException {
        BlockingFuture f = new BlockingFuture();
        this._serverManager.put(provider, putSpec, (Future)f);
        try {
            return (EntryResult)f.get();
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            throw new KVException(e.getCause());
        }
        return null;
    }

    @Override
    public EntryResult[] batchPut(MultiPutSpec updates) throws InvalidArgument, KVException, NotFoundFault, SecurityException {
        BlockingFuture f = new BlockingFuture();
        this._serverManager.batchPut(updates, (Future)f);
        try {
            return (EntryResult[])f.get();
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            throw new KVException(e.getCause());
        }
        return null;
    }

    @Override
    public EntryResult delete(String provider, DeleteSpec deleteSpec) throws InvalidArgument, KVException, NotFoundFault, SecurityException {
        BlockingFuture f = new BlockingFuture();
        this._serverManager.delete(provider, deleteSpec, (Future)f);
        try {
            return (EntryResult)f.get();
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            throw new KVException(e.getCause());
        }
        return null;
    }

    @Override
    public EntryResult[] batchDelete(MultiDeleteSpec deletes) throws InvalidArgument, KVException, NotFoundFault, SecurityException {
        BlockingFuture f = new BlockingFuture();
        this._serverManager.batchDelete(deletes, (Future)f);
        try {
            return (EntryResult[])f.get();
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            throw new KVException(e.getCause());
        }
        return null;
    }

    @Override
    public boolean hasChanged(String provider, String key, long generation) throws InvalidArgument, KVException, NotFoundFault, SecurityException {
        BlockingFuture f = new BlockingFuture();
        this._serverManager.hasChanged(provider, key, generation, (Future)f);
        try {
            return (Boolean)f.get();
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            throw new KVException(e.getCause());
        }
        return false;
    }

    @Override
    public String[] findKeys(String provider, SearchClause searchClause) throws InvalidArgument, KVException, NotFoundFault, SecurityException {
        BlockingFuture f = new BlockingFuture();
        this._serverManager.findKeys(provider, searchClause, (Future)f);
        try {
            return (String[])f.get();
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            throw new KVException(e.getCause());
        }
        return null;
    }

    @Override
    public Entry[] findKeyValues(String provider, SearchClause searchClause) throws InvalidArgument, KVException, NotFoundFault, SecurityException {
        BlockingFuture f = new BlockingFuture();
        this._serverManager.findKeyValues(provider, searchClause, (Future)f);
        try {
            return (Entry[])f.get();
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            throw new KVException(e.getCause());
        }
        return null;
    }

    private void handleServerException(ExecutionException e) throws InvalidArgument, KVException, NotFoundFault, SecurityException {
        Throwable cause = e.getCause();
        if (cause instanceof InvalidArgument) {
            throw (InvalidArgument)cause;
        }
        if (cause instanceof NotFoundFault) {
            throw (NotFoundFault)cause;
        }
        if (cause instanceof SecurityError) {
            throw new SecurityException(cause);
        }
        if (cause instanceof VmomiProtocolException) {
            throw new IllegalArgumentException(cause);
        }
        throw new KVException(cause);
    }
}

