/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.notif.provider.is;

import com.vmware.cis.notif.client.Filter;
import com.vmware.cis.notif.client.NotificationException;
import com.vmware.cis.notif.client.ObjectSelector;
import com.vmware.cis.notif.client.PropertySelector;
import com.vmware.cis.notif.client.ValueSelector;
import com.vmware.cis.notif.client.impl.SubscriptionImpl;
import com.vmware.cis.notif.provider.NotificationProvider;
import com.vmware.cis.notif.provider.is.IsNotificationProviderFactoryImpl;
import com.vmware.cis.notif.provider.is.IsObjectChangeIterator;
import com.vmware.cis.notif.provider.is.VersionImpl;
import com.vmware.vim.query.client.PropertyFilterSpec;
import com.vmware.vim.query.client.QueryFilterSpec;
import com.vmware.vim.query.client.ValueFilterSpec;
import com.vmware.vim.query.client.provider.ProviderClient;
import com.vmware.vim.query.core.provider.content.ContentAtomFeed;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IsNotificationProviderImpl
implements NotificationProvider {
    private static final Log _logger = LogFactory.getLog(IsNotificationProviderImpl.class);
    private ProviderClient _client;
    private IsNotificationProviderFactoryImpl _factory;
    private SubscriptionImpl _subscription;
    private IsPollState _lastPollState;
    private Future<Void> _nextPoll;
    private volatile boolean _isClosed = false;
    private long _pollingInterval;
    public static final QName DUMMY_QNAME = new QName("urn:__DUMMY__", "__DUMMY__");

    public IsNotificationProviderImpl(IsNotificationProviderFactoryImpl factory, SubscriptionImpl subscription) throws NotificationException {
        this._factory = factory;
        this._subscription = subscription;
        this._pollingInterval = this._subscription.getSubscriptionSpec().getPollingInterval();
        if (this._subscription.getSubscriptionSpec().getInitialVersion() != null) {
            try {
                long initialVersion;
                VersionImpl version = null;
                if (this._subscription.getSubscriptionSpec().getInitialVersion() instanceof VersionImpl) {
                    version = (VersionImpl)this._subscription.getSubscriptionSpec().getInitialVersion();
                }
                long l = initialVersion = version == null ? 0L : version.generation;
                if (initialVersion > 0L) {
                    this._lastPollState = new IsPollState(initialVersion);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal Initial Version", e);
            }
        }
    }

    @Override
    public void start() throws NotificationException {
        try {
            URI isUri = this.getInventoryServiceURI();
            this._client = this._factory.getClientFactory().createClient(isUri, this._subscription.getAuthenticationStrategy());
        }
        catch (NotificationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NotificationException(e);
        }
        this.reschedule(true);
    }

    private void reschedule(boolean first) {
        long delay = first ? 0L : this._pollingInterval;
        Callable<Void> poller = new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    IsNotificationProviderImpl.this.poll();
                }
                catch (Exception e) {
                    _logger.error((Object)"Exception from Inventory Service poll", (Throwable)e);
                }
                return null;
            }
        };
        if (!this._isClosed) {
            this._nextPoll = this._factory.getExecutor().schedule(poller, delay, TimeUnit.MILLISECONDS);
        } else {
            this.closeDown();
        }
    }

    public IsPollState getPollState() {
        return this._lastPollState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() throws NotificationException {
        boolean isResync = this._lastPollState == null;
        long lastGen = isResync ? 0L : this._lastPollState.getGeneration();
        _logger.debug((Object)("Polling subscription with lastGen = " + lastGen));
        String providerUuid = this._subscription.getSubscriptionSpec().getProviderId();
        Map<QName, List<QName>> filterMap = this.computeFilterMap();
        List<URI> objIdList = this.computeObjectSelectors();
        List<ValueSelector> valueFilters = this.computeValueFilters();
        ContentAtomFeed resp = null;
        boolean includeContent = this._subscription.getSubscriptionSpec().includeContent();
        try {
            if (objIdList.size() == 0 && filterMap.size() == 0 && valueFilters.size() == 0) {
                resp = this._client.getQueryDispatcher().getProviderContentFeed(providerUuid, lastGen, includeContent);
            } else if (objIdList.size() == 0 && valueFilters.size() == 0) {
                PropertyFilterSpec propertyFilter = new PropertyFilterSpec(filterMap);
                resp = this._client.getQueryDispatcher().getProviderContentFeed(providerUuid, propertyFilter, lastGen, includeContent);
            } else if (valueFilters.size() == 0) {
                QueryFilterSpec filterSpec = new QueryFilterSpec();
                URI[] idArray = new URI[objIdList.size()];
                idArray = objIdList.toArray(idArray);
                filterSpec.setObjectIds(idArray);
                resp = this._client.getQueryDispatcher().getProviderContentFeed(providerUuid, filterSpec, lastGen, includeContent);
            } else {
                ValueFilterSpec valueFilterSpec = new ValueFilterSpec(valueFilters);
                resp = this._client.getQueryDispatcher().getProviderContentFeed(providerUuid, valueFilterSpec, lastGen, includeContent);
            }
        }
        catch (Exception e) {
            throw new NotificationException(e);
        }
        this._lastPollState = new IsPollState(resp.getGeneration());
        try {
            IsObjectChangeIterator oci = new IsObjectChangeIterator(resp, this);
            if (isResync) {
                this._subscription.getChangeListener().onResync(oci);
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Reync from Synchronization point 0 to " + this._lastPollState.toString()));
                }
            } else if (oci.hasNext()) {
                this._subscription.getChangeListener().onChanges(oci);
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Receive Changes from Synchronization point " + Long.toString(lastGen) + " to " + this._lastPollState.toString()));
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            this.cleanupResponse(resp);
        }
        this.reschedule(false);
    }

    private void cleanupResponse(ContentAtomFeed resp) {
        Iterator iter = resp.getFeedEntries();
        while (iter.hasNext()) {
            iter.next();
        }
    }

    private Map<QName, List<QName>> computeFilterMap() {
        HashMap<QName, List<QName>> filterMap = new HashMap<QName, List<QName>>();
        Filter[] filters = this._subscription.getSubscriptionSpec().getFilters();
        for (int i = 0; filters != null && i < filters.length; ++i) {
            PropertySelector[] ps = filters[i].getPropertySelectors();
            for (int j = 0; ps != null && j < ps.length; ++j) {
                QName objType = ps[j].getObjectType();
                QName[] propertyNames = ps[j].getPropertyNames();
                ArrayList<QName> propertyNameList = new ArrayList<QName>();
                if (propertyNames != null && propertyNames.length > 0) {
                    propertyNameList.addAll(Arrays.asList(propertyNames));
                } else {
                    propertyNameList.add(DUMMY_QNAME);
                }
                filterMap.put(objType, propertyNameList);
            }
        }
        return filterMap;
    }

    private List<ValueSelector> computeValueFilters() {
        ArrayList<ValueSelector> valueFilters = new ArrayList<ValueSelector>();
        Filter[] filters = this._subscription.getSubscriptionSpec().getFilters();
        for (int i = 0; filters != null && i < filters.length; ++i) {
            ValueSelector[] valueSelectors = filters[i].getValueSelectors();
            if (valueSelectors == null || valueSelectors.length <= 0) continue;
            valueFilters.addAll(Arrays.asList(valueSelectors));
        }
        return valueFilters;
    }

    private List<URI> computeObjectSelectors() {
        Filter[] filters = this._subscription.getSubscriptionSpec().getFilters();
        ArrayList<URI> idList = new ArrayList<URI>();
        for (int i = 0; filters != null && i < filters.length; ++i) {
            ObjectSelector[] os = filters[i].getObjectSelectors();
            for (int j = 0; os != null && j < os.length; ++j) {
                ObjectSelector objSelector = os[j];
                Collection<URI> objectIds = objSelector.getObjectIds();
                if (objectIds == null) continue;
                idList.addAll(objectIds);
            }
        }
        return idList;
    }

    ProviderClient getClient() {
        return this._client;
    }

    public SubscriptionImpl getSubscription() {
        return this._subscription;
    }

    private URI getInventoryServiceURI() throws NotificationException {
        URI uri = this._subscription.getSubscriptionSpec().getNotificationSourceURI();
        if (uri != null) {
            return uri;
        }
        if (uri == null) {
            // empty if block
        }
        String isUriProp = System.getProperty("notif.provider.is.uri");
        Exception isUriExc = null;
        try {
            uri = new URI(isUriProp);
        }
        catch (Exception e) {
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)("Bad Inventory Service URI " + isUriProp));
            }
            isUriExc = e;
        }
        if (uri == null) {
            throw new NotificationException("Unable to obtain IS URI", isUriExc);
        }
        return uri;
    }

    @Override
    public void cleanup() {
        this._isClosed = true;
    }

    private void closeDown() {
        if (this._nextPoll != null) {
            this._nextPoll.cancel(true);
            this._nextPoll = null;
        }
        if (this._client != null) {
            this._client.close();
            this._client = null;
        }
    }

    public static class IsPollState {
        long generation;

        public IsPollState(long generation) {
            this.generation = generation;
        }

        public long getGeneration() {
            return this.generation;
        }

        public String toString() {
            return Long.toString(this.generation);
        }
    }
}

