/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.clientutil;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.MDC;

public class VmomiClientUtil {
    private static final Log _logger = LogFactory.getLog(VmomiClientUtil.class);
    public static final String IS_SERVICE_NAME = "IS";
    public static final String KV_SERVICE_NAME = "KV";
    public static final String AUTHZ_SERVICE_NAME = "Authz";
    public static final String TAGGING_SERVICE_NAME = "Tagging";

    public static <T extends ManagedObject> T createStub(Client client, Class<T> clazz, ManagedObjectReference moRef, String serviceName) {
        ManagedObject managedObject;
        RequestContext ctx;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Creating stub for " + clazz.toString()));
        }
        if ((ctx = ((Stub)(managedObject = client.createStub(clazz, moRef)))._getRequestContext()) == null) {
            ctx = new RequestContextImpl();
        }
        String opId = VmomiClientUtil.getOpId(ctx, serviceName);
        ctx.put((Object)"operationID", (Object)opId);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Added opId: " + opId + " to request context"));
        }
        ((Stub)managedObject)._setRequestContext(ctx);
        return (T)managedObject;
    }

    private static String getOpId(RequestContext ctx, String serviceName) {
        String opId = (String)ctx.get((Object)"operationID");
        if (opId != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("OpId already present in Req cxt:" + opId));
            }
        } else {
            opId = MDC.get((String)"operationID");
            if (opId == null || opId.isEmpty()) {
                opId = UUID.randomUUID().toString() + " " + serviceName;
            } else if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"OpId present in Invoker thread, re-using it.");
            }
        }
        return opId;
    }
}

