/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.client.impl;

import com.vmware.vim.query.client.exception.ClientException;
import com.vmware.vim.query.client.impl.ClientImpl;
import com.vmware.vim.query.client.impl.ValidationHelper;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public abstract class HttpUtil {
    private static final Log _log = LogFactory.getLog(HttpUtil.class);

    public static HttpEntity executeWithResponse(ClientImpl client, HttpUriRequest requst) throws ClientException {
        HttpResponse resp = null;
        try {
            resp = client.getClient().execute(requst);
            ValidationHelper.validateResponseCode(resp);
            HttpEntity entity = resp.getEntity();
            if (entity == null) {
                throw new ClientException("request entity was null; unable to fetch response from server.");
            }
            return entity;
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
        catch (ClientException e) {
            HttpUtil.consumeContent(resp);
            throw e;
        }
    }

    public static void executeWithNoResponse(ClientImpl client, HttpUriRequest requst) throws ClientException {
        HttpResponse resp = null;
        try {
            resp = client.getClient().execute(requst);
            ValidationHelper.validateResponseCode(resp);
        }
        catch (IOException e) {
            try {
                throw new ClientException(e);
            }
            catch (Throwable throwable) {
                HttpUtil.consumeContent(resp);
                throw throwable;
            }
        }
        HttpUtil.consumeContent(resp);
    }

    public static HttpResponse executeWithResponseAndHeaders(ClientImpl client, HttpUriRequest request) throws ClientException {
        HttpResponse resp = null;
        try {
            resp = client.getClient().execute(request);
            ValidationHelper.validateResponseCode(resp);
            return resp;
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
        catch (ClientException e) {
            HttpUtil.consumeContent(resp);
            throw e;
        }
    }

    private static void consumeContent(HttpResponse resp) {
        block3: {
            if (resp != null && resp.getEntity() != null) {
                try {
                    EntityUtils.consume((HttpEntity)resp.getEntity());
                }
                catch (IOException e) {
                    if (!_log.isErrorEnabled()) break block3;
                    _log.error((Object)"Error cleaning up: ", (Throwable)e);
                }
            }
        }
    }
}

