/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.client.impl;

import com.vmware.vim.binding.dataservice.authentication.SessionManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.clientutil.VmomiClientUtil;
import com.vmware.vim.query.client.AuthenticationData;
import com.vmware.vim.query.client.QueryAuthenticationManager;
import com.vmware.vim.query.client.exception.ClientException;
import com.vmware.vim.query.client.impl.ClientImpl;
import com.vmware.vim.query.client.impl.ValidationHelper;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.common.ProtocolBinding;
import com.vmware.vim.vmomi.client.common.Session;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import com.vmware.vim.vmomi.core.util.SHA1HashGenerator;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.util.EntityUtils;

public class QueryAuthenticationManagerImpl
implements QueryAuthenticationManager {
    private static final Log _log = LogFactory.getLog(QueryAuthenticationManagerImpl.class);
    private static final String TICKET_FORMAT = "?action=loginByTicket&ticket=%1$s";
    private static final String LOGOUT_FORMAT = "?action=logout";
    private ClientImpl _client;
    private String _loginContext = "/login/";
    private QueryAuthenticationManager.AuthenticationToken _token;
    private AuthenticationDataImpl _authData;

    QueryAuthenticationManagerImpl(ClientImpl client) {
        this._client = client;
    }

    void setAuthenticationData(AuthenticationData data) {
        String sessionCookieName = "vmware_soap_session";
        if (data != null) {
            this._authData = (AuthenticationDataImpl)data;
            CookieStore cookieStore = this._authData.getCookieStore();
            if (cookieStore != null) {
                for (Cookie cookie : cookieStore.getCookies()) {
                    if (!sessionCookieName.equals(cookie.getName())) continue;
                    ProtocolBinding binding = this._client.getVmomiClient().getBinding();
                    Session session = binding.createSession(cookie.getValue());
                    binding.setSession(session);
                    break;
                }
            }
        } else {
            ProtocolBinding binding = this._client.getVmomiClient().getBinding();
            BasicCookieStore cookieStore = new BasicCookieStore();
            Session session = binding.getSession();
            if (session != null) {
                BasicClientCookie cookie = new BasicClientCookie(sessionCookieName, binding.getSession().getId());
                cookie.setDomain(binding.getEndpointUri().getHost());
                cookie.setPath("/");
                cookieStore.addCookie((Cookie)cookie);
            }
            this._authData = new AuthenticationDataImpl();
            this._authData.setCookieStore((CookieStore)cookieStore);
        }
    }

    @Override
    public void setToken(QueryAuthenticationManager.AuthenticationToken token) {
        this._token = token;
    }

    @Override
    public void loginByToken() throws ClientException {
        switch (this._token.getType()) {
            case TICKET: {
                this.loginByTicket(this._token.getData());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loginByTicket(String ticket) throws ClientException {
        try {
            this.clearCookieStore();
            String formattedTicket = String.format(TICKET_FORMAT, ticket);
            String loginUrl = this._client.getBaseUri() + this._loginContext;
            String url = loginUrl + formattedTicket;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Login request: " + url));
            }
            HttpGet method = new HttpGet(url);
            HttpResponse resp = null;
            try {
                resp = this._client.getClient().execute((HttpUriRequest)method);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Got response code: " + resp.getStatusLine().getStatusCode() + " with reason phrase: " + resp.getStatusLine().getReasonPhrase()));
                }
                ValidationHelper.validateResponseCode(resp);
                this._authData.setCookieStore(this.getCookieStoreIfValid());
                this.printCookieStore();
            }
            finally {
                if (resp != null && resp.getEntity() != null) {
                    EntityUtils.consumeQuietly((HttpEntity)resp.getEntity());
                }
            }
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public void loginBySamlToken(SamlToken samlToken, PrivateKey privateKey) throws ClientException {
        ManagedObjectReference reference = new ManagedObjectReference("InventoryServiceSessionManager", "sessionManager");
        SessionManager authManager = VmomiClientUtil.createStub(this._client.getVmomiClient(), SessionManager.class, reference, "Authz");
        BlockingFuture f = new BlockingFuture();
        RequestContextImpl requestContext = new RequestContextImpl();
        requestContext.setSignInfo((SignInfo)new SignInfoImpl(privateKey, samlToken));
        ((Stub)authManager)._setRequestContext((RequestContext)requestContext);
        authManager.loginBySamlToken((Future)f);
        try {
            f.get();
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout() throws ClientException {
        try {
            String logoutContext = String.format(LOGOUT_FORMAT, new Object[0]);
            String loginUrl = this._client.getBaseUri() + this._loginContext;
            String url = loginUrl + logoutContext;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Logout request: " + url));
            }
            HttpGet method = new HttpGet(url);
            HttpResponse resp = null;
            try {
                resp = this._client.getClient().execute((HttpUriRequest)method);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Got response code: " + resp.getStatusLine().getStatusCode() + " with reason phrase: " + resp.getStatusLine().getReasonPhrase()));
                }
                ValidationHelper.validateResponseCode(resp);
                this.clearCookieStore();
            }
            finally {
                if (resp != null && resp.getEntity() != null) {
                    EntityUtils.consumeQuietly((HttpEntity)resp.getEntity());
                }
            }
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    private void clearCookieStore() {
        if (this._authData != null) {
            this._authData.getCookieStore().clear();
        }
    }

    private CookieStore getCookieStoreIfValid() {
        if (!(this._client.getClient() instanceof HttpClient)) {
            throw new IllegalStateException("Expected instance of type HttpClient");
        }
        String sessionCookieName = "vmware_soap_session";
        ProtocolBinding binding = this._client.getVmomiClient().getBinding();
        BasicCookieStore cookieStore = null;
        Session session = binding.getSession();
        if (session != null) {
            cookieStore = new BasicCookieStore();
            BasicClientCookie cookie = new BasicClientCookie(sessionCookieName, binding.getSession().getId());
            cookie.setDomain(binding.getEndpointUri().getHost());
            cookie.setPath("/");
            cookieStore.addCookie((Cookie)cookie);
        }
        return cookieStore;
    }

    void printCookieStore() {
        if (_log.isDebugEnabled() && this._authData != null) {
            CookieStore store = this._authData.getCookieStore();
            for (Cookie cookie : store.getCookies()) {
                _log.debug((Object)("Cookie name:" + cookie.getName() + " value:" + SHA1HashGenerator.generateTruncated((String)cookie.getValue())));
            }
        }
    }

    @Override
    public AuthenticationData getAuthenticationData() {
        return this._authData;
    }

    @Override
    public void login(String username, String password) throws ClientException {
        ManagedObjectReference reference = new ManagedObjectReference("InventoryServiceSessionManager", "sessionManager");
        SessionManager authManager = VmomiClientUtil.createStub(this._client.getVmomiClient(), SessionManager.class, reference, "Authz");
        BlockingFuture f = new BlockingFuture();
        authManager.login(username, password, (Future)f);
        try {
            f.get();
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    private class AuthenticationDataImpl
    implements AuthenticationData {
        private CookieStore _cookieStore = null;

        private AuthenticationDataImpl() {
        }

        @Override
        public URI getServerURI() {
            try {
                return new URI(QueryAuthenticationManagerImpl.this._client.getBaseUri());
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public boolean isInitialized() {
            return this._cookieStore != null;
        }

        void setCookieStore(CookieStore store) {
            this._cookieStore = store;
        }

        CookieStore getCookieStore() {
            return this._cookieStore;
        }
    }
}

