/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.client.impl;

import com.vmware.vim.query.client.exception.ClientException;
import com.vmware.vim.query.client.exception.RequestTimeoutException;
import com.vmware.vim.query.client.exception.ServiceUnavailableException;
import com.vmware.vim.query.client.exception.UnauthenticatedException;
import com.vmware.vim.query.client.exception.ValidationException;
import org.apache.http.HttpResponse;

public abstract class ValidationHelper {
    public static void validateResponseCode(HttpResponse response) throws ClientException {
        int httpcode = response.getStatusLine().getStatusCode();
        switch (httpcode) {
            case 200: {
                return;
            }
            case 400: {
                throw new ValidationException(ValidationHelper.formatStatus(response.getStatusLine().getReasonPhrase(), httpcode), httpcode);
            }
            case 401: {
                throw new UnauthenticatedException(ValidationHelper.formatStatus(response.getStatusLine().getReasonPhrase(), httpcode), httpcode);
            }
            case 408: {
                throw new RequestTimeoutException(ValidationHelper.formatStatus(response.getStatusLine().getReasonPhrase(), httpcode), httpcode);
            }
            case 503: {
                throw new ServiceUnavailableException(ValidationHelper.formatStatus(response.getStatusLine().getReasonPhrase(), httpcode), httpcode);
            }
        }
        throw new ClientException(ValidationHelper.formatStatus(response.getStatusLine().getReasonPhrase(), httpcode), httpcode);
    }

    private static String formatStatus(String reason, int httpcode) {
        return "Got status code: " + httpcode + " reason: " + reason;
    }

    public static void assertType(Object val, Class<?> clazz) throws ClientException {
        if (!clazz.isAssignableFrom(val.getClass())) {
            throw new ValidationException("Type mismatch for " + val + " : expected : " + clazz + "; got : " + val.getClass());
        }
    }
}

