/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.client.kv.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.vmware.cis.kv.client.ChangeHandler;
import com.vmware.cis.kv.client.ClientCache;
import com.vmware.cis.kv.client.ClientConflictResolution;
import com.vmware.cis.kv.client.ClientDeleteSpec;
import com.vmware.cis.kv.client.ClientEntry;
import com.vmware.cis.kv.client.ClientPutSpec;
import com.vmware.cis.kv.client.ClientValue;
import com.vmware.cis.kv.client.ValueMarshaller;
import com.vmware.cis.kv.client.exception.AlreadyExistsException;
import com.vmware.cis.kv.client.exception.InvalidPatternException;
import com.vmware.cis.kv.client.exception.KVException;
import com.vmware.cis.kv.client.exception.NotFoundException;
import com.vmware.cis.kv.client.exception.OptimisticLockingException;
import com.vmware.vim.binding.cis.kv.Change;
import com.vmware.vim.binding.cis.kv.ChangeSet;
import com.vmware.vim.binding.cis.kv.Conflict;
import com.vmware.vim.binding.cis.kv.ConflictResolution;
import com.vmware.vim.binding.cis.kv.ConflictSet;
import com.vmware.vim.binding.cis.kv.DeleteSpec;
import com.vmware.vim.binding.cis.kv.Entry;
import com.vmware.vim.binding.cis.kv.Manager;
import com.vmware.vim.binding.cis.kv.MultiDeleteSpec;
import com.vmware.vim.binding.cis.kv.MultiPutSpec;
import com.vmware.vim.binding.cis.kv.OptionalValue;
import com.vmware.vim.binding.cis.kv.PutSpec;
import com.vmware.vim.binding.cis.kv.SearchClause;
import com.vmware.vim.binding.cis.kv.fault.AlreadyExistsFault;
import com.vmware.vim.binding.cis.kv.fault.InvalidPatternFault;
import com.vmware.vim.binding.cis.kv.fault.NotFoundFault;
import com.vmware.vim.binding.cis.kv.fault.OptimisticLockingFault;
import com.vmware.vim.binding.cis.kv.fault.SubscriptionClosedFault;
import com.vmware.vim.binding.impl.cis.kv.ConflictResolutionImpl;
import com.vmware.vim.binding.impl.cis.kv.MultiDeleteSpecImpl;
import com.vmware.vim.binding.impl.cis.kv.MultiPutSpecImpl;
import com.vmware.vim.binding.impl.cis.kv.SearchClauseImpl;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.query.client.kv.impl.ClientDeleteSpecImpl;
import com.vmware.vim.query.client.kv.impl.ClientPutSpecImpl;
import com.vmware.vim.query.client.kv.impl.ConversionHelper;
import com.vmware.vim.query.core.util.ImmutableUtils;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientCacheImpl
implements ClientCache {
    private static final ChangeHandler DUMMY_HANDLER = new ChangeHandler(){

        @Override
        public void onPut(String key, ClientValue oldCacheValue, ClientValue newValue) {
        }

        @Override
        public void onError(String subID, Throwable throwable, boolean isSubscriptionInvalid) {
        }

        @Override
        public void onDelete(String key, ClientValue oldCacheValue) {
        }

        @Override
        public void onConflict(String key, ClientValue currentValue, List<ClientValue> conflicts) {
        }
    };
    private static final Log _log = LogFactory.getLog(ClientCacheImpl.class);
    private static final int DEFAULT_SUB_DELAY_MS = 1000;
    private static final int DEFAULT_MAX_CONCURRENT_SUBSCRIPTIONS = 5;
    private Manager _serverManager;
    private final ConcurrentHashMap<String, SubscriptionDetails> _subMap = new ConcurrentHashMap();
    private ConcurrentMap<String, ClientValue> _map;
    private int _subscriptionDelay = 1000;
    private int _maxConcurrentSubscriptions = 5;
    private final ScheduledExecutorService _executor = Executors.newScheduledThreadPool(this._maxConcurrentSubscriptions);
    private final String _provider;
    private ValueMarshaller _vm;

    public ClientCacheImpl(String provider) {
        this._provider = provider;
        this._map = new ConcurrentHashMap<String, ClientValue>();
    }

    public void setSubscriptionDelayMs(int delayMs) {
        this._subscriptionDelay = delayMs;
    }

    public void setServerManager(Manager serverManager) {
        this._serverManager = serverManager;
    }

    public void setValueMarshaller(ValueMarshaller vm) {
        this._vm = vm;
    }

    @Override
    @Deprecated
    public void setAutoUpdateCache(boolean autoUpdate) {
    }

    @Override
    @Deprecated
    public void loadKeys(String[] keys) throws KVException {
        _log.warn((Object)"loadKeys nethod is deprecated. Use subscription to load keys.");
        String subId = UUID.randomUUID().toString();
        this.subscribeByList(subId, DUMMY_HANDLER, keys);
    }

    @Override
    @Deprecated
    public void loadKeysByPrefix(String keyPrefix) throws KVException {
        _log.warn((Object)"loadKeysByPrefix nethod is deprecated. Use subscription to load keys.");
        String subId = UUID.randomUUID().toString();
        this.subscribeByPrefix(subId, DUMMY_HANDLER, keyPrefix);
    }

    @Override
    public Map<String, ClientValue> getCache() {
        return Collections.unmodifiableMap(this._map);
    }

    @Override
    @Deprecated
    public ClientValue get(String key, boolean checkServer) throws KVException {
        return this.get(key);
    }

    @Override
    public ClientValue get(String key) throws KVException {
        return this.getServerValue(key);
    }

    private boolean isSubscribedToKey(String key) {
        for (SubscriptionDetails subscriptionDetails : this._subMap.values()) {
            if (!subscriptionDetails._func.isPartOfSubscription(key)) continue;
            return true;
        }
        return false;
    }

    private Collection<Map.Entry<String, SubscriptionDetails>> getSubscribedToKey(final String key) {
        return Collections2.filter(this._subMap.entrySet(), (Predicate)new Predicate<Map.Entry<String, SubscriptionDetails>>(){

            public boolean apply(Map.Entry<String, SubscriptionDetails> entry) {
                return entry.getValue()._func.isPartOfSubscription(key);
            }
        });
    }

    @Override
    public List<String> queryServerKeys(SearchClause sc) throws KVException {
        BlockingFuture future = new BlockingFuture();
        this._serverManager.findKeys(this._provider, sc, (Future)future);
        try {
            String[] keys = (String[])future.get();
            if (keys == null || keys.length == 0) {
                return new ArrayList<String>();
            }
            return Arrays.asList(keys);
        }
        catch (ExecutionException e) {
            return (List)this.handleServerException(e);
        }
        catch (InterruptedException e) {
            throw new KVException(e);
        }
    }

    @Override
    @Deprecated
    public List<String> queryClientKeys(String keyPrefix) throws KVException {
        SearchClauseImpl sc = new SearchClauseImpl();
        sc.setKeyPrefix(keyPrefix);
        return this.queryServerKeys((SearchClause)sc);
    }

    @Override
    public List<ClientEntry> queryServer(SearchClause sc) throws KVException {
        return this.runQueryOnServer(sc);
    }

    @Override
    @Deprecated
    public List<ClientEntry> queryClient(String keyPrefix) throws KVException {
        return this.runQueryOnClient(keyPrefix);
    }

    @Override
    public ClientValue put(ClientPutSpec update) throws KVException {
        Preconditions.checkArgument((update != null ? 1 : 0) != 0, (Object)"create or update key is required");
        Preconditions.checkArgument((update.getKey() != null ? 1 : 0) != 0, (Object)"create or update key is required");
        Preconditions.checkArgument((update.getValue() != null ? 1 : 0) != 0, (Object)"create or update value is required");
        BlockingFuture bf = new BlockingFuture();
        PutSpec ps = ConversionHelper.getPutSpec(this._vm, update);
        this._serverManager.put(this._provider, ps, (Future)bf);
        ClientValue newValue = null;
        try {
            Change c = (Change)bf.get();
            newValue = ConversionHelper.getClientValue(this._vm, c.getValue());
            if (this.isSubscribedToKey(update.getKey())) {
                this.modifyCache(c);
            }
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)e);
            }
            throw new KVException(e);
        }
        return newValue;
    }

    @Override
    @Deprecated
    public void put(String key, Object value, String opID, long expectedGeneration, String expectedLastWriter) throws KVException {
        ClientPutSpecImpl cps = new ClientPutSpecImpl();
        cps.setKey(key);
        cps.setValue(value);
        cps.setOpID(opID);
        cps.setExpectedGeneration(expectedGeneration);
        cps.setExpectedLastWriter(expectedLastWriter);
        this.put(cps);
    }

    @Override
    public ClientValue put(String key, Object value) throws KVException {
        ClientPutSpecImpl cps = new ClientPutSpecImpl();
        cps.setKey(key);
        cps.setValue(value);
        return this.put(cps);
    }

    private void validatePutSpec(ClientPutSpec[] update) {
        Preconditions.checkArgument((update != null && update.length > 0 ? 1 : 0) != 0, (Object)"PutSpec array is required");
        for (ClientPutSpec upd : update) {
            Preconditions.checkArgument((upd != null ? 1 : 0) != 0, (Object)"PutSpec is required");
            Preconditions.checkArgument((upd.getKey() != null ? 1 : 0) != 0, (Object)"Key is required");
            Preconditions.checkArgument((upd.getValue() != null ? 1 : 0) != 0, (Object)"Value is required");
        }
    }

    @Override
    public List<ClientValue> batchPut(ClientPutSpec[] update) throws KVException {
        this.validatePutSpec(update);
        BlockingFuture bf = new BlockingFuture();
        MultiPutSpecImpl mps = new MultiPutSpecImpl();
        mps.setBatchPutSpec(new MultiPutSpec.BatchPutSpec[]{ConversionHelper.createBatchPutSpec(update, this._vm, this._provider)});
        this._serverManager.batchPut((MultiPutSpec)mps, (Future)bf);
        try {
            ChangeSet c = (ChangeSet)bf.get();
            LinkedList<ClientValue> ret = new LinkedList<ClientValue>();
            Change[] changes = c.getChanges();
            if (changes != null) {
                for (Change ca : changes) {
                    ret.add(ConversionHelper.getClientValue(this._vm, ca.getValue()));
                }
            }
            this.modifyCache(c);
            return ret;
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            throw new KVException(e);
        }
        return null;
    }

    @Override
    public ClientValue delete(ClientDeleteSpec deleteSpec) throws KVException {
        Preconditions.checkArgument((deleteSpec != null ? 1 : 0) != 0, (Object)"deleteSpec is required");
        Preconditions.checkArgument((deleteSpec.getKey() != null ? 1 : 0) != 0, (Object)"key is required");
        BlockingFuture bf = new BlockingFuture();
        DeleteSpec ps = ConversionHelper.getDeleteSpec(deleteSpec);
        this._serverManager.delete(this._provider, ps, (Future)bf);
        ClientValue newValue = null;
        try {
            Change c = (Change)bf.get();
            if (c != null) {
                newValue = ConversionHelper.getClientValue(this._vm, c.getValue());
                if (this.isSubscribedToKey(deleteSpec.getKey())) {
                    this.modifyCache(c);
                }
            }
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)e);
            }
            throw new KVException(e);
        }
        return newValue;
    }

    @Override
    @Deprecated
    public void delete(String key, String opID, long expectedGeneration, String expectedLastWriter) throws KVException {
        ClientDeleteSpecImpl cds = new ClientDeleteSpecImpl();
        cds.setKey(key);
        cds.setOpID(opID);
        cds.setExpectedGeneration(expectedGeneration);
        cds.setExpectedLastWriter(expectedLastWriter);
        this.delete(cds);
    }

    @Override
    public ClientValue delete(String key) throws KVException {
        ClientDeleteSpecImpl cds = new ClientDeleteSpecImpl();
        cds.setKey(key);
        return this.delete(cds);
    }

    private void validateDeleteSpec(ClientDeleteSpec[] deleteSpec) {
        Preconditions.checkArgument((deleteSpec != null && deleteSpec.length > 0 ? 1 : 0) != 0, (Object)"DeleteSpec is required");
        for (ClientDeleteSpec ds : deleteSpec) {
            Preconditions.checkArgument((ds != null ? 1 : 0) != 0, (Object)"ClientDeleteSpec is required");
            Preconditions.checkArgument((ds.getKey() != null ? 1 : 0) != 0, (Object)"Key is required");
        }
    }

    @Override
    public List<ClientValue> batchDelete(ClientDeleteSpec[] deleteSpec) throws KVException {
        this.validateDeleteSpec(deleteSpec);
        BlockingFuture bf = new BlockingFuture();
        MultiDeleteSpecImpl mds = new MultiDeleteSpecImpl();
        mds.setBatchDeleteSpec(new MultiDeleteSpec.BatchDeleteSpec[]{ConversionHelper.createBatchDeleteSpec(deleteSpec, this._provider)});
        this._serverManager.batchDelete((MultiDeleteSpec)mds, (Future)bf);
        try {
            ChangeSet c = (ChangeSet)bf.get();
            LinkedList<ClientValue> ret = new LinkedList<ClientValue>();
            Change[] changes = c.getChanges();
            if (changes != null) {
                for (Change ca : changes) {
                    ret.add(ConversionHelper.getClientValue(this._vm, ca.getValue()));
                }
            }
            this.modifyCache(c);
            return ret;
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)e);
            }
            throw new KVException(e);
        }
        return null;
    }

    private void validateSubscribeListKeys(String[] keys) {
        Preconditions.checkArgument((keys != null && keys.length > 0 ? 1 : 0) != 0, (Object)"Keys are required");
        for (String k : keys) {
            Preconditions.checkArgument((k != null ? 1 : 0) != 0, (Object)"Key  can not be null");
        }
    }

    @Override
    public void subscribeByList(final String subscriptionID, ChangeHandler handler, final String[] keys) throws KVException {
        Preconditions.checkArgument((subscriptionID != null && !subscriptionID.trim().isEmpty() ? 1 : 0) != 0, (Object)"subscriptionID is required and be unique");
        Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (Object)"handler is required");
        this.validateSubscribeListKeys(keys);
        this.internalCreateSubscription(subscriptionID, handler, new RegsiterSubscriptionFunc(){

            @Override
            public void register(BlockingFuture<ChangeSet> bf) {
                ClientCacheImpl.this._serverManager.registerSubscriptionByList(subscriptionID, ClientCacheImpl.this._provider, keys, bf);
            }

            @Override
            public IsSubscriptionKeyFunction getKeyListSubscription() {
                return new KeyListSubscription(new HashSet<String>(Arrays.asList(keys)));
            }
        });
    }

    @Override
    public void subscribeByPrefix(final String subscriptionID, ChangeHandler handler, final String keyPrefix) throws KVException {
        Preconditions.checkArgument((subscriptionID != null && !subscriptionID.trim().isEmpty() ? 1 : 0) != 0, (Object)"subscriptionID is required and be unique");
        Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (Object)"handler is required");
        Preconditions.checkArgument((keyPrefix != null ? 1 : 0) != 0, (Object)"keyPrefix is required");
        this.internalCreateSubscription(subscriptionID, handler, new RegsiterSubscriptionFunc(){

            @Override
            public void register(BlockingFuture<ChangeSet> bf) {
                ClientCacheImpl.this._serverManager.registerSubscriptionByPrefix(subscriptionID, ClientCacheImpl.this._provider, keyPrefix, bf);
            }

            @Override
            public IsSubscriptionKeyFunction getKeyListSubscription() {
                return new PrefixSubscription(keyPrefix);
            }
        });
    }

    @Override
    public void cancelSubscription(String subscriptionID) throws KVException {
        Preconditions.checkArgument((subscriptionID != null && !subscriptionID.trim().isEmpty() ? 1 : 0) != 0, (Object)"subscriptionID is required");
        this._subMap.remove(subscriptionID);
        BlockingFuture f = new BlockingFuture();
        this._serverManager.deleteSubscription(subscriptionID, (Future)f);
        try {
            f.get();
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            throw new KVException(e);
        }
    }

    @Override
    public void resolveConflict(ClientConflictResolution ccr) throws KVException {
        ConflictResolutionImpl cr = ConversionHelper.getConflictResolution(ccr, this._vm);
        this.resolveConflictInt(ccr.getKey(), cr);
    }

    @Override
    public void resolveConflict(String key, Object value) throws KVException {
        ConflictResolutionImpl cr = new ConflictResolutionImpl();
        cr.setKey(key);
        cr.setCorrectedValue(ConversionHelper.getServerValue(this._vm, value));
        this.resolveConflictInt(key, cr);
    }

    private void resolveConflictInt(String key, ConflictResolutionImpl cr) throws KVException {
        BlockingFuture bfchange = new BlockingFuture();
        this._serverManager.resolveConflict(this._provider, (ConflictResolution)cr, (Future)bfchange);
        try {
            Change change = (Change)bfchange.get();
            if (this.isSubscribedToKey(key)) {
                this.modifyCache(change);
            }
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)"Interrupted:", (Throwable)e);
            }
            throw new KVException(e);
        }
    }

    private ClientValue getServerValue(String key) throws KVException {
        BlockingFuture future = new BlockingFuture();
        this._serverManager.get(this._provider, new String[]{key}, (Future)future);
        try {
            OptionalValue[] v = (OptionalValue[])future.get();
            if (v.length != 1) {
                throw new NotFoundException(key);
            }
            ClientValue result = ConversionHelper.getClientValue(this._vm, v[0].getValue());
            if (this.isSubscribedToKey(key)) {
                this.modifyCacheInternal(Collections.singletonList(key));
            }
            return result;
        }
        catch (ExecutionException e) {
            return (ClientValue)this.handleServerException(e);
        }
        catch (InterruptedException e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)e);
            }
            throw new KVException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalCreateSubscription(String subscriptionID, ChangeHandler handler, RegsiterSubscriptionFunc func) throws KVException {
        Preconditions.checkArgument((subscriptionID != null && !subscriptionID.trim().isEmpty() ? 1 : 0) != 0, (Object)"subscriptionID is required");
        SubscriptionDetails subscriptionDetails = new SubscriptionDetails(func.getKeyListSubscription(), handler);
        if (this._subMap.putIfAbsent(subscriptionID, subscriptionDetails) != null) {
            throw new AlreadyExistsException(subscriptionID);
        }
        SubscriptionDetails subscriptionDetails2 = subscriptionDetails;
        synchronized (subscriptionDetails2) {
            BlockingFuture bf = new BlockingFuture();
            func.register((BlockingFuture<ChangeSet>)bf);
            this.handleServerChanges(subscriptionID, (BlockingFuture<ChangeSet>)bf, subscriptionDetails);
            SubscriptionWorkItem swi = new SubscriptionWorkItem(subscriptionID);
            while (swi.callInternal(false) > 0) {
            }
            swi.schedule();
        }
    }

    void modifyCache(Change ... changes) {
        if (changes == null) {
            return;
        }
        this.modifyCache(Arrays.asList(changes));
    }

    void modifyCache(List<Change> changes) {
        this.modifyCacheInternal(ImmutableUtils.tranformCollection(changes, (ImmutableUtils.TransformFunc)new ImmutableUtils.TransformFunc<Change, String>(){

            public String apply(Change from) {
                return from.getKey();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modifyCacheInternal(Collection<String> keys) {
        HashSet<String> processedSubId = new HashSet<String>();
        for (String key : keys) {
            SubscriptionDetails subscriptionDetails;
            Map.Entry<String, SubscriptionDetails> entry;
            String subId;
            Collection<Map.Entry<String, SubscriptionDetails>> list = this.getSubscribedToKey(key);
            Iterator<Map.Entry<String, SubscriptionDetails>> iterator = list.iterator();
            if (!iterator.hasNext() || processedSubId.contains(subId = (entry = iterator.next()).getKey())) continue;
            SubscriptionDetails subscriptionDetails2 = subscriptionDetails = entry.getValue();
            synchronized (subscriptionDetails2) {
                BlockingFuture future = new BlockingFuture();
                this._serverManager.checkSubscription(subId, (Future)future);
                this.handleServerChanges(subId, (BlockingFuture<ChangeSet>)future, subscriptionDetails);
            }
            processedSubId.add(subId);
        }
    }

    private void modifyCache(ChangeSet changeset) {
        Change[] changes = changeset.getChanges();
        if (changes == null) {
            return;
        }
        this.modifyCache(changes);
    }

    public void close() {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Shutting down client cache: " + this._provider));
        }
        this._executor.shutdown();
        try {
            this._executor.awaitTermination(this._subscriptionDelay, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("ClientCache interrupted during closing procedure", e);
        }
        this._map.clear();
    }

    private int handleServerChanges(String subId, BlockingFuture<ChangeSet> future, SubscriptionDetails subscriptionDetails) {
        ChangeSet changes = this.getSubscriptionCallResult(subId, future, subscriptionDetails);
        if (changes == null || changes.getChanges() == null || changes.getChanges().length == 0) {
            return 0;
        }
        ArrayList<Object[]> notifications = new ArrayList<Object[]>();
        for (Change change : changes.getChanges()) {
            ClientValue oldValue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Got change from server:" + change));
            }
            Object[] notice = new Object[4];
            notice[0] = change.getKey();
            notice[1] = change.getChangeType();
            if (change.getChangeType().equals((Object)Change.ChangeType.PUT)) {
                ClientValue newValue = ConversionHelper.getClientValue(this._vm, change.getValue());
                ClientValue oldValue2 = this._map.put(change.getKey(), newValue);
                notice[2] = newValue;
                notice[3] = oldValue2;
                notifications.add(notice);
                continue;
            }
            if (!change.getChangeType().equals((Object)Change.ChangeType.DELETE) || (oldValue = (ClientValue)this._map.remove(change.getKey())) == null) continue;
            notice[3] = oldValue;
            notifications.add(notice);
        }
        if (!notifications.isEmpty()) {
            for (Object[] notice : notifications) {
                if (notice[1] == Change.ChangeType.PUT) {
                    subscriptionDetails._changeHandler.onPut((String)notice[0], (ClientValue)notice[3], (ClientValue)notice[2]);
                    continue;
                }
                subscriptionDetails._changeHandler.onDelete((String)notice[0], (ClientValue)notice[3]);
            }
        }
        return changes.getChanges().length;
    }

    private List<ClientEntry> runQueryOnClient(String keyPrefix) throws KVException {
        SearchClauseImpl sc = new SearchClauseImpl();
        sc.setKeyPrefix(keyPrefix);
        return this.runQueryOnServer((SearchClause)sc);
    }

    private static Pattern getPattern(String keyPrefix) {
        String correctedPrefix = keyPrefix.replace(".", "\\.");
        correctedPrefix = correctedPrefix + ".*";
        return Pattern.compile(correctedPrefix);
    }

    private List<ClientEntry> runQueryOnServer(SearchClause sc) throws KVException {
        BlockingFuture future = new BlockingFuture();
        this._serverManager.findKeyValues(this._provider, sc, (Future)future);
        try {
            Entry[] entries = (Entry[])future.get();
            List<ClientEntry> result = ConversionHelper.getClientEntries(this._vm, entries);
            this.modifyCacheInternal(ImmutableUtils.tranformCollection(result, (ImmutableUtils.TransformFunc)new ImmutableUtils.TransformFunc<ClientEntry, String>(){

                public String apply(ClientEntry from) {
                    return from.getKey();
                }
            }));
            return result;
        }
        catch (ExecutionException e) {
            return (List)this.handleServerException(e);
        }
        catch (InterruptedException e) {
            throw new KVException(e);
        }
    }

    private <T> T handleServerException(ExecutionException e) throws KVException {
        Throwable cause;
        if (_log.isErrorEnabled()) {
            _log.error((Object)e);
        }
        if ((cause = e.getCause()) instanceof InvalidPatternFault) {
            throw new InvalidPatternException(cause);
        }
        if (cause instanceof AlreadyExistsFault) {
            throw new AlreadyExistsException(cause);
        }
        if (cause instanceof NotFoundFault) {
            throw new NotFoundException("Provider not found:" + this._provider);
        }
        if (cause instanceof OptimisticLockingFault) {
            throw new OptimisticLockingException(cause);
        }
        if (cause instanceof SecurityError) {
            throw new SecurityException(cause);
        }
        throw new KVException(cause);
    }

    private <T> T getSubscriptionCallResult(String subId, BlockingFuture<T> future, SubscriptionDetails subscriptionDetails) {
        try {
            return (T)future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NotFoundFault || cause instanceof SubscriptionClosedFault) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Auto-closing subscription due to exception talking to server:" + cause));
                }
                this._subMap.remove(subId);
                subscriptionDetails._changeHandler.onError(subId, cause, false);
            } else {
                subscriptionDetails._changeHandler.onError(subId, cause, true);
            }
        }
        catch (InterruptedException e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)"Interrupted: ", (Throwable)e);
            }
        }
        catch (Throwable t) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)("Unexpected exception processing subscription. Closing subscription: " + subId), t);
            }
            this._subMap.remove(subId);
            subscriptionDetails._changeHandler.onError(subId, t, false);
        }
        return null;
    }

    private static final class KeyListSubscription
    implements IsSubscriptionKeyFunction {
        private final Set<String> _keySet;

        public KeyListSubscription(Set<String> keySet) {
            this._keySet = keySet;
        }

        @Override
        public boolean isPartOfSubscription(String key) {
            return this._keySet.contains(key);
        }
    }

    private static final class PrefixSubscription
    implements IsSubscriptionKeyFunction {
        private final Pattern _pattern;

        public PrefixSubscription(String prefix) {
            this._pattern = ClientCacheImpl.getPattern(prefix);
        }

        @Override
        public boolean isPartOfSubscription(String key) {
            return this._pattern.matcher(key).matches();
        }
    }

    private static final class SubscriptionDetails {
        private final IsSubscriptionKeyFunction _func;
        private final ChangeHandler _changeHandler;

        SubscriptionDetails(IsSubscriptionKeyFunction func, ChangeHandler changeHandler) {
            if (func == null || changeHandler == null) {
                throw new IllegalArgumentException();
            }
            this._func = func;
            this._changeHandler = changeHandler;
        }
    }

    private static interface IsSubscriptionKeyFunction {
        public boolean isPartOfSubscription(String var1);
    }

    private class SubscriptionWorkItem
    implements Callable<Integer> {
        private final String _subID;
        private final SubscriptionDetails _subscriptionDetails;

        SubscriptionWorkItem(String subID) {
            this._subID = subID;
            this._subscriptionDetails = (SubscriptionDetails)ClientCacheImpl.this._subMap.get(this._subID);
            if (this._subscriptionDetails == null) {
                throw new IllegalStateException("Cannot locate subscription in map");
            }
        }

        @Override
        public Integer call() {
            return this.callInternal(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Integer callInternal(boolean schedule) {
            int result;
            if (!ClientCacheImpl.this._subMap.containsKey(this._subID)) {
                return -1;
            }
            SubscriptionDetails subscriptionDetails = this._subscriptionDetails;
            synchronized (subscriptionDetails) {
                BlockingFuture future = new BlockingFuture();
                ClientCacheImpl.this._serverManager.checkSubscription(this._subID, (Future)future);
                result = ClientCacheImpl.this.handleServerChanges(this._subID, (BlockingFuture<ChangeSet>)future, this._subscriptionDetails);
                this.handleConflictUpdates();
            }
            if (schedule && ClientCacheImpl.this._subMap.containsKey(this._subID)) {
                this.schedule();
            }
            return result;
        }

        private void schedule() {
            ClientCacheImpl.this._executor.schedule(this, (long)ClientCacheImpl.this._subscriptionDelay, TimeUnit.MILLISECONDS);
        }

        private void handleConflictUpdates() {
            BlockingFuture bfcs = new BlockingFuture();
            ClientCacheImpl.this._serverManager.getConflictSet(ClientCacheImpl.this._provider, this._subID, (Future)bfcs);
            ConflictSet cs = (ConflictSet)ClientCacheImpl.this.getSubscriptionCallResult(this._subID, bfcs, this._subscriptionDetails);
            if (cs == null) {
                return;
            }
            Conflict[] conflicts = cs.getConflicts();
            if (conflicts != null) {
                for (Conflict conflict : conflicts) {
                    this._subscriptionDetails._changeHandler.onConflict(conflict.getKey(), ConversionHelper.getClientValue(ClientCacheImpl.this._vm, conflict.getCurrentValue()), ConversionHelper.getClientValues(ClientCacheImpl.this._vm, conflict.getConflictValues()));
                }
            }
        }
    }

    private static interface RegsiterSubscriptionFunc {
        public void register(BlockingFuture<ChangeSet> var1);

        public IsSubscriptionKeyFunction getKeyListSubscription();
    }
}

