/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.client.provider.impl;

import com.vmware.vim.query.client.exception.ClientException;
import com.vmware.vim.query.client.impl.ClientImpl;
import com.vmware.vim.query.client.impl.HttpUtil;
import com.vmware.vim.query.client.impl.RetryAction;
import com.vmware.vim.query.client.provider.AtomFeedPoster;
import com.vmware.vim.query.client.provider.impl.AtomFormatter;
import com.vmware.vim.query.client.provider.impl.FeedFactory;
import com.vmware.vim.query.client.provider.impl.ProviderClientImpl;
import com.vmware.vim.query.core.provider.AtomFeedEntry;
import com.vmware.vim.query.core.provider.push.PushAtomFeed;
import com.vmware.vim.query.core.provider.push.PushAtomFeedEntry;
import com.vmware.vim.query.core.provider.push.PushEntryProperty;
import com.vmware.vim.query.core.provider.push.impl.PushAtomFeedImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public class AtomFeedPosterImpl
implements AtomFeedPoster {
    private static final Log _log = LogFactory.getLog(AtomFeedPosterImpl.class);
    private ProviderClientImpl _client;
    private String _pushContext = "/provider/atom/";

    public AtomFeedPosterImpl(ProviderClientImpl client) {
        this._client = client;
    }

    @Override
    public void postFeed(final PushAtomFeed feedInput) throws ClientException {
        new RetryAction<Void>((ClientImpl)this._client){

            @Override
            public Void doAction() throws ClientException {
                AtomFeedPosterImpl.this.postFeedImpl(feedInput);
                return null;
            }

            @Override
            public void resetState() {
                feedInput.resetFeed();
            }
        }.execute();
    }

    private void postFeedImpl(PushAtomFeed feedInput) throws ClientException {
        if (!(feedInput instanceof PushAtomFeedImpl)) {
            throw new IllegalArgumentException("This implementation expects AtomFeed of type AtomFeedImpl");
        }
        PushAtomFeedImpl feed = (PushAtomFeedImpl)feedInput;
        HttpPost method = new HttpPost(this._client.getSecureBaseUri() + this._pushContext);
        method.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        method.setHeader("X-QueryService-Provider-Uuid", this.urlEncode(feedInput.getProviderId()));
        AtomFeedRequestEntity entity = new AtomFeedRequestEntity(feed, "UTF-8");
        method.setEntity((HttpEntity)entity);
        HttpUtil.executeWithNoResponse(this._client, (HttpUriRequest)method);
    }

    @Override
    public void postNewDocument(String providerId, Document doc) throws ClientException {
        PushAtomFeedEntry entry;
        Calendar createTime = Calendar.getInstance();
        try {
            URI docId = this.getValidQsId(doc);
            entry = FeedFactory.createPushAtomFeedEntry(docId, createTime, AtomFeedEntry.ChangeType.CREATE, null, doc);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        LinkedList<PushAtomFeedEntry> entries = new LinkedList<PushAtomFeedEntry>();
        entries.add(entry);
        PushAtomFeed feed = FeedFactory.createPushAtomFeed(createTime, providerId, entries.iterator());
        this.postFeed(feed);
    }

    @Override
    public void postUpdateDocument(String providerId, Document doc, QName[] propertyUpdates) throws ClientException {
        PushAtomFeedEntry entry;
        Calendar updateTime = Calendar.getInstance();
        LinkedList<PushEntryProperty> entryPropList = new LinkedList<PushEntryProperty>();
        for (int i = 0; i < propertyUpdates.length; ++i) {
            PushEntryProperty entryProp = FeedFactory.createPushEntryProperty(propertyUpdates[i], updateTime);
            entryPropList.add(entryProp);
        }
        Attr qsIdAttr = doc.getDocumentElement().getAttributeNodeNS("urn:vmware:queryservice", "id");
        if (qsIdAttr == null) {
            throw new ClientException("Content needs to have {urn:vmware:queryservice}id attribute");
        }
        try {
            URI docId = this.getValidQsId(doc);
            entry = FeedFactory.createPushAtomFeedEntry(docId, updateTime, AtomFeedEntry.ChangeType.EDIT, entryPropList, doc);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        LinkedList<PushAtomFeedEntry> entries = new LinkedList<PushAtomFeedEntry>();
        entries.add(entry);
        PushAtomFeed feed = FeedFactory.createPushAtomFeed(updateTime, providerId, entries.iterator());
        this.postFeed(feed);
    }

    @Override
    public void postDeleteDocument(String providerId, URI docId) throws ClientException {
        PushAtomFeedEntry entry;
        Calendar deleteTime = Calendar.getInstance();
        try {
            entry = FeedFactory.createPushAtomFeedEntry(docId, deleteTime, AtomFeedEntry.ChangeType.DELETE, null, null);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        LinkedList<PushAtomFeedEntry> entries = new LinkedList<PushAtomFeedEntry>();
        entries.add(entry);
        PushAtomFeed feed = FeedFactory.createPushAtomFeed(deleteTime, providerId, entries.iterator());
        this.postFeed(feed);
    }

    private URI getValidQsId(Document doc) throws ClientException {
        URI qsId;
        Attr qsIdAttr = doc.getDocumentElement().getAttributeNodeNS("urn:vmware:queryservice", "id");
        if (qsIdAttr == null) {
            throw new IllegalArgumentException("Content needs to have {urn:vmware:queryservice}id attribute");
        }
        try {
            qsId = new URI(qsIdAttr.getValue());
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        return qsId;
    }

    public void setPushContext(String pushContext) {
        this._pushContext = pushContext;
    }

    private String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static class AtomFeedRequestEntity
    extends AbstractHttpEntity {
        private PushAtomFeedImpl _feed;
        private String _encoding;

        AtomFeedRequestEntity(PushAtomFeedImpl feed, String encoding) {
            this._feed = feed;
            this._encoding = encoding;
        }

        public void writeTo(OutputStream out) throws IOException {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, this._encoding));
            try {
                AtomFormatter.format(this._feed, writer);
            }
            catch (TransformerException e) {
                throw new IOException(e);
            }
            writer.flush();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Feed write complete.");
            }
            writer.close();
        }

        public boolean isStreaming() {
            return true;
        }

        public boolean isRepeatable() {
            return false;
        }

        public long getContentLength() {
            return -1L;
        }

        public InputStream getContent() {
            throw new UnsupportedOperationException();
        }
    }
}

