/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.client.provider.impl;

import com.vmware.vim.query.core.provider.AtomFeedEntry;
import com.vmware.vim.query.core.provider.push.PushAtomFeedEntry;
import com.vmware.vim.query.core.provider.push.PushEntryProperty;
import com.vmware.vim.query.core.provider.push.impl.PushAtomFeedImpl;
import com.vmware.vim.vmomi.core.soap.impl.CalendarHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

class AtomFormatter {
    private static final String FEED_BEGIN_FORMAT = "<?xml version=\"1.0\" encoding=\"utf-8\"?><feed xmlns=\"http://www.w3.org/2005/Atom\" xmlns:qs=\"urn:vmware:queryservice\"><title>%s feed</title><id>%s</id><updated>%s</updated>";
    private static final String FEED_ENTRY_BEGIN_FORMAT = "<entry><title>%s</title><id>%s</id><updated>%s</updated><qs:changekind>%s</qs:changekind>";
    public static final String FEED_BEGIN_EXP_GEN = "<qs:expectedgeneration>%s</qs:expectedgeneration>";
    private static final String FEED_ENTRY_END = "</entry>";
    private static final String FEED_END = "</feed>";
    private static final String CONTENT_FORMAT = "<content>%s</content>";
    private static final String FEED_ENTRY_PROP_FORMAT = "<qs:property qs:updated=\"%s\">%s</qs:property>";
    private static final String FEED_ENTRY_PROP_FORMAT_WITH_EXPECTED_GENERATION = "<qs:property qs:updated=\"%s\" qs:expectedgeneration=\"%s\">%s</qs:property>";

    AtomFormatter() {
    }

    static void format(PushAtomFeedImpl atomFeed, PrintWriter writer) throws TransformerException {
        writer.format(FEED_BEGIN_FORMAT, atomFeed.getTitle(), atomFeed.getProviderId(), AtomFormatter.formatDate(atomFeed.getModifiedTime()));
        if (atomFeed.getExpectedGeneration() >= 0L) {
            writer.format(FEED_BEGIN_EXP_GEN, atomFeed.getExpectedGeneration());
        }
        Iterator feedEntries = atomFeed.getFeedEntries();
        List backupFeed = atomFeed.getBackupFeed();
        while (feedEntries.hasNext()) {
            List list;
            PushAtomFeedEntry feedEntry = (PushAtomFeedEntry)feedEntries.next();
            backupFeed.add(feedEntry);
            URI objId = feedEntry.getObjectId();
            writer.format(FEED_ENTRY_BEGIN_FORMAT, "change to " + objId, objId.toString(), AtomFormatter.formatDate(feedEntry.getModifiedTime()), AtomFormatter.getOpName(feedEntry.getChangeType()));
            if (feedEntry.getExpectedGeneration() >= 0L) {
                writer.format(FEED_BEGIN_EXP_GEN, feedEntry.getExpectedGeneration());
            }
            if ((list = feedEntry.getEntryPropertyList()) != null) {
                for (PushEntryProperty p : list) {
                    if (p.getExpectedGeneration() >= 0L) {
                        writer.format(FEED_ENTRY_PROP_FORMAT_WITH_EXPECTED_GENERATION, AtomFormatter.formatDate(p.getModifiedTime()), p.getExpectedGeneration(), p.getPropertyName());
                        continue;
                    }
                    writer.format(FEED_ENTRY_PROP_FORMAT, AtomFormatter.formatDate(p.getModifiedTime()), p.getPropertyName());
                }
            }
            writer.format(CONTENT_FORMAT, AtomFormatter.nodeToString(feedEntry.getContent()));
            writer.write(FEED_ENTRY_END);
        }
        writer.write(FEED_END);
    }

    private static String formatDate(Calendar date) {
        return CalendarHelper.formatXsdDateTime((Calendar)date);
    }

    static String nodeToString(Node node) throws TransformerException {
        StringWriter sw = new StringWriter();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        t.transform(new DOMSource(node), new StreamResult(sw));
        return sw.toString();
    }

    private static String getOpName(AtomFeedEntry.ChangeType type) {
        switch (type) {
            case CREATE: {
                return "create";
            }
            case DELETE: {
                return "delete";
            }
            case EDIT: {
                return "edit";
            }
        }
        throw new IllegalArgumentException("ChangeType");
    }
}

