/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cimmonitor.impl;

import com.vmware.vim.binding.vim.host.HealthStatusSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.cimmonitor.http.CimMonitorHttpService;
import com.vmware.vim.cimmonitor.http.HttpCimException;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.http.HttpServiceAddressLookupException;
import com.vmware.vsphere.client.cimmonitor.CimMonitorSpec;
import com.vmware.vsphere.client.cimmonitor.impl.CimMonitorFacade;
import com.vmware.vsphere.client.cimmonitor.impl.Utilities;
import com.vmware.vsphere.client.cimmonitor.util.CimMonitorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CimMonitorMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(CimMonitorMutationProvider.class);
    private CimMonitorFacade _cimMonitorFacade;

    public CimMonitorMutationProvider(CimMonitorFacade facade) {
        this._cimMonitorFacade = facade;
    }

    public OperationResult apply(ManagedObjectReference host, CimMonitorSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = host;
        if (spec == null) {
            result.error = CimMonitorUtil.getLocalizedException("invalidSpec");
            return result;
        }
        String serverGuid = host.getServerGuid();
        CimMonitorHttpService service = null;
        try {
            service = this._cimMonitorFacade.getServiceInstance(serverGuid);
        }
        catch (HttpServiceAddressLookupException exception) {
            _logger.error((Object)"CIM HTTP service address lookup failed!");
            String key = "cimServiceAddressNotFound";
            result.error = CimMonitorUtil.getLocalizedException("cimServiceAddressNotFound");
        }
        if (service == null) {
            this.doHealthStatusAction(host, spec);
            return result;
        }
        String vcSessionId = Utilities.getVcSessionId(serverGuid);
        String hostId = host.getValue();
        try {
            if (spec.operationId == CimMonitorSpec.OperationId.REFRESH_DATA) {
                service.refreshHost(hostId, vcSessionId);
            } else if (spec.operationId == CimMonitorSpec.OperationId.RESET_SENSORS) {
                service.resetHostSensors(hostId, vcSessionId);
            } else if (spec.operationId == CimMonitorSpec.OperationId.RESET_EVENTS_LOG) {
                service.resetEventLog(hostId, vcSessionId);
            } else {
                _logger.warn((Object)("Unsupported action: " + (Object)((Object)spec.operationId)));
            }
        }
        catch (HttpCimException exception) {
            _logger.error((Object)"Mutation operation failed!", (Throwable)exception);
            result.error = CimMonitorUtil.getLocalizedException(exception);
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to retrieve host data!", (Throwable)exception);
            result.error = CimMonitorUtil.getLocalizedException("httpError");
        }
        return result;
    }

    private void doHealthStatusAction(ManagedObjectReference hostRef, CimMonitorSpec spec) {
        try {
            HealthStatusSystem hss = CimMonitorUtil.getHealthStatusSystem(hostRef);
            if (spec.operationId == CimMonitorSpec.OperationId.REFRESH_DATA) {
                hss.refresh();
            } else if (spec.operationId == CimMonitorSpec.OperationId.RESET_SENSORS) {
                hss.resetSystemHealthInfo();
            } else if (spec.operationId == CimMonitorSpec.OperationId.RESET_EVENTS_LOG) {
                hss.clearSystemEventLog();
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to perform the action: " + (Object)((Object)spec.operationId)), (Throwable)exception);
        }
    }
}

