/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging;

import com.vmware.cdc.vcenter.listener.AlarmChangeListener;
import com.vmware.cdc.vcenter.listener.ChangeNotifier;
import com.vmware.cdc.vcenter.listener.ChangeNotifierFactory;
import com.vmware.cdc.vcenter.listener.ListenerSpecBuilder;
import com.vmware.cdc.vcenter.listener.ResourceChangeListener;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.liveupdates.LiveUpdatesUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.messaging.ChangeNotifierManager;
import com.vmware.vise.vim.messaging.ChangeNotifierStateContext;
import com.vmware.vise.vim.messaging.Session;
import com.vmware.vise.vim.messaging.impl.AlarmChangeListenerImpl;
import com.vmware.vise.vim.messaging.impl.ResourceChangeListenerImpl;
import com.vmware.vise.vim.messaging.util.WebUtils;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;

public class ChangeNotifierManagerImpl
implements DisposableBean,
ChangeNotifierManager {
    private static final Log _logger = LogFactory.getLog(ChangeNotifierManagerImpl.class);
    private final ConfigurationService _configurationService;
    private final ChangeNotifierFactory _changeNotifierFactory;
    private final LinkedVcGroupRegistry _linkedVcGroupRegistry;
    private final ObjectFactory<AlarmChangeListenerImpl> _alarmChangeListenerFactory;
    private final ObjectFactory<ResourceChangeListenerImpl> _resourceChangeListenerFactory;
    private HttpServletRequest _fakeHttpRequest;
    private final Map<String, ChangeNotifierStateContext> _changeNotifierByVcId = new ConcurrentHashMap<String, ChangeNotifierStateContext>();
    private volatile boolean _changeNotifierCommitted;

    public ChangeNotifierManagerImpl(ConfigurationService configurationService, ChangeNotifierFactory changeNotifierFactory, LinkedVcGroupRegistry linkedVcGroupRegistry, ObjectFactory<AlarmChangeListenerImpl> objectFactory, ObjectFactory<ResourceChangeListenerImpl> objectFactory2) {
        this._configurationService = configurationService;
        this._changeNotifierFactory = changeNotifierFactory;
        this._linkedVcGroupRegistry = linkedVcGroupRegistry;
        this._alarmChangeListenerFactory = objectFactory;
        this._resourceChangeListenerFactory = objectFactory2;
    }

    public synchronized void startup() throws Exception {
        this._fakeHttpRequest = Session.createFakeHttpRequest(WebUtils.getCurrentClientId());
        this._changeNotifierCommitted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void configure(String string) {
        _logger.debug((Object)"registering change notifiers");
        try {
            LinkedVcGroup[] linkedVcGroupArray;
            SessionUtil.setHttpRequest((HttpServletRequest)this._fakeHttpRequest);
            for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray = this._linkedVcGroupRegistry.getLinkedVcGroups()) {
                if (linkedVcGroup == null) continue;
                for (VcService vcService : linkedVcGroup.getVcServices()) {
                    ResourceChangeListenerImpl resourceChangeListenerImpl;
                    if (vcService == null || !this.shouldRegisterChangeNotifier(vcService)) continue;
                    ChangeNotifierStateContext changeNotifierStateContext = new ChangeNotifierStateContext();
                    changeNotifierStateContext.changeNotifier = this._changeNotifierFactory.forVmomiProvider(vcService.getVmomiClient());
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("registered change notifier for VC [" + vcService.getServiceGuid() + "]"));
                    }
                    changeNotifierStateContext.listenerSpecBuilder = changeNotifierStateContext.changeNotifier.listeners();
                    changeNotifierStateContext.resourceChangeListener = resourceChangeListenerImpl = (ResourceChangeListenerImpl)this._resourceChangeListenerFactory.getObject();
                    changeNotifierStateContext.listenerSpecBuilder.add((ResourceChangeListener)changeNotifierStateContext.resourceChangeListener);
                    if (LiveUpdatesUtil.alarmsEnabled((ConfigurationService)this._configurationService)) {
                        AlarmChangeListenerImpl alarmChangeListenerImpl;
                        changeNotifierStateContext.alarmChangeListener = alarmChangeListenerImpl = (AlarmChangeListenerImpl)this._alarmChangeListenerFactory.getObject();
                        changeNotifierStateContext.listenerSpecBuilder.add((AlarmChangeListener)alarmChangeListenerImpl);
                    }
                    this._changeNotifierByVcId.put(vcService.getServiceGuid(), changeNotifierStateContext);
                }
            }
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void reconfigureAndCommit(ChangeNotifier changeNotifier) {
        changeNotifier.close();
        try {
            SessionUtil.setHttpRequest((HttpServletRequest)this._fakeHttpRequest);
            for (Map.Entry<String, ChangeNotifierStateContext> entry : this._changeNotifierByVcId.entrySet()) {
                LinkedVcGroup[] linkedVcGroupArray;
                ChangeNotifierStateContext changeNotifierStateContext = entry.getValue();
                if (changeNotifierStateContext.changeNotifier != changeNotifier) continue;
                for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray = this._linkedVcGroupRegistry.getLinkedVcGroups()) {
                    if (linkedVcGroup == null) continue;
                    for (VcService vcService : linkedVcGroup.getVcServices()) {
                        ChangeNotifier changeNotifier2;
                        if (vcService == null || !vcService.getServiceGuid().equals(entry.getKey())) continue;
                        changeNotifierStateContext.changeNotifier = changeNotifier2 = this._changeNotifierFactory.forVmomiProvider(vcService.getVmomiClient());
                        ListenerSpecBuilder listenerSpecBuilder = changeNotifier2.listeners();
                        listenerSpecBuilder.add((AlarmChangeListener)changeNotifierStateContext.alarmChangeListener);
                        listenerSpecBuilder.add((ResourceChangeListener)changeNotifierStateContext.resourceChangeListener);
                        listenerSpecBuilder.commit();
                        return;
                    }
                }
            }
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
    }

    @Override
    public synchronized void commitConfiguration() {
        Collection<ChangeNotifierStateContext> collection = this._changeNotifierByVcId.values();
        if (collection == null) {
            return;
        }
        if (!this._changeNotifierCommitted) {
            for (ChangeNotifierStateContext changeNotifierStateContext : collection) {
                if (changeNotifierStateContext.listenerSpecBuilder == null) continue;
                changeNotifierStateContext.listenerSpecBuilder.commit();
            }
            this._changeNotifierCommitted = true;
        }
    }

    @Override
    public void configure(String string, ManagedObjectReference[] managedObjectReferenceArray) {
    }

    @Override
    public void closeNotifiers() {
        this._changeNotifierCommitted = false;
        for (ChangeNotifierStateContext changeNotifierStateContext : this._changeNotifierByVcId.values()) {
            changeNotifierStateContext.changeNotifier.close();
        }
        this._changeNotifierByVcId.clear();
    }

    public void destroy() throws Exception {
        this.closeNotifiers();
        _logger.debug((Object)"unregistered available change notifiers");
        this._fakeHttpRequest = null;
    }

    private boolean shouldRegisterChangeNotifier(VcService vcService) {
        return !this._changeNotifierByVcId.containsKey(vcService.getServiceGuid()) && VcServiceUtil.is65VcOrLaterByVersion((String)vcService.getServiceVersion());
    }
}

