/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging;

import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.messaging.Monitor;
import com.vmware.vise.vim.messaging.OutboundMessageHandler;
import com.vmware.vise.vim.messaging.UpdatesManager;
import com.vmware.vise.vim.messaging.util.WebUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import reactor.fn.Consumer;
import reactor.rx.Stream;
import reactor.rx.action.Control;

public class MonitorImpl
implements Monitor,
DisposableBean {
    private static final Log _logger = LogFactory.getLog(MonitorImpl.class);
    private final Set<String> subscribedDestinations;
    private final String clientId;
    private final OutboundMessageHandler outboundMessageHandler;
    private final List<Stream<PartialUpdate<?>>> updatesStreams;
    private final List<Control> updatesStreamsControls;
    private final UpdatesManager updatesManager;
    private boolean streamsCancelled;

    public MonitorImpl(UpdatesManager updatesManager, OutboundMessageHandler outboundMessageHandler) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{updatesManager, outboundMessageHandler});
        this.updatesManager = updatesManager;
        this.subscribedDestinations = new CopyOnWriteArraySet<String>();
        this.outboundMessageHandler = outboundMessageHandler;
        this.clientId = WebUtils.getCurrentClientId();
        this.streamsCancelled = false;
        this.updatesStreamsControls = new ArrayList<Control>();
        this.updatesStreams = new ArrayList();
    }

    public synchronized void init() {
        this.updatesManager.init(this.clientId);
        this.initUpdatesStreams();
        this.outboundMessageHandler.onClose(new Runnable(){

            @Override
            public void run() {
                MonitorImpl.this.cancelStreamsAndCloseNotifiers();
                MonitorImpl.this.streamsCancelled = true;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)String.format("[LiveRefresh] [%s] closed his Websocket.", MonitorImpl.this.updatesManager.getUsername()));
                }
            }
        });
    }

    private void initUpdatesStreams() {
        this.updatesStreams.clear();
        this.updatesStreamsControls.clear();
        this.updatesStreams.addAll(this.updatesManager.createUpdatesStreams());
        for (Stream<PartialUpdate<?>> stream : this.updatesStreams) {
            Control control = stream.consume(this.consumeFunction());
            this.updatesStreamsControls.add(control);
        }
        this.updatesManager.registerHandlerForTaskRegistryStream(this.outboundMessageHandler);
    }

    @Override
    public void sendToWebsocket(PartialUpdate<?> partialUpdate) {
        try {
            if (this.subscribedDestinations.contains(partialUpdate.getDestination())) {
                this.outboundMessageHandler.sendToWebsocket(partialUpdate);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("[LiveRefresh] Username: [" + this.updatesManager.getUsername() + "] ws error: "), (Throwable)exception);
        }
    }

    private Consumer<PartialUpdate<?>> consumeFunction() {
        return new Consumer<PartialUpdate<?>>(){

            public void accept(PartialUpdate<?> partialUpdate) {
                MonitorImpl.this.sendToWebsocket(partialUpdate);
            }
        };
    }

    @Override
    public synchronized void monitorEvents(String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        if (this.streamsCancelled) {
            this.streamsCancelled = false;
            this.logRefreshDetected();
            this.init();
        }
        if (this.subscribedDestinations.add(string)) {
            this.updatesManager.subscribe(string);
            this.logSubscription(string);
        }
    }

    private void logRefreshDetected() {
        if (!_logger.isDebugEnabled()) {
            return;
        }
        _logger.debug((Object)String.format("[LiveRefresh] Detected browser refresh for username [%s], clientId [%s], re-init the streams...", this.updatesManager.getUsername(), this.clientId));
    }

    private void logSubscription(String string) {
        if (!_logger.isDebugEnabled()) {
            return;
        }
        _logger.debug((Object)String.format("[LiveRefresh] Subscribe to destination [%s]: for session with clientId: [%s], thread id: [%d]username: [%s]", string, this.clientId, Thread.currentThread().getId(), this.updatesManager.getUsername()));
    }

    @Override
    public void cancelEvents(String string) {
    }

    public void destroy() throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("[LiveRefresh] Destroying monitor for username [%s], clientId [%s]", this.updatesManager.getUsername(), this.clientId));
        }
        this.cancelStreamsAndCloseNotifiers();
    }

    private void cancelStreamsAndCloseNotifiers() {
        this.updatesManager.unregisterHandlerForTaskRegistryStream(this.outboundMessageHandler);
        this.updatesManager.closeChangeNotifiers();
        for (Control control : this.updatesStreamsControls) {
            control.cancel();
        }
        this.updatesStreamsControls.clear();
        this.updatesStreams.clear();
    }
}

