/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.impl;

import com.vmware.cdc.vcenter.AlarmChange;
import com.vmware.cdc.vcenter.listener.AlarmChangeListener;
import com.vmware.cdc.vcenter.listener.ChangeNotifier;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.messaging.AlarmChangeProcessor;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.messaging.ChangeNotifierManager;
import com.vmware.vise.vim.messaging.Monitor;
import com.vmware.vise.vim.messaging.impl.ChangeListener;
import com.vmware.vise.vim.messaging.updates.AlarmUpdate;
import com.vmware.vise.vim.messaging.utils.LoggingHelper;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmChangeListenerImpl
extends ChangeListener
implements AlarmChangeListener {
    private static final Log _logger = LogFactory.getLog(AlarmChangeListenerImpl.class);
    private final List<AlarmChangeProcessor<?>> _alarmChangeProcessors;

    public AlarmChangeListenerImpl(Monitor monitor, ChangeNotifierManager changeNotifierManager, ConfigurationService configurationService, List<AlarmChangeProcessor<?>> list) {
        super(monitor, changeNotifierManager, configurationService);
        this._alarmChangeProcessors = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onChanges(ChangeNotifier changeNotifier, Collection<AlarmChange> collection) {
        AlarmUpdate alarmUpdate = new AlarmUpdate(collection);
        try {
            SessionUtil.setHttpRequest((HttpServletRequest)this._fakeHttpRequest);
            this.processAlarmChanges(alarmUpdate, this._clientId);
            if (_logger.isDebugEnabled()) {
                LoggingHelper.logTotalProcessingForChange(alarmUpdate, this._clientId, System.currentTimeMillis() - alarmUpdate.createdOn, _logger);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("[LiveRefresh] AlarmUpdates error: " + exception.getMessage()), (Throwable)exception);
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
    }

    private void processAlarmChanges(AlarmUpdate alarmUpdate, String string) {
        LoggingHelper.logChanges("AlarmUpdate(" + alarmUpdate.id + ")", alarmUpdate.changes, string, _logger);
        Collection<AlarmChange> collection = alarmUpdate.changes;
        for (AlarmChangeProcessor<?> alarmChangeProcessor : this._alarmChangeProcessors) {
            try {
                PartialUpdate partialUpdate = alarmChangeProcessor.process(collection, alarmUpdate.id);
                if (partialUpdate == null) continue;
                if (StringUtil.isNullOrEmpty((String)partialUpdate.getDestination())) {
                    partialUpdate.setDestination("/topic/alarms");
                }
                if (_logger.isDebugEnabled()) {
                    partialUpdate.changeId = alarmUpdate.id;
                    partialUpdate.timeWhenUpdateIsPushedToTheStream = System.currentTimeMillis();
                    partialUpdate.timeWhenChangeIsReceived = alarmUpdate.createdOn;
                }
                this._monitor.sendToWebsocket(partialUpdate);
            }
            catch (Exception exception) {
                _logger.error((Object)"[LiveRefresh] Alarms (CDC) err: ", (Throwable)exception);
            }
        }
    }
}

