/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.impl;

import com.vmware.cdc.vcenter.ResourceChange;
import com.vmware.cdc.vcenter.listener.ChangeNotifier;
import com.vmware.cdc.vcenter.listener.ResourceChangeListener;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.liveupdates.LiveUpdatesUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.messaging.CdcProcessor;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.messaging.ChangeNotifierManager;
import com.vmware.vise.vim.messaging.Monitor;
import com.vmware.vise.vim.messaging.impl.ChangeListener;
import com.vmware.vise.vim.messaging.updates.ResourceUpdate;
import com.vmware.vise.vim.messaging.utils.LoggingHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceChangeListenerImpl
extends ChangeListener
implements ResourceChangeListener {
    private static final Log _logger = LogFactory.getLog(ResourceChangeListenerImpl.class);
    private final CdcProcessor<?> _navTreeProcessor;
    private final CdcProcessor<?> _objDetailsProcessor;

    public ResourceChangeListenerImpl(Monitor monitor, ChangeNotifierManager changeNotifierManager, ConfigurationService configurationService, CdcProcessor<?> cdcProcessor, CdcProcessor<?> cdcProcessor2) {
        super(monitor, changeNotifierManager, configurationService);
        this._navTreeProcessor = cdcProcessor;
        this._objDetailsProcessor = cdcProcessor2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChanges(ChangeNotifier changeNotifier, Collection<ResourceChange> collection) {
        ResourceUpdate resourceUpdate = new ResourceUpdate(new ArrayList<ResourceChange>(collection));
        try {
            SessionUtil.setHttpRequest((HttpServletRequest)this._fakeHttpRequest);
            LoggingHelper.logChanges("ResourceUpdate(" + resourceUpdate.id + ")", resourceUpdate.changes, this._clientId, _logger);
            if (LiveUpdatesUtil.navTreeEnabled((ConfigurationService)this._configurationService) || LiveUpdatesUtil.listsEnabled((ConfigurationService)this._configurationService)) {
                this.processTreeUpdates(resourceUpdate);
            }
            this.processObjectDetailsUpdates(resourceUpdate);
            if (_logger.isDebugEnabled()) {
                LoggingHelper.logTotalProcessingForChange(resourceUpdate, this._clientId, System.currentTimeMillis() - resourceUpdate.createdOn, _logger);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("[LiveRefresh] ResourceUpdates error: " + exception.getMessage()), (Throwable)exception);
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
    }

    private void processTreeUpdates(ResourceUpdate resourceUpdate) {
        List<ResourceChange> list = resourceUpdate.changes;
        try {
            PartialUpdate partialUpdate = this._navTreeProcessor.process(list);
            partialUpdate.setDestination("/topic/navTree");
            if (_logger.isDebugEnabled()) {
                partialUpdate.changeId = resourceUpdate.id;
                partialUpdate.timeWhenUpdateIsPushedToTheStream = System.currentTimeMillis();
                partialUpdate.timeWhenChangeIsReceived = resourceUpdate.createdOn;
            }
            this._monitor.sendToWebsocket(partialUpdate);
        }
        catch (Exception exception) {
            _logger.error((Object)"[LiveRefresh] Navigation tree (CDC) err: ", (Throwable)exception);
        }
    }

    private void processObjectDetailsUpdates(ResourceUpdate resourceUpdate) {
        List<ResourceChange> list = resourceUpdate.changes;
        try {
            PartialUpdate partialUpdate = this._objDetailsProcessor.process(list);
            partialUpdate.setDestination("/topic/object-details");
            if (_logger.isDebugEnabled()) {
                partialUpdate.changeId = resourceUpdate.id;
                partialUpdate.timeWhenChangeIsReceived = resourceUpdate.createdOn;
                partialUpdate.timeWhenUpdateIsPushedToTheStream = System.currentTimeMillis();
            }
            this._monitor.sendToWebsocket(partialUpdate);
        }
        catch (Exception exception) {
            _logger.error((Object)"[LiveRefresh] Object details (CDC) err: ", (Throwable)exception);
        }
    }
}

