/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.streams;

import com.google.common.base.Optional;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.InvalidCollectorVersion;
import com.vmware.vim.binding.vmodl.query.InvalidProperty;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.UpdatesProcessor;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.messaging.FilterRegistry;
import com.vmware.vise.vim.messaging.Update;
import com.vmware.vise.vim.messaging.UpdatesProvider;
import com.vmware.vise.vim.messaging.utils.PollingPublisher;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.Environment;
import reactor.fn.Function;
import reactor.rx.Stream;
import reactor.rx.Streams;

public final class PropertyCollectorStream {
    private static final AtomicLong PROPERTY_COLLECTOR_CHANGE_ID_COUNTER = new AtomicLong();
    private static final String PROPERT_COLLECTOR_CHANGE_PREFIX = "PropertyCollectorChange:";
    private static final Log _logger = LogFactory.getLog(PropertyCollectorStream.class);
    private final List<UpdatesProcessor<?>> _updatesProcessors;
    private final Environment _environment;

    public PropertyCollectorStream(List<UpdatesProcessor<?>> list, Environment environment) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{list, environment});
        this._updatesProcessors = list;
        this._environment = environment;
    }

    public Stream<PartialUpdate<?>> createStream(String string, HttpServletRequest httpServletRequest, VcService vcService, FilterRegistry filterRegistry) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, httpServletRequest, vcService, filterRegistry});
        PropertyCollector propertyCollector = (PropertyCollector)vcService.getManagedObject(vcService.getServiceInstanceContent().propertyCollector);
        UpdatesProvider updatesProvider = new UpdatesProvider(propertyCollector);
        PollingPublisher pollingPublisher = new PollingPublisher(1L, TimeUnit.SECONDS);
        return Streams.create((Publisher)pollingPublisher).concatMap(this.checkForUpdates(httpServletRequest, updatesProvider, string, pollingPublisher)).map(this.createUpdates(filterRegistry, string)).split();
    }

    public List<ManagedObjectReference> registerFilter(String string, VcService vcService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, vcService});
        PropertyCollector propertyCollector = (PropertyCollector)vcService.getManagedObject(vcService.getServiceInstanceContent().propertyCollector);
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        for (UpdatesProcessor<?> updatesProcessor : this._updatesProcessors) {
            PropertyCollector.FilterSpec filterSpec = updatesProcessor.createFilterSpec(string, vcService);
            if (filterSpec == null) continue;
            try {
                boolean bl = true;
                ManagedObjectReference managedObjectReference = propertyCollector.createFilter(filterSpec, bl);
                arrayList.add(managedObjectReference);
            }
            catch (InvalidProperty invalidProperty) {
                _logger.error((Object)"[LiveRefresh] Unable to register PC filter: ", (Throwable)invalidProperty);
            }
        }
        return arrayList;
    }

    private Function<Update, List<PartialUpdate<?>>> createUpdates(final FilterRegistry filterRegistry, final String string) {
        return new Function<Update, List<PartialUpdate<?>>>(){

            public List<PartialUpdate<?>> apply(Update update) {
                ArrayList arrayList = new ArrayList();
                for (PropertyCollector.FilterUpdate filterUpdate : update.getUpdateSet().getFilterSet()) {
                    ManagedObjectReference managedObjectReference = filterUpdate.getFilter();
                    String string2 = filterRegistry.getDestination(managedObjectReference);
                    if (string2 == null) {
                        _logger.error((Object)("[LiveRefresh] Destination not found for filter: " + managedObjectReference));
                        continue;
                    }
                    PartialUpdate partialUpdate = PropertyCollectorStream.this.transform(string2, filterUpdate);
                    if (partialUpdate == null) continue;
                    PropertyCollectorStream.this.logTransform(partialUpdate, update.getCreatedOn(), string);
                    arrayList.add(partialUpdate);
                }
                return arrayList;
            }
        };
    }

    private Function<Object, Publisher<? extends Update>> checkForUpdates(final HttpServletRequest httpServletRequest, final UpdatesProvider updatesProvider, final String string, final PollingPublisher pollingPublisher) {
        return new Function<Object, Publisher<? extends Update>>(){

            public Publisher<? extends Update> apply(Object object) {
                return Streams.create((Publisher)new Publisher<Update>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void subscribe(Subscriber<? super Update> subscriber) {
                        boolean bl = true;
                        try {
                            SessionUtil.setHttpRequest((HttpServletRequest)httpServletRequest);
                            PropertyCollectorStream.this.logCheckForUpdates(updatesProvider.getPCguid(), string);
                            Optional<Update> optional = updatesProvider.checkForUpdates();
                            if (optional.isPresent()) {
                                subscriber.onNext(optional.get());
                            }
                            subscriber.onComplete();
                        }
                        catch (NotAuthenticated | NotAuthenticatedError throwable) {
                            _logger.error((Object)("[LiveRefresh] Not authenticated: " + throwable.getMessage()), throwable);
                            subscriber.onError(throwable);
                            bl = false;
                        }
                        catch (InvalidCollectorVersion invalidCollectorVersion) {
                            _logger.error((Object)("[LiveRefresh] Invalid collector version: " + invalidCollectorVersion.getMessage()));
                            updatesProvider.reset();
                            subscriber.onError((Throwable)invalidCollectorVersion);
                        }
                        catch (Exception exception) {
                            _logger.error((Object)("[LiveRefresh] Property collection exception: " + exception.getMessage()));
                            subscriber.onError((Throwable)exception);
                        }
                        finally {
                            if (bl) {
                                pollingPublisher.scheduleTaskIfNotScheduled();
                            }
                            SessionUtil.setHttpRequest(null);
                        }
                    }
                }).subscribeOn(PropertyCollectorStream.this._environment.getDispatcher("threadPoolExecutor"));
            }
        };
    }

    private PartialUpdate<?> transform(String string, PropertyCollector.FilterUpdate filterUpdate) {
        for (UpdatesProcessor<?> updatesProcessor : this._updatesProcessors) {
            PartialUpdate partialUpdate = updatesProcessor.process(string, filterUpdate);
            if (partialUpdate == null) continue;
            partialUpdate.setDestination(string);
            return partialUpdate;
        }
        _logger.warn((Object)String.format("Could not handle update for destination [%s]: %s", string, filterUpdate));
        return null;
    }

    private void logTransform(PartialUpdate<?> partialUpdate, long l, String string) {
        if (!_logger.isDebugEnabled()) {
            return;
        }
        long l2 = System.currentTimeMillis();
        partialUpdate.changeId = PROPERT_COLLECTOR_CHANGE_PREFIX + PROPERTY_COLLECTOR_CHANGE_ID_COUNTER.incrementAndGet();
        partialUpdate.timeWhenChangeIsReceived = l;
        partialUpdate.timeWhenUpdateIsPushedToTheStream = l2;
        long l3 = l2 - l;
        long l4 = Thread.currentThread().getId();
        String string2 = String.format("[LiveRefresh] [%s] Update processed for destination: [%s], processing time: [%d] milliseconds, Thread Id: [%d], ChangeId: [%s], updates: [%d], deletes: [%d]", string, partialUpdate.destination, l3, l4, partialUpdate.changeId, partialUpdate.updates.size(), partialUpdate.deleted.size());
        _logger.debug((Object)string2);
    }

    private void logCheckForUpdates(String string, String string2) {
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)("[LiveRefresh] User [" + string2 + "] CheckForUpdates in thread ID: " + Thread.currentThread().getId() + " serverGuid: " + string));
        }
    }
}

