/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.streams;

import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.processor.CancelException;

public class StreamPublisher
implements Publisher<PartialUpdate<?>> {
    private static final Log _logger = LogFactory.getLog(StreamPublisher.class);
    public Subscriber<? super PartialUpdate<?>> _sub = null;

    public void subscribe(Subscriber<? super PartialUpdate<?>> subscriber) {
        this._sub = subscriber;
    }

    public void publish(PartialUpdate<?> partialUpdate) {
        if (this._sub == null) {
            return;
        }
        try {
            this._sub.onNext(partialUpdate);
        }
        catch (CancelException cancelException) {
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)"[LiveRefresh] StreamPublisher cancel exception: ", (Throwable)cancelException);
            }
            this._sub.onError((Throwable)cancelException);
        }
        catch (Exception exception) {
            _logger.error((Object)"[LiveRefresh] error: ", (Throwable)exception);
            this._sub.onError((Throwable)exception);
        }
    }
}

