/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.streams;

import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.TaskRegistryProcessor;
import com.vmware.vise.vim.messaging.OutboundMessageHandler;
import com.vmware.vise.vim.messaging.utils.PollingPublisher;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.Environment;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.rx.Streams;

public final class TaskRegistryStream {
    private static final int POLL_INTERVAL_SEC = 5;
    private static final Log _logger = LogFactory.getLog(TaskRegistryStream.class);
    private final TaskRegistryProcessor _taskRegistryProcessor;
    private Environment _environment;
    private final PollingPublisher _pollPublisher;
    private final Set<OutboundMessageHandler> _messageHanlders;

    public TaskRegistryStream(TaskRegistryProcessor taskRegistryProcessor, Environment environment) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{taskRegistryProcessor, environment});
        this._taskRegistryProcessor = taskRegistryProcessor;
        this._environment = environment;
        this._pollPublisher = new PollingPublisher(5L, TimeUnit.SECONDS);
        this._messageHanlders = new HashSet<OutboundMessageHandler>();
        this._pollPublisher.stopPolling();
        Streams.create((Publisher)this._pollPublisher).concatMap(this.checkClientTasks()).consume(this.sendToWebsocket());
    }

    public void registerMessageHandler(OutboundMessageHandler outboundMessageHandler) {
        this._messageHanlders.add(outboundMessageHandler);
        this._pollPublisher.startPolling();
    }

    public void unregisterMessageHandler(OutboundMessageHandler outboundMessageHandler) {
        this._messageHanlders.remove(outboundMessageHandler);
        if (this._messageHanlders.isEmpty()) {
            this._pollPublisher.stopPolling();
        }
    }

    private Consumer<PartialUpdate<?>> sendToWebsocket() {
        return new Consumer<PartialUpdate<?>>(){

            public void accept(PartialUpdate<?> partialUpdate) {
                if (TaskRegistryStream.this._messageHanlders.isEmpty()) {
                    return;
                }
                for (OutboundMessageHandler outboundMessageHandler : TaskRegistryStream.this._messageHanlders) {
                    try {
                        outboundMessageHandler.sendToWebsocket(partialUpdate);
                    }
                    catch (Exception exception) {
                        _logger.error((Object)"[LiveRefresh] TaskRegistryStream ws error: ", (Throwable)exception);
                    }
                }
                TaskRegistryStream.this._pollPublisher.scheduleTaskIfNotScheduled();
            }
        };
    }

    private Function<Object, Publisher<? extends PartialUpdate<?>>> checkClientTasks() {
        return new Function<Object, Publisher<? extends PartialUpdate<?>>>(){

            public Publisher<PartialUpdate<?>> apply(Object object) {
                return Streams.create((Publisher)new Publisher<PartialUpdate<?>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void subscribe(Subscriber<? super PartialUpdate<?>> subscriber) {
                        try {
                            if (TaskRegistryStream.this._messageHanlders.isEmpty()) {
                                return;
                            }
                            PartialUpdate partialUpdate = TaskRegistryStream.this._taskRegistryProcessor.process();
                            if (partialUpdate.isEmpty()) {
                                TaskRegistryStream.this._pollPublisher.scheduleTaskIfNotScheduled();
                                return;
                            }
                            partialUpdate.destination = "/topic/recent-tasks";
                            subscriber.onNext((Object)partialUpdate);
                        }
                        catch (Exception exception) {
                            _logger.error((Object)("[LiveRefresh] ClientTasks error: " + exception.getMessage()), (Throwable)exception);
                            subscriber.onError((Throwable)exception);
                        }
                        finally {
                            subscriber.onComplete();
                        }
                    }
                }).subscribeOn(TaskRegistryStream.this._environment.getDispatcher("threadPoolExecutor"));
            }
        };
    }
}

