/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.update.impl;

import com.google.common.base.Optional;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.messaging.update.impl.OperationResultEx;
import java.util.List;

public class CornerCaseOperationHandler {
    private final QueryServiceFactory _queryServiceFactory;
    private final ObjectReferenceService _objRefService;

    public CornerCaseOperationHandler(QueryServiceFactory queryServiceFactory, ObjectReferenceService objectReferenceService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{queryServiceFactory, objectReferenceService});
        this._queryServiceFactory = queryServiceFactory;
        this._objRefService = objectReferenceService;
    }

    public Optional<String> handleOperation(OperationResultEx operationResultEx) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{operationResultEx});
        if (operationResultEx.taskInfo.resultEntityUid == null) {
            return Optional.absent();
        }
        Object object = this._objRefService.getReference(operationResultEx.taskInfo.resultEntityUid);
        if (object == null || !(object instanceof ManagedObjectReference)) {
            return Optional.absent();
        }
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, ComputeResource.class)) {
            return this.handleAddHost(object);
        }
        return Optional.absent();
    }

    private Optional<String> handleAddHost(Object object) {
        ResultSet resultSet = this._queryServiceFactory.getQueryService().select(new String[]{"host"}).from(new String[]{"ComputeResource"}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, object).fetch();
        if (ArrayUtil.isNullOrEmpty((List)resultSet.getItems())) {
            return Optional.absent();
        }
        Object[] objectArray = (ManagedObjectReference[])((ResourceItem)resultSet.getItems().get(0)).get("host");
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)this._objRefService.getUid(objectArray[0]));
    }
}

