/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.update.impl;

import com.vmware.vise.core.model.OperationType;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.messaging.MessagingService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.messaging.update.impl.CornerCaseOperationHandler;
import com.vmware.vise.vim.messaging.update.impl.OperationResultEx;
import com.vmware.vise.vim.messaging.update.impl.UpdatesUtil;
import com.vmware.vise.vim.messaging.update.monitor.ObjectChangeMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectUpdatesManagerForAsyncOperations {
    private static final Log _logger = LogFactory.getLog(ObjectUpdatesManagerForAsyncOperations.class);
    private static final int NUM_OF_SCHEDULER_THREADS = 1;
    private static final int NUM_OF_WORKER_THREADS = 10;
    private static final long INITIAL_DELAY = 10L;
    private static final long DELAY = 200L;
    private static final int QUEUE_CAPACITY = 10;
    private final DataService _dataservice;
    private final ObjectReferenceService _objRefSvc;
    private final MessagingService _messagingService;
    private final CornerCaseOperationHandler _cornerCaseHandler;
    private ObjectChangeMonitor _monitor;
    private final ThreadFactory _schedulerThreadFactory = new WorkerThreadFactory("ObjectUpdatesManagerScheduler");
    private final ScheduledExecutorService _jobScheduler = Executors.newScheduledThreadPool(1, this._schedulerThreadFactory);
    private final ThreadFactory _workerThreadFactory = new WorkerThreadFactory("RecentTasksPoller");
    private final ThreadPoolExecutor _pollingRecentTasksExecutor = ThreadPoolFactory.newDynamicThreadPool((int)10, (int)10, (int)10, (ThreadFactory)this._workerThreadFactory);
    private volatile ConcurrentMap<String, SessionTasks> _tasksBySessionId = new ConcurrentHashMap<String, SessionTasks>();

    public ObjectUpdatesManagerForAsyncOperations(DataService dataService, ObjectReferenceService objectReferenceService, MessagingService messagingService, CornerCaseOperationHandler cornerCaseOperationHandler) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataService, objectReferenceService, messagingService, cornerCaseOperationHandler});
        this._dataservice = dataService;
        this._objRefSvc = objectReferenceService;
        this._messagingService = messagingService;
        this._cornerCaseHandler = cornerCaseOperationHandler;
    }

    public ObjectChangeMonitor getMonitor() {
        return this._monitor;
    }

    public void setMonitor(ObjectChangeMonitor objectChangeMonitor) {
        this._monitor = objectChangeMonitor;
    }

    public void sendUpdates(OperationResultEx[] operationResultExArray) {
        Object object;
        if (operationResultExArray == null) {
            return;
        }
        HttpSession httpSession = SessionUtil.getHttpSession();
        String string = httpSession.getId();
        SessionTasks sessionTasks = null;
        boolean bl = false;
        sessionTasks = (SessionTasks)this._tasksBySessionId.get(string);
        if (sessionTasks == null && (object = this._tasksBySessionId.putIfAbsent(string, sessionTasks = new SessionTasks(httpSession))) != null) {
            sessionTasks = object;
        }
        sessionTasks.addTasks(operationResultExArray);
        boolean bl2 = bl = !sessionTasks.isNextCallScheduled();
        if (bl) {
            object = new SchedulerJob(sessionTasks);
            this._jobScheduler.schedule((Runnable)object, 10L, TimeUnit.MILLISECONDS);
            _logger.info((Object)("New task monitor thread scheduled for session: " + string));
        } else {
            _logger.info((Object)("Piggybacking on another thread since some tasks for this session are already being monitored. Session: " + string));
        }
    }

    void shutdown() {
        this._jobScheduler.shutdown();
        this._pollingRecentTasksExecutor.shutdown();
    }

    private class SessionTasks {
        private final ReentrantLock _lockObj = new ReentrantLock();
        private final HttpSession _session;
        private final ArrayList<OperationResultEx> _opResults;
        private volatile boolean _nextCallScheduled;

        public SessionTasks(HttpSession httpSession) {
            this._session = httpSession;
            this._opResults = new ArrayList();
            this._nextCallScheduled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTasks(OperationResultEx[] operationResultExArray) {
            ArrayList arrayList = ArrayUtil.toArrayList((Object[])operationResultExArray);
            this._lockObj.lock();
            try {
                this._opResults.addAll(arrayList);
            }
            finally {
                this._lockObj.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean sendUpdatesForCompletedTasks(Map<String, ClientTaskInfo> map) {
            Map<String, ClientTaskInfo> map2 = map;
            if (map2 == null || map2.isEmpty()) {
                return false;
            }
            ArrayList<OperationResultEx> arrayList = new ArrayList<OperationResultEx>();
            boolean bl = false;
            this._lockObj.lock();
            try {
                Iterator<OperationResultEx> iterator = this._opResults.iterator();
                while (iterator.hasNext()) {
                    OperationResultEx operationResultEx = iterator.next();
                    String string = operationResultEx.operationResult.taskUid;
                    ClientTaskInfo clientTaskInfo = null;
                    if (map2.containsKey(string)) {
                        boolean bl2 = UpdatesUtil.is60VcOperation(operationResultEx) && operationResultEx.operationType != OperationType.ADD && operationResultEx.taskInfo == null;
                        clientTaskInfo = operationResultEx.taskInfo = map2.get(string);
                        if (bl2) {
                            ObjectUpdatesManagerForAsyncOperations.this._monitor.add(operationResultEx);
                        }
                    }
                    if (clientTaskInfo == null || clientTaskInfo.state != TaskState.SUCCESS && clientTaskInfo.state != TaskState.ERROR && clientTaskInfo.state != TaskState.CANCELED) continue;
                    arrayList.add(operationResultEx);
                    iterator.remove();
                }
                bl = this._opResults.isEmpty();
            }
            finally {
                this._lockObj.unlock();
            }
            for (OperationResultEx operationResultEx : arrayList) {
                if (UpdatesUtil.is60VcOperation(operationResultEx) && operationResultEx.operationType != OperationType.ADD) {
                    ObjectUpdatesManagerForAsyncOperations.this._monitor.addFinalCheck(operationResultEx);
                    continue;
                }
                UpdatesUtil.sendObjectChangeUpdates(operationResultEx, ObjectUpdatesManagerForAsyncOperations.this._objRefSvc, ObjectUpdatesManagerForAsyncOperations.this._messagingService, ObjectUpdatesManagerForAsyncOperations.this._cornerCaseHandler);
            }
            return bl;
        }

        public HttpSession getSession() {
            return this._session;
        }

        public boolean isNextCallScheduled() {
            return this._nextCallScheduled;
        }

        public void setNextCallScheduled(boolean bl) {
            this._nextCallScheduled = bl;
        }
    }

    private class SchedulerJob
    implements Runnable {
        private SessionTasks _sessionTasks;

        SchedulerJob(SessionTasks sessionTasks) {
            this._sessionTasks = sessionTasks;
        }

        @Override
        public void run() {
            try {
                PollingJob pollingJob = new PollingJob(this._sessionTasks);
                ObjectUpdatesManagerForAsyncOperations.this._pollingRecentTasksExecutor.execute(pollingJob);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                SchedulerJob schedulerJob = new SchedulerJob(this._sessionTasks);
                ObjectUpdatesManagerForAsyncOperations.this._jobScheduler.schedule(schedulerJob, 10L, TimeUnit.MILLISECONDS);
                _logger.warn((Object)"RejectedExecutionException got. Scheduling after some time. ", (Throwable)rejectedExecutionException);
            }
            catch (Exception exception) {
                _logger.error((Object)"Could not start the polling recent tasks thread. Exception: ", (Throwable)exception);
            }
        }
    }

    private class PollingJob
    implements Runnable {
        private SessionTasks _sessionTasks;

        PollingJob(SessionTasks sessionTasks) {
            this._sessionTasks = sessionTasks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HttpSession httpSession = this._sessionTasks.getSession();
                SessionUtil.setHttpSession((HttpSession)httpSession);
                RequestSpec requestSpec = UpdatesUtil.getQuerySpecForRecentTasks();
                Response response = ObjectUpdatesManagerForAsyncOperations.this._dataservice.getData(requestSpec);
                Map<String, ClientTaskInfo> map = this.getClientInfos(response);
                boolean bl = false;
                bl = map == null || map.isEmpty() ? true : this._sessionTasks.sendUpdatesForCompletedTasks(map);
                if (bl) {
                    this._sessionTasks.setNextCallScheduled(false);
                    String string = httpSession.getId();
                    ObjectUpdatesManagerForAsyncOperations.this._tasksBySessionId.remove(string);
                    return;
                }
                SchedulerJob schedulerJob = new SchedulerJob(this._sessionTasks);
                ObjectUpdatesManagerForAsyncOperations.this._jobScheduler.schedule(schedulerJob, 200L, TimeUnit.MILLISECONDS);
                this._sessionTasks.setNextCallScheduled(true);
            }
            catch (Exception exception) {
                _logger.error((Object)"Exception: ", (Throwable)exception);
            }
            finally {
                SessionUtil.setHttpSession(null);
            }
        }

        private Map<String, ClientTaskInfo> getClientInfos(Response response) {
            if (response == null || response.resultSet == null || response.resultSet.length == 0) {
                return null;
            }
            HashMap<String, ClientTaskInfo> hashMap = new HashMap<String, ClientTaskInfo>();
            for (ResultItem resultItem : response.resultSet[0].items) {
                if (resultItem.properties.length <= 0 || !"info".equals(resultItem.properties[0].propertyName) || !(resultItem.properties[0].value instanceof ClientTaskInfo)) continue;
                ClientTaskInfo clientTaskInfo = (ClientTaskInfo)resultItem.properties[0].value;
                if (clientTaskInfo.taskUid == null && clientTaskInfo.taskRef != null) {
                    clientTaskInfo.taskUid = ObjectUpdatesManagerForAsyncOperations.this._objRefSvc.getUid(clientTaskInfo.taskRef);
                }
                if (!StringUtil.isNullOrEmpty((String)clientTaskInfo.taskUid)) {
                    hashMap.put(clientTaskInfo.taskUid, clientTaskInfo);
                    continue;
                }
                _logger.error((Object)"Got a client task info without the task uid. Either the tasks adapter should send the taskUid or if sending the taskRef, the task object should register with the ObjectReferenceService.");
            }
            return hashMap;
        }
    }
}

