/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.update.impl;

import com.vmware.vise.core.model.Message;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.OperationType;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.messaging.MessagingService;
import com.vmware.vise.vim.messaging.update.ObjectUpdatesManager;
import com.vmware.vise.vim.messaging.update.impl.ObjectUpdatesManagerForAsyncOperations;
import com.vmware.vise.vim.messaging.update.impl.OperationResultEx;
import com.vmware.vise.vim.messaging.update.impl.UpdatesUtil;
import com.vmware.vise.vim.messaging.update.monitor.ObjectChangeMonitor;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectUpdatesManagerImpl
implements ObjectUpdatesManager {
    private static final Log _logger = LogFactory.getLog(ObjectUpdatesManagerImpl.class);
    private final ObjectUpdatesManagerForAsyncOperations _asyncOperationsUpdatesManager;
    private final ObjectReferenceService _objRefService;
    private final MessagingService _messagingService;
    private ObjectChangeMonitor _monitor;

    public ObjectUpdatesManagerImpl(ObjectReferenceService objectReferenceService, MessagingService messagingService, ObjectUpdatesManagerForAsyncOperations objectUpdatesManagerForAsyncOperations) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectReferenceService, messagingService, objectUpdatesManagerForAsyncOperations});
        this._objRefService = objectReferenceService;
        this._messagingService = messagingService;
        this._asyncOperationsUpdatesManager = objectUpdatesManagerForAsyncOperations;
    }

    @Override
    public void sendUpdates(OperationResult[] operationResultArray, OperationType operationType) {
        OperationResultEx[] operationResultExArray = ObjectUpdatesManagerImpl.convertToOpResultExArray(operationResultArray, operationType);
        this.sendUpdates(operationResultExArray);
    }

    public ObjectChangeMonitor getMonitor() {
        return this._monitor;
    }

    public void setMonitor(ObjectChangeMonitor objectChangeMonitor) {
        this._monitor = objectChangeMonitor;
    }

    private void sendUpdates(OperationResultEx[] operationResultExArray) {
        if (operationResultExArray == null) {
            return;
        }
        Message message = new Message();
        message.type = "operationStarted";
        this._messagingService.sendMessage(message);
        ArrayList<OperationResultEx> arrayList = new ArrayList<OperationResultEx>();
        for (OperationResultEx operationResultEx : operationResultExArray) {
            if (operationResultEx != null && operationResultEx.operationResult != null && operationResultEx.operationResult.task != null) {
                String string = this.getTaskUid(operationResultEx);
                if (StringUtil.isNullOrEmpty((String)string)) continue;
                arrayList.add(operationResultEx);
                continue;
            }
            this.processSyncOperation(operationResultEx);
        }
        if (!arrayList.isEmpty()) {
            this._asyncOperationsUpdatesManager.sendUpdates(arrayList.toArray(new OperationResultEx[arrayList.size()]));
        }
    }

    void shutdown() {
        this._asyncOperationsUpdatesManager.shutdown();
    }

    private void processSyncOperation(OperationResultEx operationResultEx) {
        if (operationResultEx == null) {
            return;
        }
        boolean bl = UpdatesUtil.is60VcOperation(operationResultEx);
        if (bl && operationResultEx.operationType != OperationType.ADD) {
            this._monitor.add(operationResultEx);
            this._monitor.addFinalCheck(operationResultEx);
        } else {
            UpdatesUtil.sendObjectChangeUpdates(operationResultEx, this._objRefService, this._messagingService, null);
        }
    }

    private String getTaskUid(OperationResultEx operationResultEx) {
        if (StringUtil.isNullOrEmpty((String)operationResultEx.operationResult.taskUid)) {
            try {
                operationResultEx.operationResult.taskUid = this._objRefService.getUid(operationResultEx.operationResult.task);
            }
            catch (Exception exception) {
                _logger.error((Object)"Could not get the taskUid for the task", (Throwable)exception);
            }
        }
        return operationResultEx.operationResult.taskUid;
    }

    private static OperationResultEx[] convertToOpResultExArray(OperationResult[] operationResultArray, OperationType operationType) {
        OperationResultEx[] operationResultExArray = new OperationResultEx[operationResultArray.length];
        for (int i = 0; i < operationResultArray.length; ++i) {
            operationResultExArray[i] = new OperationResultEx(operationType, operationResultArray[i]);
        }
        return operationResultExArray;
    }
}

