/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.update.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.Message;
import com.vmware.vise.core.model.ModelChangeMessage;
import com.vmware.vise.core.model.ObjectChangeInfo;
import com.vmware.vise.core.model.OperationType;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.messaging.MessagingService;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.messaging.update.impl.CornerCaseOperationHandler;
import com.vmware.vise.vim.messaging.update.impl.OperationResultEx;

class UpdatesUtil {
    public static final String OPERATION_STARTED = "operationStarted";

    UpdatesUtil() {
    }

    static RequestSpec getQuerySpecForRecentTasks() {
        QuerySpec querySpec = UpdatesUtil.createRecentTasksSpec();
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[1];
        requestSpec.querySpec[0] = querySpec;
        return requestSpec;
    }

    static void sendObjectChangeUpdates(OperationResultEx operationResultEx, ObjectReferenceService objectReferenceService, MessagingService messagingService, CornerCaseOperationHandler cornerCaseOperationHandler) {
        if (operationResultEx.taskInfo != null) {
            UpdatesUtil.processAsyncOperationUpdates(operationResultEx, objectReferenceService, messagingService, cornerCaseOperationHandler);
        } else {
            UpdatesUtil.processSyncOperationUpdates(operationResultEx, objectReferenceService, messagingService);
        }
    }

    private static void processAsyncOperationUpdates(OperationResultEx operationResultEx, ObjectReferenceService objectReferenceService, MessagingService messagingService, CornerCaseOperationHandler cornerCaseOperationHandler) {
        ClientTaskInfo clientTaskInfo = operationResultEx.taskInfo;
        if (clientTaskInfo.state != TaskState.SUCCESS) {
            return;
        }
        ObjectChangeInfo objectChangeInfo = new ObjectChangeInfo();
        objectChangeInfo.operationType = operationResultEx.operationType;
        if (operationResultEx.operationType == OperationType.ADD) {
            String string = UpdatesUtil.getResultEntityUidFromTaskInfo(clientTaskInfo, objectReferenceService);
            objectChangeInfo.objectId = UpdatesUtil.is60VcOperation(operationResultEx) ? (String)cornerCaseOperationHandler.handleOperation(operationResultEx).or((Object)string) : string;
            objectChangeInfo.object = clientTaskInfo.result;
        } else if (operationResultEx.operationType == OperationType.CHANGE || operationResultEx.operationType == OperationType.DELETE) {
            objectChangeInfo.objectId = UpdatesUtil.getEntityUidFromTaskInfo(clientTaskInfo, objectReferenceService);
            objectChangeInfo.object = clientTaskInfo.entity;
        }
        UpdatesUtil.sendModelChangedEvent(objectChangeInfo, messagingService);
    }

    public static boolean is60VcOperation(OperationResultEx operationResultEx) {
        ClientTaskInfo clientTaskInfo = operationResultEx.taskInfo;
        if (clientTaskInfo != null && clientTaskInfo.taskRef != null && clientTaskInfo.taskRef instanceof ManagedObjectReference) {
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)clientTaskInfo.taskRef;
            return !VcServiceUtil.is65VcOrLaterByServerGuid((String)managedObjectReference.getServerGuid());
        }
        if (operationResultEx.operationResult != null) {
            ManagedObjectReference managedObjectReference = null;
            if (operationResultEx.operationResult.entity != null && operationResultEx.operationResult.entity instanceof ManagedObjectReference) {
                managedObjectReference = (ManagedObjectReference)operationResultEx.operationResult.entity;
            } else if (operationResultEx.operationResult.result != null && operationResultEx.operationResult.result instanceof ManagedObjectReference) {
                managedObjectReference = (ManagedObjectReference)operationResultEx.operationResult.result;
            }
            if (managedObjectReference != null) {
                return !VcServiceUtil.is65VcOrLaterByServerGuid((String)managedObjectReference.getServerGuid());
            }
        }
        return false;
    }

    private static String getResultEntityUidFromTaskInfo(ClientTaskInfo clientTaskInfo, ObjectReferenceService objectReferenceService) {
        String string = null;
        if (StringUtil.isNullOrEmpty((String)clientTaskInfo.resultEntityUid)) {
            if (clientTaskInfo.result != null) {
                string = objectReferenceService.getUid(clientTaskInfo.result, true);
            }
        } else {
            string = clientTaskInfo.resultEntityUid;
        }
        return string;
    }

    private static String getEntityUidFromTaskInfo(ClientTaskInfo clientTaskInfo, ObjectReferenceService objectReferenceService) {
        String string = null;
        if (StringUtil.isNullOrEmpty((String)clientTaskInfo.entityUid)) {
            if (clientTaskInfo.entity != null) {
                string = objectReferenceService.getUid(clientTaskInfo.entity, true);
            }
        } else {
            string = clientTaskInfo.entityUid;
        }
        return string;
    }

    private static void sendModelChangedEvent(ObjectChangeInfo objectChangeInfo, MessagingService messagingService) {
        if (objectChangeInfo == null || StringUtil.isNullOrEmpty((String)objectChangeInfo.objectId)) {
            return;
        }
        ModelChangeMessage modelChangeMessage = new ModelChangeMessage();
        modelChangeMessage.setObjectChangeInfo(objectChangeInfo);
        messagingService.sendMessage((Message)modelChangeMessage);
    }

    private static void processSyncOperationUpdates(OperationResultEx operationResultEx, ObjectReferenceService objectReferenceService, MessagingService messagingService) {
        Object object;
        if (operationResultEx.operationResult.error != null) {
            return;
        }
        ObjectChangeInfo objectChangeInfo = new ObjectChangeInfo();
        objectChangeInfo.operationType = operationResultEx.operationType;
        if (operationResultEx.operationType == OperationType.ADD) {
            Object object2 = operationResultEx.operationResult.result != null ? operationResultEx.operationResult.result : operationResultEx.operationResult.entity;
            if (object2 != null) {
                objectChangeInfo.objectId = objectReferenceService.getUid(object2, true);
                objectChangeInfo.object = object2;
            }
        } else if ((operationResultEx.operationType == OperationType.CHANGE || operationResultEx.operationType == OperationType.DELETE) && (object = operationResultEx.operationResult.entity) != null) {
            objectChangeInfo.objectId = objectReferenceService.getUid(object, true);
            objectChangeInfo.object = object;
        }
        UpdatesUtil.sendModelChangedEvent(objectChangeInfo, messagingService);
    }

    private static QuerySpec createRecentTasksSpec() {
        Constraint constraint;
        QuerySpec querySpec = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        PropertySpec propertySpec = new PropertySpec();
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = -1;
        resourceSpec.constraint = constraint = UpdatesUtil.createRecentTaskSearchConstraint();
        propertySpec.propertyNames = new String[1];
        propertySpec.propertyNames[0] = "info";
        resourceSpec.propertySpecs = new PropertySpec[1];
        resourceSpec.propertySpecs[0] = propertySpec;
        querySpec.name = "vsphere:Task-info";
        querySpec.resourceSpec = resourceSpec;
        querySpec.resultSpec = resultSpec;
        return querySpec;
    }

    private static Constraint createRecentTaskSearchConstraint() {
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.propertyName = "info.recentTasks";
        propertyConstraint.comparableValue = true;
        propertyConstraint.targetType = "vsphere:Task";
        propertyConstraint.comparator = Comparator.EQUALS;
        return propertyConstraint;
    }
}

