/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.update.monitor.impl;

import com.vmware.vise.core.model.ObjectChangeInfo;
import com.vmware.vise.core.model.OperationType;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.messaging.update.monitor.MonitoredEntity;
import com.vmware.vise.vim.messaging.update.monitor.ObjectChangeService;
import com.vmware.vise.vim.messaging.update.monitor.impl.ObjectGeneration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenerationNumbersChangeService
implements ObjectChangeService {
    private static final Log _logger = LogFactory.getLog(GenerationNumbersChangeService.class);
    private final Map<String, ObjectGeneration> _generationCache = new HashMap<String, ObjectGeneration>();
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _queryBuilder;
    private final ObjectReferenceService _objRefService;

    public GenerationNumbersChangeService(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, ObjectReferenceService objectReferenceService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{queryExecutor, querySpecBuilder, objectReferenceService});
        this._queryExecutor = queryExecutor;
        this._queryBuilder = querySpecBuilder;
        this._objRefService = objectReferenceService;
    }

    @Override
    public List<ObjectChangeInfo> getChanges(List<MonitoredEntity> list) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{list});
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        Object[] objectArray = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = list.get((int)i).entity;
        }
        QuerySpec querySpec = this._queryBuilder.buildQuerySpec(objectArray, new String[]{"@generation"});
        ResultSet resultSet = this._queryExecutor.getData(querySpec);
        List<ObjectChangeInfo> list2 = this.computeChangesAndUpdateCache(list, resultSet);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ObjectChangeInfo> computeChangesAndUpdateCache(List<MonitoredEntity> list, ResultSet resultSet) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (MonitoredEntity object2 : list) {
            hashMap.put(this.getUid(object2.entity), object2.entity);
        }
        ArrayList arrayList = new ArrayList();
        Map<String, ObjectGeneration> map = this._generationCache;
        synchronized (map) {
            for (ResultItem resultItem : resultSet.items) {
                String string = this.getUid(resultItem.resourceObject);
                ObjectGeneration objectGeneration = this._generationCache.containsKey(string) ? this._generationCache.get(string) : ObjectGeneration.UNKNOWN;
                ObjectGeneration objectGeneration2 = ObjectGeneration.fromResultItem(resultItem);
                if (objectGeneration2.isNewer(objectGeneration)) {
                    this._generationCache.put(string, objectGeneration2);
                    MonitoredEntity monitoredEntity = null;
                    for (MonitoredEntity monitoredEntity2 : list) {
                        if (!monitoredEntity2.entity.equals(resultItem.resourceObject)) continue;
                        monitoredEntity = monitoredEntity2;
                        break;
                    }
                    if (monitoredEntity == null) {
                        _logger.warn((Object)("Could not find object id: " + resultItem.resourceObject));
                        continue;
                    }
                    if (monitoredEntity.operationType == OperationType.CHANGE) {
                        arrayList.add(this.createObjectChangeInfo(resultItem.resourceObject, OperationType.CHANGE));
                    }
                }
                if (!hashMap.containsKey(string)) continue;
                hashMap.remove(string);
            }
        }
        if (!hashMap.isEmpty()) {
            arrayList.addAll(this.createObjectChangeInfo(hashMap.values(), OperationType.DELETE));
        }
        return arrayList;
    }

    private List<ObjectChangeInfo> createObjectChangeInfo(Collection<Object> collection, OperationType operationType) {
        ArrayList<ObjectChangeInfo> arrayList = new ArrayList<ObjectChangeInfo>();
        for (Object object : collection) {
            arrayList.add(this.createObjectChangeInfo(object, operationType));
        }
        return arrayList;
    }

    private ObjectChangeInfo createObjectChangeInfo(Object object, OperationType operationType) {
        ObjectChangeInfo objectChangeInfo = new ObjectChangeInfo();
        objectChangeInfo.operationType = operationType;
        objectChangeInfo.object = object;
        objectChangeInfo.objectId = this.getUid(object);
        return objectChangeInfo;
    }

    private String getUid(Object object) {
        String string = this._objRefService.getUid(object, true);
        if (string == null) {
            throw new IllegalStateException("null reference uid for: " + object);
        }
        return string;
    }
}

