/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.update.monitor.impl;

import com.vmware.vise.core.model.ObjectChangeInfo;
import com.vmware.vise.core.model.OperationType;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.messaging.update.monitor.MonitoredEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MonitorRegistry {
    private static final Log _logger = LogFactory.getLog(MonitorRegistry.class);
    private static final long EXTENDED_MONITORING_DURATION = 120000L;
    private static final int FINAL_CHECK_COUNT = 2;
    private Map<Object, OperationType> _objects = new HashMap<Object, OperationType>();
    private Map<Object, ExtendedMonitoringData> _objectsForExtendedMonitoring = new HashMap<Object, ExtendedMonitoringData>();
    private Map<Object, FinalCheckData> _pendingFinalChecks = new HashMap<Object, FinalCheckData>();

    public synchronized void add(Object object, OperationType operationType) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object, operationType});
        this._objects.put(object, operationType);
        this.removePendingFinalCheck(object);
    }

    public synchronized void addFinalCheck(Object object, OperationType operationType, boolean bl) {
        Object object2;
        ValidationUtil.paramsNotNull((Object[])new Object[]{object, operationType});
        if (operationType != OperationType.DELETE) {
            object2 = new FinalCheckData();
            ((FinalCheckData)object2).reference = object;
            ((FinalCheckData)object2).numChecksLeft = 2;
            this._pendingFinalChecks.put(object, (FinalCheckData)object2);
        }
        if (bl) {
            object2 = new ExtendedMonitoringData();
            ((ExtendedMonitoringData)object2).reference = object;
            ((ExtendedMonitoringData)object2).startTime = new Date();
            ((ExtendedMonitoringData)object2).operationType = operationType;
            this._objectsForExtendedMonitoring.put(object, (ExtendedMonitoringData)object2);
        }
    }

    public synchronized void onCheckComplete(List<MonitoredEntity> list) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{list});
        if (list.isEmpty()) {
            return;
        }
        ArrayList<MonitoredEntity> arrayList = new ArrayList<MonitoredEntity>(list);
        for (MonitoredEntity monitoredEntity : arrayList) {
            long l;
            ExtendedMonitoringData extendedMonitoringData;
            FinalCheckData finalCheckData = this._pendingFinalChecks.get(monitoredEntity.entity);
            if (finalCheckData != null && --finalCheckData.numChecksLeft <= 0) {
                this.removePendingFinalCheck(monitoredEntity.entity);
                this._objects.remove(monitoredEntity.entity);
            }
            if ((extendedMonitoringData = this._objectsForExtendedMonitoring.get(monitoredEntity.entity)) == null || (l = System.currentTimeMillis() - extendedMonitoringData.startTime.getTime()) <= 120000L) continue;
            this._objectsForExtendedMonitoring.remove(monitoredEntity.entity);
        }
    }

    public synchronized List<MonitoredEntity> getMonitoredObjects() {
        ArrayList<MonitoredEntity> arrayList = new ArrayList<MonitoredEntity>();
        for (Map.Entry<Object, OperationType> object : this._objects.entrySet()) {
            arrayList.add(new MonitoredEntity(object.getKey(), object.getValue()));
        }
        for (ExtendedMonitoringData extendedMonitoringData : this._objectsForExtendedMonitoring.values()) {
            if (this._objects.containsKey(extendedMonitoringData.reference)) continue;
            arrayList.add(new MonitoredEntity(extendedMonitoringData.reference, extendedMonitoringData.operationType));
        }
        return arrayList;
    }

    public synchronized boolean hasObjectsForMonitoring() {
        return this._objects.size() > 0 || this._objectsForExtendedMonitoring.size() > 0;
    }

    public synchronized void removeDeleted(List<ObjectChangeInfo> list) {
        if (ArrayUtil.isNullOrEmpty(list)) {
            return;
        }
        for (ObjectChangeInfo objectChangeInfo : list) {
            if (objectChangeInfo.operationType != OperationType.DELETE) continue;
            OperationType operationType = this._objects.remove(objectChangeInfo.object);
            ExtendedMonitoringData extendedMonitoringData = this._objectsForExtendedMonitoring.remove(objectChangeInfo.object);
            if (operationType != null || extendedMonitoringData != null) continue;
            _logger.warn((Object)("Could not remove object from monitor: " + objectChangeInfo.object));
        }
    }

    private void removePendingFinalCheck(Object object) {
        this._pendingFinalChecks.remove(object);
    }

    private class ExtendedMonitoringData {
        public Object reference;
        public Date startTime;
        public OperationType operationType;

        private ExtendedMonitoringData() {
        }
    }

    private class FinalCheckData {
        public Object reference;
        public volatile int numChecksLeft;

        private FinalCheckData() {
        }
    }
}

