/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.update.monitor.impl;

import com.vmware.vise.core.model.Message;
import com.vmware.vise.core.model.ModelChangeMessage;
import com.vmware.vise.core.model.ObjectChangeInfo;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationType;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.messaging.MessagingService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.messaging.update.impl.OperationResultEx;
import com.vmware.vise.vim.messaging.update.monitor.MonitoredEntity;
import com.vmware.vise.vim.messaging.update.monitor.ObjectChangeMonitor;
import com.vmware.vise.vim.messaging.update.monitor.ObjectChangeService;
import com.vmware.vise.vim.messaging.update.monitor.impl.MonitorRegistry;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectChangeMonitorImpl
implements ObjectChangeMonitor,
Runnable {
    private final int POLL_INTERVAL = 1000;
    private static final Log _logger = LogFactory.getLog(ObjectChangeMonitorImpl.class);
    private ObjectChangeService _changeService;
    private MessagingService _messagingService;
    private MonitorRegistry _monitorRegistry;
    private volatile boolean _nextPollScheduled = false;
    private final ThreadFactory _schedulerThreadFactory = new WorkerThreadFactory("ObjectChangeMonitorScheduler");
    private ScheduledThreadPoolExecutor _scheduler = new ScheduledThreadPoolExecutor(1, this._schedulerThreadFactory);
    private HttpSession _session = null;

    public ObjectChangeMonitorImpl(ObjectChangeService objectChangeService, MessagingService messagingService) {
        this._changeService = objectChangeService;
        this._messagingService = messagingService;
        this._monitorRegistry = new MonitorRegistry();
        this._session = SessionUtil.getHttpSession();
    }

    @Override
    public synchronized void add(OperationResultEx operationResultEx) {
        OperationEffect operationEffect;
        if (operationResultEx == null) {
            return;
        }
        this.addEntity(operationResultEx.operationResult.entity, operationResultEx.operationType);
        if (operationResultEx.taskInfo != null && operationResultEx.taskInfo.entity != null && !operationResultEx.taskInfo.entity.equals(operationResultEx.operationResult.entity)) {
            this.addEntity(operationResultEx.taskInfo.entity, operationResultEx.operationType);
        }
        if ((operationEffect = operationResultEx.operationResult.effect) != null && operationEffect.affectedEntites != null) {
            Object[] objectArray;
            for (Object object : objectArray = operationEffect.affectedEntites) {
                this.addEntity(object, operationResultEx.operationType);
            }
        }
    }

    @Override
    public synchronized void addFinalCheck(OperationResultEx operationResultEx) {
        if (operationResultEx == null) {
            return;
        }
        OperationEffect operationEffect = operationResultEx.operationResult.effect;
        boolean bl = operationEffect != null && operationEffect.isDelayed;
        this._monitorRegistry.addFinalCheck(operationResultEx.operationResult.entity, operationResultEx.operationType, bl);
        if (operationResultEx.taskInfo != null && operationResultEx.taskInfo.entity != null && !operationResultEx.taskInfo.entity.equals(operationResultEx.operationResult.entity)) {
            this._monitorRegistry.addFinalCheck(operationResultEx.taskInfo.entity, operationResultEx.operationType, bl);
        }
        if (operationEffect != null && operationEffect.affectedEntites != null) {
            Object[] objectArray;
            for (Object object : objectArray = operationEffect.affectedEntites) {
                this._monitorRegistry.addFinalCheck(object, operationResultEx.operationType, bl);
            }
        }
    }

    public void shutdown() {
        this._scheduler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<MonitoredEntity> list = this._monitorRegistry.getMonitoredObjects();
        if (!list.isEmpty()) {
            List<ObjectChangeInfo> list2 = Collections.emptyList();
            try {
                SessionUtil.setHttpSession((HttpSession)this._session);
                list2 = this._changeService.getChanges(list);
                this.sendModelChangedEvent(list2);
            }
            catch (Exception exception) {
                if (exception instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
                _logger.error((Object)"Failed to detect changes.", (Throwable)exception);
            }
            finally {
                SessionUtil.setHttpSession(null);
                this.resetNextPollScheduled();
                this._monitorRegistry.onCheckComplete(list);
                this._monitorRegistry.removeDeleted(list2);
            }
        }
        this.scheduleNextPoll();
    }

    private synchronized void resetNextPollScheduled() {
        this._nextPollScheduled = false;
    }

    private synchronized void scheduleNextPoll() {
        if (!this._nextPollScheduled && this._monitorRegistry.hasObjectsForMonitoring()) {
            this._scheduler.schedule(this, 1000L, TimeUnit.MILLISECONDS);
            this._nextPollScheduled = true;
        }
    }

    private void sendModelChangedEvent(List<ObjectChangeInfo> list) {
        for (ObjectChangeInfo objectChangeInfo : list) {
            ModelChangeMessage modelChangeMessage = new ModelChangeMessage();
            modelChangeMessage.setObjectChangeInfo(objectChangeInfo);
            this._messagingService.sendMessage((Message)modelChangeMessage);
        }
    }

    private void addEntity(Object object, OperationType operationType) {
        this._monitorRegistry.add(object, operationType);
        this.scheduleNextPoll();
    }
}

