/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.google.common.collect.HashMultimap;
import com.vmware.cis.cm.common.EndpointUtil;
import com.vmware.cis.data.internal.adapters.lookup.ServiceEndpointInfo;
import com.vmware.cis.data.internal.adapters.lookup.ServiceLocator;
import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceEndPointType;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointTypeImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComponentManagerServiceLocator
implements ServiceLocator {
    private static final Logger _logger = LoggerFactory.getLogger(ComponentManagerServiceLocator.class);
    private final KeystoreService _truststoreProvider;
    private final ComponentManagerService _cm;
    private final Collection<LinkedVcGroup> _linkedVcGroups;

    public ComponentManagerServiceLocator(KeystoreService keystoreService, ComponentManagerService componentManagerService, Collection<LinkedVcGroup> collection) {
        Validate.notNull((Object)keystoreService, (String)"truststoreProvider");
        Validate.notNull((Object)componentManagerService, (String)"cm");
        Validate.notNull(collection, (String)"linkedVcGroups");
        this._truststoreProvider = keystoreService;
        this._cm = componentManagerService;
        this._linkedVcGroups = collection;
    }

    public Collection<ServiceEndpointInfo> findServiceEndpoints(String string, String string2, String string3, String string4) {
        Set<String> set = ComponentManagerServiceLocator.extractNodeIdsOfActiveVcServices(this._linkedVcGroups);
        if (set.isEmpty()) {
            _logger.warn("No target nodes found from the LinkedVcGroupRegistry. No Data Providers will be discovered.");
            return Collections.emptyList();
        }
        _logger.debug("DS federation will include the services on the nodes: {}", set);
        Map<String, Collection<EndpointAtNode>> map = this.findEndpoints(set, string, string2, string3, string4);
        ArrayList<ServiceEndpointInfo> arrayList = new ArrayList<ServiceEndpointInfo>();
        for (String string5 : map.keySet()) {
            for (EndpointAtNode endpointAtNode : map.get(string5)) {
                ServiceEndPoint serviceEndPoint = endpointAtNode.endpoint;
                String string6 = endpointAtNode.nodeId;
                String string7 = endpointAtNode.serviceId;
                ServiceEndpointInfo serviceEndpointInfo = new ServiceEndpointInfo(string5, serviceEndPoint.getUrl(), string6, this._truststoreProvider.getKeyStore(), serviceEndPoint.getEndPointType().getTypeId(), serviceEndPoint.getEndPointType().getEndPointProtocol(), string7);
                arrayList.add(serviceEndpointInfo);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    private Map<String, Collection<EndpointAtNode>> findEndpoints(Set<String> set, String string, String string2, String string3, String string4) {
        SearchCriteria searchCriteria = ComponentManagerServiceLocator.createSearchCriteria(string, string2, string3, string4);
        Object[] objectArray = this.searchCm(searchCriteria);
        if (ArrayUtils.isEmpty((Object[])objectArray)) {
            return Collections.emptyMap();
        }
        HashMultimap hashMultimap = HashMultimap.create();
        for (Object object : objectArray) {
            if (!set.contains(object.getFolder().getId())) {
                _logger.debug("Skipping discovered service {}:{} because it resides on node `{}' which is outside of the target node set: {}", new Object[]{object.getServiceType().getProductId(), object.getServiceType().getTypeId(), object.getFolder().getId(), set});
                continue;
            }
            if (!ComponentManagerServiceLocator.serviceTypeMatchesFilter(object.getServiceType(), string, string2)) continue;
            String string5 = ComponentManagerServiceLocator.makeServiceTypeId(object.getServiceType().getProductId(), object.getServiceType().getTypeId());
            String string6 = object.getFolder().getId();
            if (ArrayUtils.isEmpty((Object[])object.getServiceEndPoints())) {
                _logger.warn("No endpoints were returned by the Component Manager for entry {}. Entry ignored.", (Object)string5);
                continue;
            }
            ArrayList<EndpointAtNode> arrayList = new ArrayList<EndpointAtNode>(object.getServiceEndPoints().length);
            for (ServiceEndPoint serviceEndPoint : object.getServiceEndPoints()) {
                if (!ComponentManagerServiceLocator.endpointMatchesFilter(serviceEndPoint.getEndPointType(), string3, string4)) continue;
                EndpointUtil.applyLocalUrl((ServiceEndPoint)serviceEndPoint, (String)this._cm.getHostId(), (String)object.getHostId());
                arrayList.add(new EndpointAtNode(serviceEndPoint, string6, object.getServiceId()));
            }
            hashMultimap.putAll((Object)string5, arrayList);
        }
        return hashMultimap.asMap();
    }

    private ServiceInfo[] searchCm(SearchCriteria searchCriteria) {
        try {
            _logger.debug("Searching CM for services with criteria: {}", (Object)searchCriteria);
            Object[] objectArray = this._cm.search(searchCriteria);
            _logger.debug("CM search finished.");
            if (_logger.isTraceEnabled()) {
                _logger.trace("CM returned results: {}", (Object)Arrays.toString(objectArray));
            }
            return objectArray;
        }
        catch (ComponentManagerFault componentManagerFault) {
            throw new RuntimeException(String.format("Error while searching with service criteria '%s' in ComponentManager", searchCriteria), componentManagerFault);
        }
    }

    private static SearchCriteria createSearchCriteria(String string, String string2, String string3, String string4) {
        ServiceEndPointTypeImpl serviceEndPointTypeImpl;
        ServiceTypeImpl serviceTypeImpl;
        if (string != null && string2 != null) {
            serviceTypeImpl = new ServiceTypeImpl();
            serviceTypeImpl.setProductId(string);
            serviceTypeImpl.setTypeId(string2);
        } else {
            serviceTypeImpl = null;
        }
        if (string3 != null || string4 != null) {
            serviceEndPointTypeImpl = new ServiceEndPointTypeImpl();
            serviceEndPointTypeImpl.setTypeId(string3);
            serviceEndPointTypeImpl.setEndPointProtocol(string4);
        } else {
            serviceEndPointTypeImpl = null;
        }
        SearchCriteriaImpl searchCriteriaImpl = new SearchCriteriaImpl();
        searchCriteriaImpl.setServiceType((ServiceType)serviceTypeImpl);
        searchCriteriaImpl.setEndPointType((ServiceEndPointType)serviceEndPointTypeImpl);
        return searchCriteriaImpl;
    }

    private static Set<String> extractNodeIdsOfActiveVcServices(Collection<LinkedVcGroup> collection) {
        if (collection.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (LinkedVcGroup linkedVcGroup : collection) {
            Object[] objectArray = linkedVcGroup.getServiceEndPoints();
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            HashSet<String> hashSet2 = new HashSet<String>(linkedVcGroup.getVcServices().size());
            for (VcService vcService : linkedVcGroup.getVcServices()) {
                hashSet2.add(vcService.getServiceGuid());
            }
            hashSet2.add(linkedVcGroup.getStartUpVcService().getServiceGuid());
            for (Object object : objectArray) {
                if (!hashSet2.contains(object.getInstanceUuid())) continue;
                hashSet.add(object.getLduGuid());
            }
        }
        return hashSet;
    }

    private static boolean serviceTypeMatchesFilter(ServiceType serviceType, String string, String string2) {
        return !(string != null && !string.equals(serviceType.getProductId()) || string2 != null && !string2.equals(serviceType.getTypeId()));
    }

    private static boolean endpointMatchesFilter(ServiceEndPointType serviceEndPointType, String string, String string2) {
        return !(string != null && !string.equals(serviceEndPointType.getTypeId()) || string2 != null && !string2.equals(serviceEndPointType.getEndPointProtocol()));
    }

    private static String makeServiceTypeId(String string, String string2) {
        return string + ":" + string2;
    }

    private static final class EndpointAtNode {
        public final ServiceEndPoint endpoint;
        public final String nodeId;
        public final String serviceId;

        public EndpointAtNode(ServiceEndPoint serviceEndPoint, String string, String string2) {
            this.endpoint = serviceEndPoint;
            this.nodeId = string;
            this.serviceId = string2;
        }
    }
}

