/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.vise.data.adapters.core.InvalidPropertyNameException;
import com.vmware.vise.data.adapters.core.translator.CoreResourceModelResolver;
import com.vmware.vise.search.model.ModelInfo;
import com.vmware.vise.search.model.ModelUtils;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CorePropertyConverter {
    private static final String RESOURCE_MODEL_OBJECT = "Object";
    private static final String PROPERTY_ID = "id";
    private static final String PROPERTY_SERVER_GUID = "serverGuid";
    private static final String CORE_API_PROPERTY_SUFFIX_LENGTH = "length";
    private static final String CORE_API_PROPERTY_INSTANCE_ID = "@instanceUuid";
    private static final char VISE_API_PROPERTY_PATH_DELIMITER = '.';
    private static final Pattern PATH_SEGMENT_TYPE_HINT = Pattern.compile("\\[@type=['\"]?[\\w]+['\"]?\\]");
    private static final Logger logger = LoggerFactory.getLogger(CorePropertyConverter.class);
    private final CoreResourceModelResolver _resourceModelResolver;

    public CorePropertyConverter(CoreResourceModelResolver coreResourceModelResolver) {
        this._resourceModelResolver = coreResourceModelResolver;
    }

    public String toCoreProperty(String string, String string2) {
        Validate.notEmpty((String)string2);
        if (string2.endsWith("@modelKey")) {
            return "@modelKey";
        }
        if (PropertyUtil.isType((String)string2)) {
            return string2;
        }
        if (CorePropertyConverter.isObjectIdProperty(string, string2)) {
            return "@modelKey";
        }
        return this.regularOrSpecialToCoreProperty(string, string2);
    }

    private String regularOrSpecialToCoreProperty(String string, String string2) {
        String string3;
        boolean bl;
        if (string2.endsWith("._length")) {
            bl = true;
            int n = string2.length() - "._length".length();
            string3 = string2.substring(0, n);
        } else {
            bl = false;
            string3 = string2;
        }
        QualifiedProperty qualifiedProperty = this.regularToCoreProperty(string, string3);
        if (bl) {
            if (!qualifiedProperty.isVmodl1()) {
                throw new InvalidPropertyNameException(String.format("'%s' suffix is supported only for VMODL1 properties: '%s'", "._length", string2));
            }
            return qualifiedProperty.toString() + '/' + CORE_API_PROPERTY_SUFFIX_LENGTH;
        }
        if (qualifiedProperty.getSimpleProperty().equals(PROPERTY_SERVER_GUID)) {
            return QualifiedProperty.forModelAndSimpleProperty((String)qualifiedProperty.getResourceModel(), (String)CORE_API_PROPERTY_INSTANCE_ID).toString();
        }
        return qualifiedProperty.toString();
    }

    private QualifiedProperty regularToCoreProperty(String string, String string2) {
        String string3;
        assert (string2 != null);
        CorePropertyConverter.rejectForbiddenChar(string, string2, '_');
        string2 = PATH_SEGMENT_TYPE_HINT.matcher(string2).replaceAll("");
        CorePropertyConverter.rejectForbiddenChar(string, string2, '@');
        ModelInfo modelInfo = ModelUtils.getModelInfo((String)string2);
        String string4 = modelInfo.getPropertyName().replace('.', '/');
        if (modelInfo.getModel() != null) {
            if (!string4.equals(modelInfo.getPropertyName())) {
                logger.warn("Model-qualified properties must use `/' as a path separator, but `.' was used in: {}", (Object)string2);
            }
            return QualifiedProperty.forModelAndSimpleProperty((String)modelInfo.getModel(), (String)string4);
        }
        if (StringUtils.isEmpty((String)string)) {
            throw new InvalidPropertyNameException(String.format("Must specify resource type or resource model for property '%s'", string2));
        }
        try {
            string3 = this._resourceModelResolver.getDefaultModel(string);
        }
        catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
            throw new InvalidPropertyNameException(runtimeException.getMessage(), runtimeException);
        }
        return QualifiedProperty.forModelAndSimpleProperty((String)string3, (String)string4);
    }

    static boolean isObjectIdProperty(String string, String string2) {
        return RESOURCE_MODEL_OBJECT.equals(string) && PROPERTY_ID.equals(string2);
    }

    private static void rejectForbiddenChar(String string, String string2, char c) {
        if (string2.indexOf(c) >= 0) {
            throw new InvalidPropertyNameException(String.format("Invalid character '%c' found in property name '%s' for type '%s'", Character.valueOf(c), string2, string));
        }
    }
}

