/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.google.common.collect.Multimap;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.vise.data.PropertySpec;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public final class CoreRequest {
    private final List<ChunkQuery> _chunkQueries;
    private final int _offset;
    private final int _limit;

    public CoreRequest(List<ChunkQuery> list, int n, int n2) {
        this._chunkQueries = list;
        this._offset = n;
        this._limit = n2;
    }

    public List<ChunkQuery> getChunkQueries() {
        return this._chunkQueries;
    }

    public int getOffset() {
        return this._offset;
    }

    public int getLimit() {
        return this._limit;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public static final class RelatedPropertyInfo {
        public final String viseRelation;
        public final Set<String> viseProperties;

        public static RelatedPropertyInfo of(String string, String[] stringArray) {
            assert (string != null);
            assert (stringArray != null);
            HashSet<String> hashSet = new HashSet<String>(stringArray.length);
            Collections.addAll(hashSet, stringArray);
            return new RelatedPropertyInfo(string, hashSet);
        }

        private RelatedPropertyInfo(String string, Set<String> set) {
            this.viseRelation = string;
            this.viseProperties = Collections.unmodifiableSet(set);
        }

        public String toString() {
            return "RelatedPropertyInfo(relation=" + this.viseRelation + "; properties=[" + StringUtils.join(this.viseProperties, (String)", ") + "])";
        }
    }

    static class RelatedOrderingInfo {
        public final String viseRelation;
        final int position;
        final SortCriterion.SortDirection direction;
        final String[] viseProperties;

        RelatedOrderingInfo(String string, int n, SortCriterion.SortDirection sortDirection, String[] stringArray) {
            assert (string != null);
            assert (sortDirection != null);
            assert (!ArrayUtils.isEmpty((Object[])stringArray));
            this.viseRelation = string;
            this.position = n;
            this.direction = sortDirection;
            this.viseProperties = stringArray;
        }
    }

    public static final class ChunkQuery {
        private final Query _coreQuery;
        private final Multimap<String, String> _returnByCoreNameMapping;
        private final Multimap<String, RelatedPropertyInfo> _relatedPropertyInfosByCoreRelation;
        private final Map<String, PropertySpec> _facetByCoreNameMapping;
        private final ChunkOrdering _chunkOrdering;
        private final List<SortCriterion> _sortClauseProjection;
        private final Multimap<String, RelatedOrderingInfo> _relatedOrderingInfosByCoreRelation;

        public ChunkQuery(Query query, Multimap<String, String> multimap, Multimap<String, RelatedPropertyInfo> multimap2, Map<String, PropertySpec> map, ChunkOrdering chunkOrdering, List<SortCriterion> list, Multimap<String, RelatedOrderingInfo> multimap3) {
            this._coreQuery = query;
            this._returnByCoreNameMapping = multimap;
            this._relatedPropertyInfosByCoreRelation = multimap2;
            this._facetByCoreNameMapping = map;
            this._chunkOrdering = chunkOrdering;
            this._sortClauseProjection = list;
            this._relatedOrderingInfosByCoreRelation = multimap3;
        }

        public Query getCoreQuery() {
            return this._coreQuery;
        }

        public Multimap<String, String> getReturnByCoreNameMapping() {
            return this._returnByCoreNameMapping;
        }

        public Multimap<String, RelatedPropertyInfo> getRelatedPropertyInfosByCoreRelation() {
            return this._relatedPropertyInfosByCoreRelation;
        }

        public Map<String, PropertySpec> getFacetByCoreNameMapping() {
            return this._facetByCoreNameMapping;
        }

        public ChunkOrdering getChunkOrdering() {
            return this._chunkOrdering;
        }

        public List<SortCriterion> getSortClauseProjection() {
            return this._sortClauseProjection;
        }

        public Multimap<String, RelatedOrderingInfo> getRelatedOrderingInfosByCoreRelation() {
            return this._relatedOrderingInfosByCoreRelation;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
    }

    public static enum ChunkOrdering {
        NONE,
        CLIENT_SIDE,
        SORTED;

    }
}

