/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.google.common.collect.HashMultimap;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.adapters.core.translator.ResultSetTable;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.FacetValue;
import com.vmware.vise.data.query.PropertyConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class CurrentObjectPropertyFacets {
    public List<FacetInfo> get(List<ResutlSetFacetSpec> list) {
        HashMultimap hashMultimap = HashMultimap.create();
        for (ResutlSetFacetSpec object : list) {
            for (Map.Entry<String, PropertySpec> entry : object.getFacetByCorePropertyMapping().entrySet()) {
                String string = entry.getKey();
                PropertySpec propertySpec = entry.getValue();
                List<Object> list2 = ResultSetTable.getProperty(object.getCoreResult(), string);
                for (Object object2 : list2) {
                    if (object2 == null) continue;
                    hashMultimap.put((Object)propertySpec, object2);
                }
            }
        }
        ArrayList arrayList = new ArrayList(hashMultimap.keySet().size());
        for (Map.Entry entry : hashMultimap.asMap().entrySet()) {
            arrayList.add(this.createViseFacetInfo((PropertySpec)entry.getKey(), (Collection)entry.getValue()));
        }
        return arrayList;
    }

    private FacetInfo createViseFacetInfo(PropertySpec propertySpec, Collection<Object> collection) {
        FacetValue[] facetValueArray = new FacetValue[collection.size()];
        int n = 0;
        for (Object object : collection) {
            PropertyConstraint propertyConstraint = new PropertyConstraint();
            propertyConstraint.targetType = propertySpec.type;
            propertyConstraint.propertyName = propertySpec.propertyNames[0];
            propertyConstraint.comparator = Comparator.EQUALS;
            propertyConstraint.comparableValue = object;
            FacetValue facetValue = new FacetValue();
            facetValue.value = object;
            facetValue.constraint = propertyConstraint;
            facetValueArray[n] = facetValue;
            ++n;
        }
        FacetInfo facetInfo = new FacetInfo();
        facetInfo.propSpec = propertySpec;
        facetInfo.facetValues = facetValueArray;
        return facetInfo;
    }

    public static final class ResutlSetFacetSpec {
        private final ResultSet coreResult;
        private final Map<String, PropertySpec> facetByCorePropertyMapping;

        public ResutlSetFacetSpec(ResultSet resultSet, Map<String, PropertySpec> map) {
            this.coreResult = resultSet;
            this.facetByCorePropertyMapping = map;
        }

        public ResultSet getCoreResult() {
            return this.coreResult;
        }

        public Map<String, PropertySpec> getFacetByCorePropertyMapping() {
            return this.facetByCorePropertyMapping;
        }
    }
}

